;	WinSTon

;	CLR Dn
;	CLR <ea>

;	XNZVC
;	-0100

PUBLIC _clr_dn_byte
PUBLIC _clr_dn_word
PUBLIC _clr_dn_long
PUBLIC _clr_ea_byte
PUBLIC _clr_ea_word
PUBLIC _clr_ea_long

;-----------------------------------------------------------------------
;CLR.B Dn
_clr_dn_byte PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		al,EMU_Z								;Set Z(ignore X)
	mov		BYTE PTR[edx],0							;Clear
	FRET
_clr_dn_byte ENDP

;CLR.W Dn
_clr_dn_word PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		al,EMU_Z								;Set Z(ignore X)
	mov		WORD PTR[edx],0							;Clear
	FRET
_clr_dn_word ENDP

;CLR.L Dn
_clr_dn_long PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		al,EMU_Z								;Set Z(ignore X)
	mov		DWORD PTR [edx],0						;Clear
	FRET
_clr_dn_long ENDP

;-----------------------------------------------------------------------
;CLR.B <ea>
_clr_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		ebx,ebx									;Clear
	mov		al,EMU_Z								;Set Z(ignore X)
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_clr_ea_byte ENDP

;CLR.W <ea>
_clr_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		ebx,ebx									;Clear
	mov		al,EMU_Z								;Set Z(ignore X)
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	FRET
_clr_ea_word ENDP

;CLR.L <ea>
_clr_ea_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		ebx,ebx									;Clear
	mov		al,EMU_Z								;Set Z(ignore X)
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	FRET
_clr_ea_long ENDP
