;	WinSTon

;	ADDI #<data>,Dn
;	ADDI #<data>,<ea>

;	XNZVC
;	*****

PUBLIC _addi_imm_dn_byte
PUBLIC _addi_imm_dn_word
PUBLIC _addi_imm_dn_long
PUBLIC _addi_imm_ea_byte
PUBLIC _addi_imm_ea_word
PUBLIC _addi_imm_ea_long

;-----------------------------------------------------------------------
;ADDI.B #<data>,Dn
_addi_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	mov		edx,DECODE_1[ecx]						;<ea>
	add		[edx],bl								;Dest Dn
	SET_NZV_CX_SAME
_addi_imm_dn_byte ENDP

;ADDI.W #<data>,Dn
_addi_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	add		[edx],bx								;Dest Dn
	SET_NZV_CX_SAME
_addi_imm_dn_word ENDP

;ADDI.L #<data>,Dn
_addi_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	add		[edx],ebx								;Dest Dn
	SET_NZV_CX_SAME
_addi_imm_dn_long ENDP

;-----------------------------------------------------------------------
;ADDI.B #<data>,<ea>
_addi_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	EFFADDR_READ									;Read <ea>
	add		bl,dl
	WRITE_BYTE_NZV_CX_SAME
_addi_imm_ea_byte ENDP

;ADDI.W #<data>,<ea>
_addi_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	add		bx,dx
	WRITE_WORD_NZV_CX_SAME
_addi_imm_ea_word ENDP

;ADDI.L #<data>,<ea>
_addi_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	add		ebx,edx
	WRITE_LONG_NZV_CX_SAME
_addi_imm_ea_long ENDP
