/*
-----------------------------------------------------------------------------
 Class: RageSoundStream

 Desc: streaming music support.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/

#ifndef RAGE_SOUND_STREAM_H
#define RAGE_SOUND_STREAM_H

#include "RageSound.h"
#include "..\Mp3Player.h"


class RageSoundStream
{
public:
	RageSoundStream();
	~RageSoundStream();

	virtual void Update( float fDeltaTime );

	void Load( CString sSoundFilePath, bool bAccurateSync = false );
	void LoadForInfo( CString sSoundFilePath, bool bAccurateSync = false );
	void LoadAndPlayIfNotAlready( CString sSoundFilePath );
	void Unload();

	void Play( bool bLoop = false, float fStartSeconds = -1, float fLengthSeconds = -1 );
	void Pause();
	void Stop();
	float GetLengthSeconds();
	float GetPositionSeconds();	// position of the most recent channel played
	void SetPositionSeconds( float fSeconds );
	bool SetPlaybackRate( float fScale );
	float GetPlaybackRate() const;
	bool IsPlaying();

	void SetVolume( float fVolPercent );

	CString GetLoadedFilePath() { return m_sFilePath; };

	Mp3Player m_mp3player ;
protected:
	CString m_sFilePath;
	HSTREAM m_hStream;
	DWORD	m_dwOriginalFreq;
	DWORD	m_dwCurrentFreq;
	float	m_fStartSeconds, m_fLengthSeconds;
	bool	m_bLoop;
	float	m_fFakePosition;	// this is used as a position when music does not play
	bool    m_bPlaying;
};


extern RageSoundStream*		MUSIC;	// global and accessable from anywhere in our program

#endif