#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: RageSoundStream

 Desc: See header.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/

#include "RageSoundStream.h"
#include "RageUtil.h"
#include "RageLog.h"
#include "RageException.h"


const float FADE_TIME = 1.5f;

#if 0

RageSoundStream::RageSoundStream() { return; }
RageSoundStream::~RageSoundStream() { return; }
void RageSoundStream::Unload() { return; }
void RageSoundStream::Load( CString sSoundFilePath, bool bAccurateSync ) { return; }
void RageSoundStream::LoadAndPlayIfNotAlready( CString sSoundFilePath ) { return; }
void RageSoundStream::Update( float fDeltaTime ) { }
void RageSoundStream::Play( bool bLoop, float fStartSeconds, float fLengthSeconds ) { }
void RageSoundStream::Pause() { }
void RageSoundStream::Stop() { }
float RageSoundStream::GetLengthSeconds() { return 0; }
float RageSoundStream::GetPositionSeconds() { return 0; }
void RageSoundStream::SetPositionSeconds( float fSeconds ) { }
bool RageSoundStream::SetPlaybackRate( float fScale ) { return true; }
float RageSoundStream::GetPlaybackRate() const { return 0; }
bool RageSoundStream::IsPlaying() { return true; }
void RageSoundStream::SetVolume( float fVolPercent ) { return; }

#else

RageSoundStream::RageSoundStream()
{
	//return ;

	m_hStream = NULL;
	m_fStartSeconds = m_fLengthSeconds = -1;
	m_bLoop = false;
	m_fFakePosition = 0;
	m_bPlaying = false;

	m_mp3player.dsound = g_dsound ;
	m_mp3player.dsound_init() ;
	Insert_Mp3Player( &m_mp3player ) ;
}

RageSoundStream::~RageSoundStream()
{
	//return ;

	writexbox("killing sound stream\r\n") ;
	Unload();
	Remove_Mp3Player( &m_mp3player ) ;
	writexbox("killing sound stream finished\r\n") ;
}

void RageSoundStream::Unload()
{
	//return ;

	writexbox("doing unload soundstream\r\n");
	m_sFilePath = "";

	Stop();
	//BASS_StreamFree( m_hStream );
	m_hStream = NULL;
	writexbox("finished unload soundstream\r\n");
}

void RageSoundStream::LoadForInfo( CString sSoundFilePath, bool bAccurateSync )
{
}

void RageSoundStream::Load( CString sSoundFilePath, bool bAccurateSync )
{
	//return ;
	LOG->Trace( "RageSound::LoadSound( '%s' )", sSoundFilePath );

	//sprintfx("soundstream load %s\r\n",sSoundFilePath) ;

	Unload();

	m_sFilePath = sSoundFilePath;

	if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
	{
		m_mp3player.loadFile( (char*)(LPCTSTR)m_sFilePath, 0, 0, 999999999) ;
		m_mp3player.pause(TRUE) ;

		m_dwOriginalFreq = m_mp3player.m_decinfo.samprate ;
		ReleaseMutex(hSoundMutex) ;
	}



	//writexbox("load stream file\r\n" ) ;

	//m_hStream = BASS_StreamCreateFile( FALSE, const_cast<char*>((const char *)sSoundFilePath), 0, 0, bAccurateSync ? BASS_MP3_SETPOS:0 );
	//if( m_hStream == NULL )
		//throw RageException( "RageSound::LoadSound: error loading %s (error code %d)", sSoundFilePath, BASS_ErrorGetCode() );

	// save original frequency because we can't get it back after changing it
	//BASS_ChannelGetAttributes( m_hStream, &m_dwOriginalFreq, NULL, NULL );

	m_fFakePosition = 0;

	//sprintfx("soundstream finished load %s\r\n",sSoundFilePath) ;
}

void RageSoundStream::LoadAndPlayIfNotAlready( CString sSoundFilePath )
{
	//return ;
	//writexbox("load andplay\r\n") ;
	//sprintfx("loadandplay %s\r\n", sSoundFilePath ) ;


	if( m_sFilePath == sSoundFilePath  &&  MUSIC->IsPlaying() )
		return;		// do nothing

	Load( sSoundFilePath );
	m_mp3player.m_bRepeat = TRUE ;

	Play( true );
}


void RageSoundStream::Update( float fDeltaTime )
{
//	return ;
	if( m_bPlaying )
	{
		const float fOldPositionSeconds = m_fFakePosition;

		m_fFakePosition += GetPlaybackRate() * fDeltaTime;

		if( IsPlaying()  &&  GetPositionSeconds() > 0.2f )
			m_fFakePosition = GetPositionSeconds();	// override with real position


		if( fOldPositionSeconds < 0  &&  m_fFakePosition > 0 )	// crossed 0
			Play();

	}

	if( m_fStartSeconds != -1  &&  m_fLengthSeconds != -1  )
	{
		if( GetPositionSeconds() > m_fStartSeconds + m_fLengthSeconds )
		{
			if( m_bLoop )
			{
				this->SetPositionSeconds( m_fStartSeconds );
				SetVolume( 1.00f );
			}
			else
				this->Stop();

		}
		else if( GetPositionSeconds() > m_fStartSeconds + m_fLengthSeconds - FADE_TIME )
		{
			// fade out
			float fSecsUntilSilent = (m_fStartSeconds + m_fLengthSeconds) - GetPositionSeconds();
			float fVolPercent = fSecsUntilSilent / FADE_TIME;
			SetVolume( max(0.0f,fVolPercent) );
		}
	}
}

void RageSoundStream::Play( bool bLoop, float fStartSeconds, float fLengthSeconds )
{
	//return ;
	//writexbox("soundstream play\r\n") ;
	m_bPlaying = true;
	int start,end ;

	//writexbox("soundstream play\r\n") ;
	if( m_fFakePosition < 0  ||  m_fFakePosition > GetPositionSeconds())
		return;

	//writexbox("soundstream play\r\n") ;
	m_fStartSeconds = fStartSeconds;
	m_fLengthSeconds = fLengthSeconds;
	m_bLoop = bLoop;


	if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
	{
		//writexbox("soundstream play\r\n") ;
		m_mp3player.m_bRepeat = bLoop ;

		//writexbox("soundstream play\r\n") ;
		SetVolume( 1 );

		//writexbox("play stream\r\n") ;

	//	if( FALSE == BASS_StreamPlay( m_hStream, FALSE, m_bLoop ? BASS_SAMPLE_LOOP : 0 ) )
			//throw RageException( "RageSoundStream: Error playing a sound stream." );

		//writexbox("soundstream play\r\n") ;
		if( m_fStartSeconds != -1 )
		{

		//writexbox("soundstream playss\r\n") ;
			float newpos = (((float)m_mp3player.m_framebytes) * m_fStartSeconds*500.0f) / 13.0f ;


			if ( newpos < m_mp3player.m_mp3BufSize )
			{
				m_mp3player.m_mp3BytesInBuf = m_mp3player.m_mp3BufSize - newpos ;
				m_mp3player.m_mp3ReadDataPos = m_mp3player.m_pMp3BufferData + ((int)newpos) ;
				m_mp3player.findframe() ;
				m_mp3player.m_nFrameOffset = ( newpos / (float)m_mp3player.m_framebytes ) ;

				start = m_mp3player.m_nFrameOffset ;
			}
			else
			{
				start = 0 ;
			}
		//writexbox("soundstream playss\r\n") ;

		//sprintfx("startsecs=%3.5f, newpos=%3.5f, fb=%u, bib=%u, bufsz=%u, rdpos=%u\r\n", m_fStartSeconds, 
			//newpos, m_mp3player.m_framebytes, m_mp3player.m_mp3BytesInBuf, m_mp3player.m_mp3ReadDataPos) ;


		}
		else
		{
		//writexbox("soundstream playtt\r\n") ;
			start = 0 ;
		}

		if ( m_fLengthSeconds != -1 )
		{
		//writexbox("soundstream playuu\r\n") ;
			float newpos = (m_fLengthSeconds*500.0f) / 13.0f ;

			m_mp3player.m_nNumFrames = newpos + m_mp3player.m_nFrameOffset ;

		//writexbox("soundstream playuu\r\n") ;
			end = m_mp3player.m_nNumFrames ;
		}
		else
		{
		//writexbox("soundstream playvv\r\n") ;
			end = 999999999 ;
		}

		//writexbox("soundstream play\r\n") ;

		//start = 0 ; end = 999999999 ;

		//writexbox("soundstream play\r\n") ;
		m_mp3player.loadFile( (char*)(LPCTSTR)m_sFilePath, bLoop, start, end) ;
		//writexbox("soundstream play\r\n") ;

		if ( m_mp3player.m_bDone == 1 )
			m_mp3player.loadFile( (char*)(LPCTSTR)m_sFilePath, bLoop, 0, 999999999) ;

		m_mp3player.pause(FALSE) ;
		//writexbox("soundstream play\r\n") ;

		ReleaseMutex(hSoundMutex) ;
	}
}

void RageSoundStream::Pause()
{
	//return ;

	m_bPlaying = false;

	m_mp3player.pause(TRUE) ;

	//writexbox("pause stream\r\n") ;
	//if( FALSE == BASS_ChannelPause( m_hStream ) )
		//LOG->Trace( "WARNING!  Error pausing a sound stream." );
}

void RageSoundStream::Stop()
{
	//return ;
	writexbox("stopping sound stream\r\n") ;

	m_bPlaying = false;
	m_fFakePosition = 0;

	if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
	{
		m_mp3player.stop() ;
		ReleaseMutex(hSoundMutex) ;
	}
	writexbox("stopping sound stream\r\n") ;
	//writexbox("stop stream\r\n") ;

//	if( FALSE == BASS_ChannelStop( m_hStream ) )
		//throw RageException( "There was an error stopping a sound stream.  Are you sure this is a valid HSTREAM?" );
}

float RageSoundStream::GetLengthSeconds()
{
	//return 0 ;

	float datasize = m_mp3player.m_mp3BufSize ;
	float samplesize = m_mp3player.m_framebytes ;

	if ( samplesize == 0 )
		return 0 ;



	return (datasize*13.0f)/(samplesize*500.0f) ;
	//writexbox("get stream length in seconds\r\n") ;

	//QWORD qwLength = BASS_StreamGetLength( m_hStream ); 
	//float fSeconds = BASS_ChannelBytes2Seconds( m_hStream, qwLength );
	//return fSeconds;
	//return 0 ;
}

float RageSoundStream::GetPositionSeconds()
{
	//return 0 ;

	if( !IsPlaying() )
		return m_fFakePosition;


	float posinfile = m_mp3player.m_mp3ReadDataPos - ( m_mp3player.m_pMp3BufferData + ( m_mp3player.m_framebytes * m_mp3player.m_nFrameOffset ) ) ;

	if ( posinfile <= 0 )
		return 0 ;

	float samplesize = m_mp3player.m_framebytes ;

	if ( samplesize == 0 )
		return 0 ;

	//sprintfx("getpositionseconds = %f\r\n", (posinfile*13.0f)/(samplesize*500.0f) ) ;

	return (posinfile*13.0f)/(samplesize*500.0f) ;
	
	
	//writexbox("getposition stream\r\n") ;
	//QWORD qwPosition = BASS_ChannelGetPosition( m_hStream );
	//float fSeconds = BASS_ChannelBytes2Seconds( m_hStream, qwPosition );
	//return fSeconds;
	//return 0 ;
}

void RageSoundStream::SetPositionSeconds( float fSeconds )
{
	//return  ;

	if( fSeconds < 0  ||  fSeconds > GetLengthSeconds() )
	{
		m_fFakePosition = fSeconds;
		fSeconds = 0;	// fall through to below
		return ;
	}

	float newpos = (((float)m_mp3player.m_framebytes) * fSeconds*500.0f) / 13.0f ;

		if ( newpos < m_mp3player.m_mp3BufSize )
		{

			if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
			{
				m_mp3player.m_mp3BytesInBuf = m_mp3player.m_mp3BufSize - newpos ;
				m_mp3player.m_mp3ReadDataPos = m_mp3player.m_pMp3BufferData + ((int)newpos) ;
				m_mp3player.findframe() ;
				ReleaseMutex(hSoundMutex) ;
			}
		}

	//writexbox("set position in seconds\r\n") ;

	//QWORD qwPosition = BASS_ChannelSeconds2Bytes( m_hStream, fSeconds );
	//ASSERT( qwPosition != 0xffffffff );
	//BOOL bResult = BASS_ChannelSetPosition( m_hStream, qwPosition );
	//ASSERT( bResult );
}

bool RageSoundStream::SetPlaybackRate( float fScale )
{
	//return true;
	//writexbox("set stream playback rate\r\n") ;

	//sprintfx("setting freq to %u\r\n", int(m_dwOriginalFreq * fScale) ) ;

	if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
	{
		m_mp3player.stream_buffer->SetFrequency( int(m_dwOriginalFreq * fScale) ) ;
		ReleaseMutex(hSoundMutex) ;
	}
	
	m_dwCurrentFreq = int(m_dwOriginalFreq * fScale) ;

	//return BASS_ChannelSetAttributes( m_hStream, int(m_dwOriginalFreq * fScale), -1, -101 ) != 0;
	return TRUE ;
}

float RageSoundStream::GetPlaybackRate() const
{
	//return 1 ;
	//writexbox("get stream playbackrate\r\n") ;

	//DWORD freq;
	//if( ! BASS_ChannelGetAttributes( m_hStream, &freq, NULL, NULL ) )
		//return 1;

	//return freq / (float)m_dwOriginalFreq;

	return ((float)m_dwCurrentFreq)/((float)(m_dwOriginalFreq)) ;
}


bool RageSoundStream::IsPlaying()
{
	//return false ;
	//writexbox("is stream playing\r\n") ;

	return ! ( m_mp3player.m_bDone || m_mp3player.m_bPaused ) ;

	//if( m_hStream == NULL )
		//return false;
	//else
		//return BASS_ChannelIsActive(m_hStream) == BASS_ACTIVE_PLAYING;
	//return FALSE ;
}

void RageSoundStream::SetVolume( float fVolPercent )
{
	//return ;
	//writexbox("set stream volume\r\n") ;


	m_mp3player.stream_buffer->SetVolume( 0.0f - (( 1.0f - fVolPercent )*100.0f) ) ;
	//if( m_hStream == NULL )
		//return;
	//BASS_ChannelSetAttributes( m_hStream, -1, (int)(fVolPercent*100), -1 );
}

#endif
