#ifndef RAGENETWORK_H
#define RAGENETWORK_H
/*
-----------------------------------------------------------------------------
 Class: RageError

 Desc: Class for thowing fatal error exceptions

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/

#include "..\cstring.h"
#include "..\carray.h"

struct _TCPsocket;
typedef struct _TCPsocket *TCPsocket;

struct _SDLNet_SocketSet;
typedef struct _SDLNet_SocketSet *SDLNet_SocketSet;


class Packet;

class RageNetwork
{
public:
	RageNetwork();
	~RageNetwork();

	virtual void Update( float fDeltaTime );

	void Init(bool bServer);
	void Quit();

	bool IsServer();

	bool Listen(unsigned short port);
	void StopListening();

	bool Connect(CString ip, unsigned short port);
	void Disconnect();
	void DisconnectAllClients();

	bool Send( Packet* pPacket );
	bool Recv( CArray<Packet,Packet> &aPacketsOut );

protected:
	void FreePrimarySock();
	void FreeClientSocks();

	bool m_bIsServer;	// false if client
	bool m_bIsListening;
	TCPsocket			m_priSock;			// client: active socket.  server: listen socket
	SDLNet_SocketSet	m_priSockSet;
//	vector<TCPsocket>	m_clientSocks;		// connections to client, used only if server
	SDLNet_SocketSet	m_clientSocksSet;
};


#define MAX_DATA_SIZE 256	// max TCP packet size is 1024, then leave some room for "type" and "size"

class Packet
{
public:
	Packet() { type=(Type)0; }
	~Packet() {}

	enum Type{ packet_chat } type;
	union
	{
		char data[MAX_DATA_SIZE];
		struct ChatData
		{
			char message[MAX_DATA_SIZE];
		};
		struct BroadcastData
		{
			//
		};

	};
};


extern RageNetwork*		NETWORK;	// global and accessable from anywhere in our program

#endif