#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: RageNetwork

 Desc: See header.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Brendan Walker
	Chris Danford
-----------------------------------------------------------------------------
*/

#include "RageNetwork.h"
#include "RageUtil.h"
#include "RageException.h"
#include "RageLog.h"
#include "RageTimer.h"
#include "RageException.h"

//#include "SDL_net-1.2.4/include/SDL_net.h"
//#pragma comment(lib, "SDL_net-1.2.4/lib/SDL_net.lib")


RageNetwork*		NETWORK	= NULL;

const int MAX_CLIENTS = 16;

/*
///////////////////////////////
//
//  THIS IS UNTESTED SINCE THE CONVERSION TO SDL_net!!!!!
//
///////////////////////////////
*/

RageNetwork::RageNetwork()
{
	m_bIsServer = false;
	m_bIsListening = false;

	m_priSock = 0;
	m_priSockSet = NULL;
	m_clientSocksSet = NULL;
}

RageNetwork::~RageNetwork()
{
	Quit();
}

void RageNetwork::Init(bool bServer)
{
	m_priSock = 0;
	m_bIsServer = false;
	m_bIsListening = false;

	SDL_Init(0);	// this may have already been init'd somewhere else

	if( SDLNet_Init() < 0 )
		throw RageException("SDLNet_Init: %s\n", SDLNet_GetError());
	
	m_bIsServer = bServer;

	// allocate socket sets
	m_priSockSet = SDLNet_AllocSocketSet(1);
	if(!m_priSockSet)
		throw RageException("SDLNet_AllocSocketSet: %s\n", SDLNet_GetError());

	m_clientSocksSet = SDLNet_AllocSocketSet(MAX_CLIENTS);
	if(!m_clientSocksSet)
		throw RageException("SDLNet_AllocSocketSet: %s\n", SDLNet_GetError());
}

void RageNetwork::Quit()
{
	FreePrimarySock();
	FreeClientSocks();
	SDLNet_FreeSocketSet( m_priSockSet );
	SDLNet_FreeSocketSet( m_clientSocksSet );
	SDLNet_Quit();
}

void RageNetwork::FreePrimarySock()
{
	if( m_priSock == NULL )
		return;

	SDLNet_TCP_DelSocket( m_priSockSet, m_priSock );
	SDLNet_TCP_Close( m_priSock );
	m_priSock = NULL;
	m_bIsListening = false;
}

void RageNetwork::FreeClientSocks()
{
	// I hope passing NULL to these is OK...
	for( unsigned int i=0; i<m_clientSocks.size(); i++ )
	{
		SDLNet_TCP_DelSocket( m_clientSocksSet, m_clientSocks[i] );
		SDLNet_TCP_Close( m_clientSocks[i] );
	}
	m_clientSocks.erase( m_clientSocks.begin(), m_clientSocks.end() );
}

bool RageNetwork::IsServer()
{
	return m_bIsServer;
}

bool RageNetwork::Listen(unsigned short port)
{
	ASSERT( m_bIsServer );

	FreePrimarySock();

	IPaddress ip;
	if( SDLNet_ResolveHost(&ip,NULL,port)==-1 )
	{
		LOG->Warn("SDLNet_ResolveHost: %s\n", SDLNet_GetError());
		return false;
	}

	m_priSock=SDLNet_TCP_Open(&ip);
	if( !m_priSock ) 
	{
		LOG->Warn("SDLNet_TCP_Open: %s\n", SDLNet_GetError());
		return false;
	}

	SDLNet_TCP_AddSocket( m_priSockSet, m_priSock );

	m_bIsListening = true;

	return true;
}

void RageNetwork::StopListening()
{
	if( m_bIsListening )
	{
		FreePrimarySock();   // turns m_bIsListening = false
	}
}

bool RageNetwork::Connect(CString host, unsigned short port) 
{
	FreePrimarySock();

	char szHost[1024];
	strcpy( szHost, host );

	IPaddress ip;
	if( SDLNet_ResolveHost(&ip,szHost,port)==-1 )
	{
		LOG->Warn("SDLNet_ResolveHost: %s\n", SDLNet_GetError());
		return false;
	}

	m_priSock=SDLNet_TCP_Open(&ip);
	if( !m_priSock ) 
	{
		LOG->Warn("SDLNet_TCP_Open: %s\n", SDLNet_GetError());
		return false;
	}

	SDLNet_TCP_AddSocket( m_priSockSet, m_priSock );

	return true;
}

void RageNetwork::Disconnect()
{
	FreePrimarySock();
}

void RageNetwork::Update( float fDeltaTime )
{
	// accept
	if( m_bIsListening )
	{
		ASSERT( m_bIsServer );

		TCPsocket new_sock = SDLNet_TCP_Accept( m_priSock ) ;
		if( new_sock == 0 )
			return;
 
		m_clientSocks.push_back( new_sock );
		SDLNet_TCP_AddSocket( m_clientSocksSet, new_sock );
	}

	return;
}


bool RageNetwork::Recv( CArray<Packet,Packet> &aPacketsOut ) 
{
//	LOG->Trace( "RageNetwork::Recv" );

	int numready;

	// read data from pirmary socket (if any)
	numready = SDLNet_CheckSockets(m_priSockSet, 0);
	if(numready==-1) 
	{
		LOG->Warn("SDLNet_CheckSockets: %s\n", SDLNet_GetError());
	}
	else if( numready )
	{
		if( SDLNet_SocketReady(m_priSock) ) 
		{
			Packet packet;
			SDLNet_TCP_Recv( m_priSock, &packet, sizeof(Packet) ); 
			aPacketsOut.push_back( packet );
		}
	}


	// read data from client sockets (if any)
	numready = SDLNet_CheckSockets(m_clientSocksSet, 0);
	if(numready==-1) 
	{
		LOG->Warn("SDLNet_CheckSockets: %s\n", SDLNet_GetError());
	}
	else if( numready )
	{
		for( unsigned int i=0; i<m_clientSocks.size(); i++ )
		{
			if( SDLNet_SocketReady(m_clientSocks[i]) ) 
			{
				Packet packet;
				SDLNet_TCP_Recv( m_clientSocks[i], &packet, sizeof(Packet) ); 
				aPacketsOut.push_back( packet );
			}
		}
	}

	return true;
}

bool RageNetwork::Send( Packet* pPacket ) 
{
	int result;

	result = SDLNet_TCP_Send(m_priSock,pPacket,sizeof(Packet));
	if( result<sizeof(Packet) )
	{
		LOG->Warn("SDLNet_TCP_Send: %s\n", SDLNet_GetError());
		return false;
		// It may be good to disconnect sock because it is likely invalid now.
	}

	return true;
}

