#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 File: RandomStream.h

 Desc: Holds multiple sounds samples and can play a random sound easily.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
-----------------------------------------------------------------------------
*/



#include "RandomStream.h"
#include "RageUtil.h"
#include "RageLog.h"



RandomStream::RandomStream()
{
	m_iIndexLastPlayed = -1;
}

RandomStream::~RandomStream()
{

}


bool RandomStream::LoadSoundDir( CString sDir )
{
	if( sDir == "" )
		return true;

	// make sure there's a backslash at the end of this path
	if( sDir[sDir.GetLength()-1] != '\\' )
		sDir += "\\";

	CStringArray arraySoundFiles;
	GetDirListing( sDir + "*.mp3", arraySoundFiles );
	GetDirListing( sDir + "*.wav", arraySoundFiles );
	GetDirListing( sDir + "*.ogg", arraySoundFiles );

	for( unsigned i=0; i<arraySoundFiles.GetSize(); i++ )
		LoadSound( sDir + arraySoundFiles[i] );

	return true;
}
	
bool RandomStream::LoadSound( CString sSoundFilePath )
{
	LOG->Trace( "RandomStream::LoadSound( %s )", sSoundFilePath );

	m_arrayFilePaths.Add( sSoundFilePath );

	return true;
}

void RandomStream::PlayRandom()
{
	// play one of the samples
	if( m_arrayFilePaths.GetSize()==0 )
	{
		LOG->Trace( "WARNING:  Tried to play a RandomStream that has 0 sounds loaded." );
		return;
	}

	int iIndexToPlay=0;
	for( int i=0; i<5; i++ )
	{
		iIndexToPlay = rand() % m_arrayFilePaths.GetSize();
		if( iIndexToPlay != m_iIndexLastPlayed )
			break;
	}

	SOUND->PlayOnceStreamed( m_arrayFilePaths[iIndexToPlay] );
	m_iIndexLastPlayed = iIndexToPlay;
}
