#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: RageSound

 Desc: See header.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/


#include "RageSound.h"
#include "RageUtil.h"
#include "RageLog.h"
#include "RageException.h"


RageSound*		SOUND	= NULL;

/* I use this to turn off sound, since Bass doesn't want to work under
 * VTune.  -glenn */
#if 0
RageSound::RageSound( HWND hWnd ) { }
RageSound::~RageSound() { }
void RageSound::PlayOnceStreamed( CString sPath ) { }
void RageSound::PlayOnceStreamedFromDir( CString sDir ) { }
#else

//#pragma comment(lib, "bass/bass.lib") 

#include "bass/bass.h"



RageSound::RageSound( HWND hWnd )
{
	//return ;

	Mp3Player *mp3player ;

	LOG->Trace( "RageSound::RageSound()" );

	m_hWndApp = hWnd;

	m_numPlayers = 0 ;

	m_mp3players = NULL ;

	m_numPlayers = 16 ;

	m_mp3players = (Mp3Player**)malloc( sizeof(mp3player)*m_numPlayers ) ;

	for ( int i = 0 ; i < m_numPlayers ; i++ )
		m_mp3players[i] = NULL ;

	/*
	// save the HWND
	if( !hWnd )
		throw RageException( "RageSound called with NULL hWnd." );

	if( BASS_GetVersion() != MAKELONG(1,6) )
		throw RageException( "BASS version 1.6 DLL could not be loaded.  Verify that Bass.dll exists in the program directory.");

	if( !BASS_Init( -1, 44100, BASS_DEVICE_LEAVEVOL|BASS_DEVICE_LATENCY, m_hWndApp ) )
	{
		throw RageException( 
			"There was an error while initializing your sound card.\n\n"
			"The most likely cause of this problem is that you do not have a sound card\n"
			"installed, or that you have not yet installed a driver for your sound card.\n"
			"Before running this program again, please verify that your sound card is\n"
			"is working in other applications."
		);
	}

	BASS_Start();

	ZeroMemory( &m_info, sizeof(m_info) );
	m_info.size = sizeof(m_info);
	BASS_GetInfo( &m_info );


	LOG->Trace( 
		"Sound card info:\n"
		" - play latency is %u ms\n"
		" - total device hardware memory is %u bytes\n"
		" - free device hardware memory is %u bytes\n"
		" - number of free sample slots in the hardware is %u\n"
		" - number of free 3D sample slots in the hardware is %u\n"
		" - min sample rate supported by the hardware is %u\n"
		" - max sample rate supported by the hardware is %u",
		m_info.latency,
		m_info.hwsize,
		m_info.hwfree,
		m_info.freesam,
		m_info.free3d,
		m_info.minrate,
		m_info.maxrate
		);
		*/


}

/*
DWORD WINAPI RageSound_ThreadFunc( LPVOID lpParam ) 
{ 
	Mp3Player mp3player ;
	char *filename = (char*)lpParam ;

	mp3player.dsound = g_dsound ;
	mp3player.dsound_init() ;

	mp3player.loadFile( filename, 0, 0, 999999999) ;
	mp3player.pause(FALSE) ;

	while ( !mp3player.m_bDone )
	{
		mp3player.process() ;
	}

    return 0; 
}
*/
RageSound::~RageSound()
{
	//return ;
	LOG->Trace( "RageSound::~RageSound()" );

	//BASS_Stop();
	//BASS_Free();

	if ( m_mp3players )
	{
		for ( int i = 0 ; i < m_numPlayers ; i++ )
		{
			if ( m_mp3players[i] )
			{
				Remove_Mp3Player( m_mp3players[i] ) ;
				delete m_mp3players[i] ;
			}
		}

		free(m_mp3players) ;
	}

	m_mp3players = NULL ;
	m_numPlayers = 0 ;

}

void RageSound::PlayOnceStreamed( CString sPath )
{

	//return ;
	Mp3Player *mp3player ;


	int numfree ;
	int availableSlot ;

	numfree = 0 ;


	for( int i = 0 ; i < m_numPlayers ; i++ )
	{
		if ( m_mp3players[i] )
		{
			if ( ( m_mp3players[i]->m_bDone ) || ( m_mp3players[i]->m_bPaused ) )
			{
				Remove_Mp3Player( m_mp3players[i] ) ;
				delete m_mp3players[i] ;
				m_mp3players[i] = NULL ;
				numfree++ ;
				availableSlot = i ;
			}
		}
		else
		{
			numfree++ ;
			availableSlot = i ;
		}
	}


	if ( numfree )
	{
		Mp3Player *mp3player ;

		mp3player = new Mp3Player ;

		mp3player->dsound = g_dsound ;
		mp3player->dsound_init() ;

		mp3player->loadFile( (char*)(LPCTSTR)sPath, 0, 0, 999999999) ;
		mp3player->pause(FALSE) ;


		//sprintfx("load file %s position %u\r\n", sPath, availableSlot ) ;
		m_mp3players[availableSlot] = mp3player ;

		Insert_Mp3Player( mp3player ) ;
	}


/*
	m_filename = sPath ;

	m_mp3player.loadFile( (char*)(LPCTSTR)m_filename, 0, 0, 999999999) ;
	m_mp3player.pause(FALSE) ;

	Insert_Mp3Player( &m_mp3player ) ;
*/
/*
	DWORD dwThreadId, dwThrdParam = 1; 

	
    m_hThread = CreateThread( 
        NULL,                        // (this parameter is ignored)
        0,                           // use default stack size  
        RageSound_ThreadFunc,                  // thread function 
        (LPVOID)(LPCTSTR)m_filename,                // argument to thread function 
        0,                           // use default creation flags 
        &dwThreadId);                // returns the thread identifier 
 
   // Check the return value for success. 
   if (m_hThread == NULL) 
   {
   }
   else 
   {
      CloseHandle( m_hThread );
   }

*/

	/*
	HSTREAM hStream = BASS_StreamCreateFile( FALSE, const_cast<char*>((const char *)sPath), 0, 0, BASS_STREAM_AUTOFREE );
	if( hStream == NULL )
		throw RageException( "RageSound: Error creating stream." );

	if( FALSE == BASS_StreamPlay( hStream, FALSE, 0 ) )
		throw RageException( "RageSound: Error playing a sound stream." );
*/
	// this stream will free itself when stopped 	
}

void RageSound::PlayOnceStreamedFromDir( CString sDir )
{
	//sprintfx("play from dir %s\r\n", sDir ) ;

	if( sDir == "" )
		return;

	// make sure there's a backslash at the end of this path
	if( sDir[sDir.GetLength()-1] != '\\' )
		sDir += "\\";

	//sprintfx("play from dir %s\r\n", sDir ) ;
	//sprintfx("play from dir %s\r\n", sDir+ "*.mp3" ) ;

	CStringArray arraySoundFiles;
	GetDirListing( sDir + "*.mp3", arraySoundFiles );
	GetDirListing( sDir + "*.wav", arraySoundFiles );
	GetDirListing( sDir + "*.ogg", arraySoundFiles );

	if( arraySoundFiles.GetSize() != 0 )
	{
		int index = rand() % arraySoundFiles.GetSize();
		PlayOnceStreamed( sDir + arraySoundFiles[index] );
	}
}
#endif
