#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "mp3.h"

int main(int argc,char* argv[]){
int e=-1;
int hdr=0;
  // Init decoder:
  MP3_Init();
  // Init audio device:
  if(!MP3_OpenDevice(NULL)){ printf("Can't open audio device\n");exit(1);}
  // Open MP3 file and init buffers:
  MP3_Open((argc>1)?argv[1]:"apoc.mp3",128*1024);
  MP3_SeekForward(7600);
  // Start player:
  MP3_Play();
  // Wait for EOF
  while(!MP3_eof){
     int len=MP3_FillBuffers(); // You have to call this if you're using buffers
     if(len) printf("FillBuffers %d\n",len);
     if(MP3_frames!=e){ e=MP3_frames;printf("\r%5d   ",e);fflush(stdout); }
     usleep(10000); // don't eat all of CPU
     if(!hdr && MP3_frames>5){MP3_PrintHeader();hdr=1;}
  }
  // Stop player:
  MP3_Stop();
  // Close file & buffers:
  MP3_Close();
  // Close audio device:
  MP3_CloseDevice();
return 0;
}
