#include <xtl.h>
#include "FontHelper.h"
#include <XBApp.h>


#ifdef __cplusplus
extern "C" {
#endif

void writexbox(char *msg) ;
void sprintfx( const char *fmt, ... );

#ifdef __cplusplus
}
#endif


//-----------------------------------------------------------------------------
// Name: CFontHelper()
// Desc: Help class constructor
//-----------------------------------------------------------------------------
CFontHelper::CFontHelper()
{
	m_bHaveTTF = 0 ;
	m_bHaveBig = 0 ;
	m_bHaveSmall = 0 ;
	m_bUseTTF = 0 ;
	m_bSmaller = FALSE ;
}

HRESULT CFontHelper::Initialize(LPDIRECT3DDEVICE8 d3dDevice)
{
    // Size of the Font Cache in Bytes
    DWORD dwFontCacheSize = 16 * 1024;
	DWORD res ;

	m_pd3dDevice = d3dDevice ;
	m_pd3dDevice->GetRenderTarget( &m_primarySurface ) ;

	res = S_OK ;

    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
	{
        res = XBAPPERR_MEDIANOTFOUND;
		m_bHaveBig = 0 ;
	}
	else
	{
		m_bHaveBig = 1 ;
	}

    // Create a font
    if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font12.xpr" ) ) )
	{
        res = XBAPPERR_MEDIANOTFOUND;
		m_bHaveSmall = 0 ;
	}
	else
	{
		m_bHaveSmall = 1 ;
	}

    // Create the Arial TrueTypeFont
    if( ( FAILED( XFONT_OpenTrueTypeFont( L"D:\\media\\fonts\\stdfont.ttf",
                                        dwFontCacheSize,&m_pConsoleTTF ) ) ) &&
        ( FAILED ( XFONT_OpenDefaultFont( &m_pConsoleTTF ) ) ) )
	{
		res = XBAPPERR_MEDIANOTFOUND ;
		m_bHaveTTF = 0 ;
	}
	else
	{
		m_pConsoleTTF->SetTextHeight( 24 );

		// Change Font Style - XFONT_NORMAL, XFONT_BOLD, 
		//                     XFONT_ITALICS, XFONT_BOLDITALICS
		m_pConsoleTTF->SetTextStyle( XFONT_NORMAL );

		// Anti-Alias the font -- 0 for no anti-alias, 2 for some, 4 for MAX!
		m_pConsoleTTF->SetTextAntialiasLevel( 0 );
		m_pConsoleTTF->SetTextColor( 0xFFFFFFFF ) ;
		m_pConsoleTTF->SetBkColor( 0x00000000 ) ;

		m_bHaveTTF = 1 ;
		m_bUseTTF = 1 ;
	}

	return res ;

}



//-----------------------------------------------------------------------------
// Name: ~CFontHelper()
// Desc: Help class destructor
//-----------------------------------------------------------------------------
CFontHelper::~CFontHelper()
{
    Destroy();
}


void CFontHelper::UseSmaller( BOOL smaller ) 
{
	m_bSmaller = smaller ;
}


//-----------------------------------------------------------------------------
// Name: Create()
// Desc: Creates the FontHelper class' internal objects
//-----------------------------------------------------------------------------
HRESULT CFontHelper::Create( LPDIRECT3DDEVICE8 pd3dDevice, LPDIRECT3DTEXTURE8 pd3dTexture, BOOL bManaged, FLOAT fSrcWidth, FLOAT fSrcHeight)
{

    return S_OK;
}

DWORD CFontHelper::GetFontHeight( ) 
{
	if ( m_bUseTTF && m_bHaveTTF )
	{
		unsigned int h,d ;
		m_pConsoleTTF->GetFontMetrics( &h, &d ) ;

		return h-d ;
	}
	else
	{
		return ( m_bSmaller ? 12 : 16 ) ;
	}
}

void CFontHelper::SetFontHeight( DWORD newHeight ) 
{
	if ( m_bUseTTF && m_bHaveTTF )
	{
		unsigned int h,d, ch ;
		unsigned int oldh, oldd ;
		unsigned int numiters  ;

		numiters = 0 ;

		m_pConsoleTTF->GetFontMetrics( &h, &d ) ;
		ch = m_pConsoleTTF->GetTextHeight() ;

		oldh = h ;
		oldd = d ;

		while ( h-d < newHeight )
		{
			m_pConsoleTTF->SetTextHeight( ch++ ) ;
			m_pConsoleTTF->GetFontMetrics( &h, &d ) ;

			if ( (numiters > 9 ) && ( oldh == h ) && ( oldd == d ) )
				break ;

			numiters++ ;
		}

		if ( ch == 1 )
			return ;

		oldh = h ;
		oldd = d ;
		numiters = 0 ;

		while ( h-d > newHeight )
		{
			m_pConsoleTTF->SetTextHeight( ch-- ) ;
			m_pConsoleTTF->GetFontMetrics( &h, &d ) ;
			if ( (numiters > 9 ) && ( oldh == h ) && ( oldd == d ) )
				break ;

			if ( ch == 1 )
				return ;

			numiters++ ;
		}
	}
	else
	{
		UseSmaller( newHeight < 16 ) ;
	}
}

void CFontHelper::DrawText( float x, float y, DWORD color, const WCHAR *msg  ) 
{
	if ( m_bUseTTF && m_bHaveTTF )
	{
		//int linenum = y/16 ;

		m_pConsoleTTF->SetTextColor( color ) ;
		m_pConsoleTTF->TextOut( m_primarySurface, msg, wcslen(msg), x, y ) ;
	}
	else
	{
		if ( m_bSmaller && m_bHaveSmall )
			m_FontSmall.DrawText( x, y, color, msg ) ;
		else
			if ( m_bHaveBig ) 
				m_Font.DrawText( x, y, color, msg ) ;

	}
}


//-----------------------------------------------------------------------------
// Name: Destroy()
// Desc: Destroys the help class' internal objects/
//-----------------------------------------------------------------------------
HRESULT CFontHelper::Destroy()
{
    return S_OK;
}




