
#include <iostream>
#include <string.h>
#include "BankSwitchedROM.h"

BankSwitchedROM::BankSwitchedROM()
    : image(NULL)
{}

BankSwitchedROM::BankSwitchedROM(UINT16 size, UINT16 page,
        UINT16 location)
    : image(NULL)
{
    init(size, page, location);
}

BankSwitchedROM::~BankSwitchedROM()
{
    if (image != NULL)
        delete[] image;
}

void BankSwitchedROM::init(UINT16 size, UINT16 page, UINT16 location)
{
    this->image = new UINT16[size];
    this->size = size;
    this->imagePage = page;
    this->location = location;
    this->currentPage = 0;
    this->pageChangeValue = (location & 0xF000) | 0x0A50;
}

void BankSwitchedROM::loadImage(UINT16* image)
{
    memcpy(this->image, image, size*sizeof(UINT16));
}

void BankSwitchedROM::reset()
{
    currentPage = 0;
}

UINT16 BankSwitchedROM::getSize()
{
    return size;
}

UINT16 BankSwitchedROM::getNumLocations()
{
    return 1;
}

UINT16 BankSwitchedROM::getLocation(UINT16 i)
{
    return location;
}

BOOL BankSwitchedROM::isLocationReadable(UINT16 i)
{
    return TRUE;
}

BOOL BankSwitchedROM::isLocationWriteable(UINT16 i)
{
    return TRUE;
}
void BankSwitchedROM::poke(UINT16 location, UINT16 value) {
    if (((location - this->location) == 0x0FFF) &&
            ((value & 0xFFF0) == pageChangeValue))
        currentPage = (value & 0x000F);
}

UINT16 BankSwitchedROM::peek(UINT16 location) {
    return (this->currentPage == this->imagePage
            ? this->image[location - this->location] : 0xFFFF );
}

/*
void BankSwitchedROM::save(SaveOutputStream sos) throws IOException {
    sos.writeInt(currentPage);
}

void BankSwitchedROM::load(LoadInputStream lis) throws IOException {
    currentPage = lis.readInt(0, 15);
}
*/

