
#ifndef MEMORY_H
#define MEMORY_H

#include "FileInputStream.h"
#include "FileOutputStream.h"
#include "osd/types.h"

template <typename A, typename W> class Memory
{

    public:
        virtual void reset() = 0;
        virtual A getSize() = 0;
        virtual A getNumLocations() = 0;
        virtual A getLocation(A i) = 0;
        virtual BOOL isLocationReadable(A i) = 0;
        virtual BOOL isLocationWriteable(A i) = 0;
        virtual W peek(A location) = 0;
        virtual void poke(A location, W value) = 0;

        //saving and loading support
        //virtual void save(FileOutputStream*) = 0;
        //virtual void load(FileInputStream*) = 0;

};

typedef Memory<UINT16, UINT16> Memory16Bit;

typedef Memory<UINT16, UINT8> Memory8Bit;

#endif
