
#ifndef AUDIOOUTPUTLINE_H
#define AUDIOOUTPUTLINE_H

#include "osd/types.h"

class AudioOutputLine
{

    friend class AudioMixer;

    public:
        void playSample(INT16 sample);
        void acquire();
        void release();

    private:
        AudioOutputLine(AudioMixer* mixer);
        AudioMixer* mixer;
        void reset();

        INT64            lastWriteClockMark;
        INT16             currentSample;
        INT64             sampleBuffer;

};

#endif


