
#ifndef GTIA_REGISTERS_H
#define GTIA_REGISTERS_H

#include "../core/Memory.h"

class GTIA_Registers : public Memory8Bit
{

    friend class GTIA;

    public:
        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        UINT8 peek(UINT16 addr);
        void poke(UINT16 addr, UINT8 value);

    private:
        GTIA_Registers();
        void init(GTIA* gtia);

        GTIA* gtia;

};

#endif

