
#include <iostream>
#include "IntellivisionCartridge.h"
#include "IntellivisionRecognitionDatabase.h"
#include "../../core/cartridge/CRC32.h"
#include "../../core/ROM.h"

#pragma warning(disable:4786) //Suppress STL debug info > 255 chars messages

using namespace std;

IntellivisionCartridge::IntellivisionCartridge(const CHAR* name,
        Memory16Bit** memories, INT32 memCount)
    : Cartridge(name, NULL, NULL)
{
    IntellivisionCartridge::IntellivisionCartridge(name, memories, memCount,
            FALSE, FALSE);
}

IntellivisionCartridge::IntellivisionCartridge(const CHAR* name,
        Memory16Bit** memories, INT32 memCount, BOOL requiresECS,
        BOOL usesIntellivoice)
    : Cartridge(name, NULL, NULL)
{
    this->memories = memories;
    this->memCount = memCount;
    this->ecs = requiresECS;
    this->ivoice = usesIntellivoice;
}

IntellivisionCartridge::~IntellivisionCartridge() {
    delete[] memories;
}

UINT16 IntellivisionCartridge::getMemoryCount() {
    return memCount;
}

Memory16Bit* IntellivisionCartridge::getMemory(UINT16 i) {
    return memories[i];
}

BOOL IntellivisionCartridge::requiresECS() {
    return ecs;
}

BOOL IntellivisionCartridge::usesIntellivoice() {
    return ivoice;
}

IntellivisionCartridge* IntellivisionCartridge::loadCartridge(const CHAR* filename) {
    UINT16* image = NULL;
    UINT16 size = 0;
    ROM16Bit::loadROMImage(&image, &size, filename, TRUE);

    UINT32 crc = CRC32::getCrc(filename);
    IntellivisionCartridgeConfiguration* type =
            (IntellivisionCartridgeConfiguration*)
            IntellivisionRecognitionDatabase::FACTORY.getConfiguration(crc);

    IntellivisionCartridge* cart;
    ROM16Bit* rom;
    if (type == NULL) {
        Memory16Bit** memories = new Memory16Bit*[1];
        rom = new ROM16Bit(size, 0x5000);
        rom->loadImage(image);
        delete[] image;
        memories[0] = rom;
        cart = new IntellivisionCartridge("Unknown", memories, 1);
    }
    else if (type->getMemoryCount() == 1) {
        Memory16Bit** memories = new Memory16Bit*[1];
        rom = new ROM16Bit(size, type->getMemoryLocation(0));
        rom->loadImage(image);
        delete[] image;
        memories[0] = rom;
        cart = new IntellivisionCartridge(type->getName(), memories, 1,
                type->requiresECS(), type->usesIntellivoice());
    }
    else {
        //split the image into multiple smaller memory images
        INT32 memoryCount = type->getMemoryCount();
        Memory16Bit** memories = new Memory16Bit*[memoryCount];
        UINT16* nextMemStart = image;
        for (INT32 i = 0; i < memoryCount; i++) {
            INT32 nextSize = type->getMemorySize(i);
            rom = new ROM16Bit(nextSize, type->getMemoryLocation(i));
            rom->loadImage(nextMemStart);
            memories[i] = rom;
            nextMemStart += nextSize;
        }
        delete[] image;
        cart = new IntellivisionCartridge(type->getName(), memories,
                memoryCount, type->requiresECS(), type->usesIntellivoice());
    }
    
    return cart;
}

