
#ifndef AY38914_REGISTERS_H
#define AY38914_REGISTERS_H

#include "../core/Memory.h"

class AY38914;

class AY38914_Registers : public Memory16Bit
{

    friend class AY38914;

    public:
        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        void poke(UINT16 location, UINT16 value);
        UINT16 peek(UINT16 location);

    private:
        AY38914_Registers();
        void init(AY38914* ay38914, UINT16 location);

        AY38914* ay38914;
        UINT16   location;
        UINT16   memory[0x0E];

};

#endif

