//-----------------------------------------------------------------------------
// File: WMVCutScene.cpp
//
// Desc: This sample demonstrates how to play back WMV cut scenes using the
//       Direct3D overlay surface
//
// Hist: 10.10.01 - New for Novermber XDK
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>
#include <vector>
#include "zlib.h"
#include "unzip.h"

#ifdef __cplusplus
extern "C" {
#endif

void SaveSRAM(char *fname);
void OpenROM(char *pROM) ;
void UpdateSoundRecording(int Data) ;

#include "shared.h"

char				*g_sramfile ;
char				*g_chtfile ;
extern short             pixel[];

char global_error_message[1024] ;


#ifdef __cplusplus
}
#endif

//WCHAR g_buf[1024];
// constants for controller dead zone / speed up banding etc.
const float GAMESEL_cfDeadZone = 0.3f;
const float GAMESEL_cfMaxThresh = 0.93f;
const float GAMESEL_cfMaxPossible = 1.0f;
const float GAMESEL_cfRectifyScale = GAMESEL_cfMaxPossible/(GAMESEL_cfMaxPossible-GAMESEL_cfDeadZone);
const float GAMESEL_cfSpeedBandFastest = 3.0f;	// seconds (don`t worry for PAL NTSC dif xbapp handles that)
const float GAMESEL_cfFastestScrollMult = 10.0f;
const float GAMESEL_cfSpeedBandMedium = 2.0f;	// if the pad is held at max for given seconds list will move faster
const float GAMESEL_cfMediumScrollMult = 5.0f;
const float GAMESEL_cfSpeedBandLowest = 1.0f;
const float GAMESEL_cfLowestScrollMult = 2.0f;


#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 25
#define MAX_RESIST 1000000.0


#define CONSOLE_MEMORY_SIZE 0x2000

typedef struct tagBITMAPINFOHEADER{
      DWORD  biSize;
      DWORD  biWidth;
      DWORD  biHeight;
      WORD   biPlanes;
      WORD   biBitCount ;
      DWORD  biCompression;
      DWORD  biSizeImage;
      DWORD  biXPelsPerMeter;
      DWORD  biYPelsPerMeter;
      DWORD  biClrUsed;
      DWORD  biClrImportant;

   } BITMAPINFOHEADER;

typedef struct tagRGBQUAD {
  BYTE    rgbBlue; 
  BYTE    rgbGreen; 
  BYTE    rgbRed; 
  BYTE    rgbReserved; 
} RGBQUAD; 

typedef struct BMP
{
	BITMAPINFOHEADER						BitmapInfoHeader;
	RGBQUAD									Palette[256];
} BMP;



//-----------------------------------------------------------------------------
// Callouts for labelling the gamepad on the help screen
//-----------------------------------------------------------------------------
XBHELP_CALLOUT g_HelpCallouts[] = 
{
    { XBHELP_BACK_BUTTON,  XBHELP_PLACEMENT_2, L"Display help" },
    { XBHELP_A_BUTTON,     XBHELP_PLACEMENT_1, L"Play video" },
    { XBHELP_B_BUTTON,     XBHELP_PLACEMENT_1, L"Stop playback" },
};

#define NUM_HELP_CALLOUTS ( sizeof( g_HelpCallouts ) / sizeof( g_HelpCallouts[0] ) )

SoundXBOX *g_sound ;
float     *g_apptime ;
UINT32    *g_numframes ;
DWORD     g_dwStartTime ;
DWORD     g_dwTimePaused ;

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx, int country) ;
	virtual void    cleanupConsole( ) ;
	virtual void    handleEvents() ;
	virtual int     init_texture() ;
	virtual int		init_white_texture();
	virtual int		render_to_texture() ;
	virtual void	FindAvailRoms() ;
	virtual void    doStartSearchMenu() ;
	virtual void    doCodeListMenu() ;
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCheatMenu() ;
	virtual void    updateCheats() ;
	virtual void    processEmu( BOOL render ) ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    deleteSaveFiles( int which ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip() ;
	virtual void	UpdatePalette(void);
	virtual void    QuickSort( int start, int end ) ;
	void			MenuBar( int xpos, int ypos, int xlen, int ylen ) ;
	

	float m_fGamma ;

	UINT32 m_numFrames ;
	int m_skipNext ;


	UINT32 topIdx  ;
	UINT32 curr  ;
	int		m_namesPerPage ;

    CXBFont     m_Font;             // Font object
    CXBFont     m_FontSmall;             // Font object

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	DWORD    m_dwStartPause ;
	BMP      Bmp ;

	LPDIRECT3DTEXTURE8	Texture;
	LPDIRECT3DTEXTURE8	WhiteTexture;
	LPD3DXSPRITE			Sprite;
	LPD3DXSPRITE			MenuSprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	int		m_nXOffset, m_nFontHeight ;
	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;
	int					m_smsFPS ;


	SoundXBOX			m_sound;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_stateFile[500] ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;

	typedef struct _cheat_code {
		char code[20] ;
		UINT32 adr ;
		UINT32 val ;
		byte   enabled ;
	} CHEAT_CODE;

	CHEAT_CODE *m_cheatCodes;

	UINT32 m_numCheats ;


};

int CXBoxSample::init_white_texture()
{
	// Release any previous texture
	if (WhiteTexture) 
	{ 
		WhiteTexture->Release();
		WhiteTexture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, 16, 16, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &WhiteTexture);
	
	D3DSURFACE_DESC desc;
    WhiteTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 15;
	rectSource.right  = 15 ;

	D3DLOCKED_RECT d3dlr;
	WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memset( d3dlr.pBits, 0xFF, desc.Size ) ;

	// Unlock our texture
	WhiteTexture->UnlockRect(0);

	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	return 0;
}



//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBoxSample xbApp;


	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
		{
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
			xbApp.m_smsFPS = 60 ;
		}
		else
		{
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
			xbApp.m_smsFPS = 50 ;
		}
	}
	else
		xbApp.m_smsFPS = 60 ;

    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}



//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
	g_sound = &m_sound ;
	g_apptime = &m_fAppTime ;
	g_numframes = &m_numFrames ;
	m_sound.m_ptrapp = this ;
	g_sramfile = (char*)malloc(500) ;
	g_chtfile = (char*)malloc(500) ;
}



int CXBoxSample::init_texture()
{
    memset(&bitmap, 0, sizeof(t_bitmap));
    bitmap.width  = 256;
    bitmap.height = 192;
    bitmap.depth  = 8;

	theWidth = bitmap.width ;
	theHeight = bitmap.height ;


/*
	if (UseSmoothing)
	{
		IDirect3DDevice7_SetTextureStageState(p3DDevice, 0, D3DTSS_MINFILTER, D3DTFN_LINEAR);
		IDirect3DDevice7_SetTextureStageState(p3DDevice, 0, D3DTSS_MAGFILTER, D3DTFN_LINEAR);
	}
	else
	{
		IDirect3DDevice7_SetTextureStageState(p3DDevice, 0, D3DTSS_MINFILTER, D3DTFN_POINT);
		IDirect3DDevice7_SetTextureStageState(p3DDevice, 0, D3DTSS_MAGFILTER, D3DTFN_POINT);
	}
*/

	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];

    bitmap.data   = (unsigned char *)g_pBlitBuff ;

	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];

	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

    bitmap.pitch  = theWidth ;

	// Unlock our texture
	Texture->UnlockRect(0);


	return 0;
}


//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create a font
    if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font12.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", L"SMSSAV", OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
        return E_FAIL;

	m_sound.dsound_init() ;


	m_sound.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;

	m_state = INIT_SYSTEM ;

	return S_OK ;
}

HRESULT CXBoxSample::InitializeWithScreen()
{

	FILE *inifile ;
	int numread ;
	char initext[200] ;
	char *fpos, *epos ;

	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						 0x00000000, 1.0f, 0L );
	RenderGradientBackground( 0xFF000000, 0xFF000000 );
	m_Font.Begin();
	m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Reading smsroms directory...please wait." ) ;
	m_Font.End();
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


	
	m_nXOffset = 0 ;
	m_nFontHeight = 12 ;

	inifile = fopen( "D:\\smsplus.ini", "r" ) ;

	if ( inifile != NULL )
	{
		numread = fread( initext, sizeof(char), 100, inifile ) ;
		fclose( inifile ) ;

		if ( ( numread > 0 ) && ( numread < 100 ) )
			initext[numread] = 0 ;

		fpos = strchr( initext, ' ' ) ;

		if ( fpos != NULL )
		{
			*fpos = 0 ;
			fpos++ ;

			m_nXOffset = atoi( initext ) ;

			epos = strchr( fpos, '\r' ) ;

			if ( epos == NULL )
			{
				epos = strchr( fpos, '\n' ) ;
			}

			if ( epos != NULL )
				*epos = 0 ;

			m_nFontHeight = atoi( fpos ) ;

		}


	}

	if ( m_nFontHeight < 1 )
		m_nFontHeight = 12 ;


	m_namesPerPage =  (25*14 ) / ( m_nFontHeight+2) ;

	
	
	m_fGamma = 1.0f ;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pAlignBuff = NULL ;

	
	WhiteTexture = NULL ;
	Texture = NULL ;
	Sprite = NULL ;
	MenuSprite = NULL ;
	m_cheatCodes = NULL ;
	m_numCheats = 0 ;

	init_white_texture();
	
	
	g_saveprefix[0] = 0 ;

	FindAvailRoms() ;

	cart.rom = NULL ;

	m_memBuf1 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memBuf2 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memMatches = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_consoleMemory = sms.ram ;


//BEGIN ONE TIME


//END ONE TIME	
	
	
	m_state = MAIN_MENU ;

    return S_OK;
}




void CXBoxSample::doStartSearchMenu()
{

	memcpy( m_memBuf1, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"The search has begun.  " );
		m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
	}
}

void CXBoxSample::doEditCode( int which )
{
	CHEAT_CODE code ;
	int curr_pos ;
	int val1, val2 ;

	if ( which < 0 )
	{
		strcpy( code.code, "010000C0" ) ;
		code.enabled = 1 ;
		code.adr = 0xC000 ;
		code.val = 0 ;
	}
	else
	{
		memcpy( &code, &(m_cheatCodes[which]), sizeof(CHEAT_CODE) ) ;
	}


	curr_pos = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();

		if ( which < 0 )
			m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Add New Cheat Code" );
		else
			m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Edit Cheat Code" );

		m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to cancel." );
		m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, L"Press A to save." );
		m_Font.DrawText(m_nXOffset+  32, 16*6, 0xffffffff, L"Use DPAD to select/change values." );

		WCHAR str[200];

		for ( int i = 0 ; i < 8 ; i++ )
		{
			swprintf( str, L"%c", (code.code)[i] ) ;
			if ( i == curr_pos+2 )
				m_Font.DrawText(m_nXOffset+  50 + ( i * 16 ), 16*9, 0xff00FF00, str ) ;
			else
				m_Font.DrawText(m_nXOffset+  50 + ( i * 16 ), 16*9, 0xffffffff, str ) ;
		}

		swprintf( str, L"Address : %04.4X", code.adr ) ;
		m_Font.DrawText(m_nXOffset+  50 , 16*11, 0xffffffff, str ) ;
		swprintf( str, L"Value : %u", code.val ) ;
		m_Font.DrawText(m_nXOffset+  50 , 16*12, 0xffffffff, str ) ;
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		{
			if ( code.adr > 0x1FFF ) 
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );

					m_Font.Begin();
					m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"The Address must be between less than 0x1FFF" );
					m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to try again." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
			else
			{
				if ( which < 0 )
				{
					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;
					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
				}
				else
				{
					memcpy( &(m_cheatCodes[which]), &code, sizeof(CHEAT_CODE) ) ;
				}
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0 )
						code.val = 0xF0 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val - 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x00 )
						code.val = 0x0F + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val - 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0 )
						code.adr = 0xF0 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr - 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0 )
						code.adr = 0x0F + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr - 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0 )
						code.adr = 0xF000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr - 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0 )
						code.adr = 0x0F00 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr - 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val + 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val + 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr + 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr + 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr + 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr + 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( curr_pos == 0 )
				curr_pos = 5 ;
			else
				curr_pos-- ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( curr_pos == 5 )
				curr_pos = 0 ;
			else
				curr_pos++ ;
		}
	}


}

void CXBoxSample::doCodeListMenu()
{

	int selected  ;
	int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;

	selected = cheatTopIdx = 0 ;

	if ( m_numCheats == 0 )
	{
		while ( 1 )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );
	
			m_Font.Begin();
			m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
			m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
			m_Font.DrawText(m_nXOffset+  32, 16*6, 0xffffffff, L"There are no cheat codes in the list." ) ;

			m_Font.End();

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return ;
			}
		}
	}
	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
		m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, L"Press A to add a new code." );
		m_Font.DrawText(m_nXOffset+  32, 16*6, 0xffffffff, L"Press X to edit the selected code." );
		m_Font.DrawText(m_nXOffset+  32, 16*7, 0xffffffff, L"Press Y to enable/disable the selected code." );
		m_Font.DrawText(m_nXOffset+  32, 16*8, 0xffffffff, L"Press BLACK to delete the selected code." );
		m_Font.DrawText(m_nXOffset+  32, 16*9, 0xffffffff, L"Press UP/DOWN/LS/RS to select code." );

		MenuBar( m_nXOffset+32, 16*(11+selected) + 3, 600, 19 ) ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+10) ; idx++ )
		{
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( str, L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			if ( selected == idx )
				m_Font.DrawText(m_nXOffset+32, 16*(11+idx), 0xff000000, str );
			else
				m_Font.DrawText(m_nXOffset+32, 16*(11+idx), 0xffffffff, str );
		}
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doEditCode( -1 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			doEditCode( selected ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			if ( m_cheatCodes[selected].enabled )
				m_cheatCodes[selected].enabled = 0 ;
			else
				m_cheatCodes[selected].enabled = 1 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

			memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

			if ( selected < m_numCheats-1 )
			{
				memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
			}

			free( m_cheatCodes ) ;

			m_cheatCodes = tempbuf ;
			m_numCheats-- ;
			if ( m_numCheats == 0 )
				break ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( cheatTopIdx + 10 < m_numCheats )
			{
				cheatTopIdx += 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( cheatTopIdx >= 10 )
			{
				cheatTopIdx -= 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (10-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
					selected++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
					selected-- ;
			}
		}

		
		
		
		
	}
}

void CXBoxSample::doAddFoundCodes()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			code.adr = i ;
			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"The search found 1 to 4 possible matches for your search." );
		m_Font.DrawText(m_nXOffset+  32, 16*3, 0xffffffff, L"They have been added to your list." );
		m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu()
{

	WCHAR str[200];
	int value ;

	memcpy( m_memBuf2, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	value = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Search Options" );
		m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );

		swprintf( str, L"Press X to search for this value : %u", value );
		m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, str );

		m_Font.DrawText(m_nXOffset+  32, 16*6, 0xffffffff, L"Press Y to search for values less than before." );
		m_Font.DrawText(m_nXOffset+  32, 16*7, 0xffffffff, L"Press A to search for values greater than before." );
		m_Font.DrawText(m_nXOffset+  32, 16*8, 0xffffffff, L"Press BLACK to search for values equal to before." );
		m_Font.DrawText(m_nXOffset+  32, 16*9, 0xffffffff, L"Press WHITE to search for values not equal to before." );
		m_Font.DrawText(m_nXOffset+  32, 16*10, 0xffffffff, L"Press DPAD-UP to add 1 to the value" ) ;
		m_Font.DrawText(m_nXOffset+  32, 16*11, 0xffffffff, L"Press DPAD-DOWN to subtract 1 from the value" ) ;
		m_Font.DrawText(m_nXOffset+  32, 16*12, 0xffffffff, L"Press DPAD-RIGHT to add 10 to the value" ) ;
		m_Font.DrawText(m_nXOffset+  32, 16*13, 0xffffffff, L"Press DPAD-LEFT to subtract 10 from the value" ) ;
		m_Font.DrawText(m_nXOffset+  32, 16*14, 0xffffffff, L"Press LS+RS to add the found codes to your list" ) ;

		swprintf( str, L"Number of hits from last search : %u", m_currentMemMatches );
		m_Font.DrawText(m_nXOffset+  32, 16*16, 0xffffffff, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] < m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}

			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf2[i] == value )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] > m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] == m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] != m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 5 ) )
			{
				doAddFoundCodes() ;
				break ;
			}
			else
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );

					m_Font.Begin();
					m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"You can only add when you have narrowed " ) ;
					m_Font.DrawText(m_nXOffset+  32, 16*3, 0xffffffff, L"it down to less than 5 matches." );
					m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, L"Press B to go back." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}

void CXBoxSample::doCheatMenu()
{

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"OPTIONS MENU" );
		m_Font.DrawText(m_nXOffset+  32, 16*4, 0xffffffff, L"B - Return to Game" );
		m_Font.DrawText(m_nXOffset+  32, 16*5, 0xffffffff, L"START+BACK - Quit Game" );
		m_Font.DrawText(m_nXOffset+  32, 16*6, 0xffffffff, L"BLACK - Start Search for Cheat Code" );
		m_Font.DrawText(m_nXOffset+  32, 16*7, 0xffffffff, L"A - Continue Cheat Search" );
		m_Font.DrawText(m_nXOffset+  32, 16*8, 0xffffffff, L"RS+LS - Cheat Code List" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sound.pause( FALSE ) ;
			m_state = IN_GAME ;
			break ;
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			cleanupConsole() ;
			m_state = MAIN_MENU ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doContinueSearchMenu() ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			doStartSearchMenu() ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			doCodeListMenu() ;
		}


	}

}


//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	m_bPaused =  ( m_state != IN_GAME ) ;

	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sound.pause( TRUE ) ;
			m_state = IN_GAME_PAUSED ;
			m_dwStartPause = GetTickCount();
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) )
		{
			LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
			XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
		}
		else if ( (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_X]) && (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_B]) )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );
			m_Font.Begin();
			m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Reloading game list..." ) ;
			m_Font.End();
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			if ( numfiles > 0 )
			{
				delete [] files;
				files = NULL;
			}

			numfiles = 0 ;
			FindAvailRoms() ;
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				initConsole(curr, TYPE_DOMESTIC) ;
				m_state = IN_GAME ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_X])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				initConsole(curr, TYPE_OVERSEAS) ;
				m_state = IN_GAME ;
				return S_OK ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		m_sound.pause( TRUE ) ;
		m_bPaused =  TRUE ;
		doCheatMenu() ;

		return S_OK ;
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture()
{
    int vp_vstart ;
    int vp_vend   ;
    int vp_hstart ;
    int vp_hend   ;

	RECT src, dst;
	byte *curr1, *curr2 ;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	
	curr1 = g_pAlignBuff ;
	curr2 = g_pBlitBuff ;
	byte *bitptr ;
	unsigned char pixel[4] ;
	UINT32 red, green, blue, yellow, uChrom, vChrom ;

	bitptr = g_pAlignBuff ;
	//bitptr = (byte*)d3dlr.pBits ;
	/*
	256x192
640x480 =   64, 48
  gg = 160x144
  sms = 256x192 (240 x 226) 
*/

    if(cart.type == TYPE_GG)
    {
        vp_vstart = 24;  //48
        vp_vend   = 168; //336
        vp_hstart = 6 *8;  //was 6
        vp_hend   = 26 *8 ;  //was 26
    }
    else
    {
        vp_vstart = 0;
        vp_vend   = 192;
        vp_hstart = 0 *8 ;
        vp_hend   = 32 *8 ;
    }

	for( UINT32 y = theHeight ; y > 0 ; y-- )
	{
		//bitptr = ((byte*)d3dlr.pBits) + ( y*d3dlr.Pitch ) ;
		bitptr = ((byte*)g_pAlignBuff) + ( (y-1)*d3dlr.Pitch ) ;

		if ( ( (y-1) < vp_vstart ) || ( (y-1) >= vp_vend ) )
		{
			memset( bitptr, 0, theWidth*4 ) ;
			curr2 += theWidth ;
		}
		else
		{
			for( UINT32 x = 0 ; x < theWidth ; x++ )
			{

				if ( ( x < (vp_hstart) ) || ( x >= (vp_hend) ) )
				{
					memset( bitptr, 0, 4 ) ;
					curr2++ ;
				}
				else
				{

					red = Bmp.Palette[ *curr2 ].rgbRed ;
					green = Bmp.Palette[ *curr2 ].rgbGreen ;
					blue = Bmp.Palette[ *curr2++ ].rgbBlue ;

					pixel[3] = 0 ;
					pixel[2] = ( red & 0xFF ) ;
					pixel[1] = ( green & 0xFF ) ;
					pixel[0] = ( blue & 0xFF ) ;
					//pixel[1] = 255 ;
					//pixel[2] = 0 ;
					//pixel[3] = 0 ;

					//memcpy( bitptr, (const void*)(&palette[*current++]), 4 ) ;
					memcpy( bitptr, pixel, 4 ) ;
				}

				bitptr += 4 ;


			}
		}
	}


	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pAlignBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 4);

	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;


	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 0;
	src.bottom = theHeight + 1;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(2, 2);
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	D3DXVECTOR2 vecTranslate( (( 640 - ( 2* ( vp_hend-vp_hstart ) ) ) / 2)-(vp_hstart*2), (( 480 - ( 2* ( vp_vend-vp_vstart ) ) ) / 2) - (vp_vstart*2)) ;
	
//-56 more
	
	Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		//g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		if ( global_error_message[0] != 0 )
		{
			WCHAR str[5000];

			m_Font.Begin();
			//swprintf( str, L"%S", global_error_message );
			//m_Font.DrawText( 32, 48, 0xffffffff, str );
			m_Font.DrawText(m_nXOffset+ 32, 48, 0xffffffff, L"ERROR" );
			m_Font.End();
		}
		else
		{

			processEmu( TRUE ) ;

			if ( m_msgDelay > 0 )
			{
				m_msgDelay-- ;
				m_Font.Begin();
				m_Font.DrawText(m_nXOffset+  32, 32, 0xffffff00, m_strMessage );
				m_Font.End();
			}
			else
			{
				float elapsedTime ;
				m_Font.Begin();
				WCHAR str[2000];
				//elapsedTime = ( (float)GetTickCount() - (float)g_dwStartTime - (float)g_dwTimePaused ) / 1000.0f ;
				//swprintf( str, L"apptime %5.5f, sndbytes %u, avg %6.5f, fps %5.5f cfps %5.5f", elapsedTime, m_sound.m_totalBytesWritten, 
					//((float)m_sound.m_totalBytesWritten) / elapsedTime, m_fFPS, ((float)m_numFrames) / m_fAppTime );
				//swprintf( str, L"apptime %5.5f, sndbytes %u, avg %6.5f, fps %5.5f cfps %5.5f", elapsedTime, m_sound.m_totalBytesWritten, 
					//((float)m_sound.m_totalBytesWritten) / elapsedTime, m_fFPS, ((float)m_numFrames) / m_fAppTime );
				//m_Font.DrawText( 20, 32, 0xffffffff, m_strFrameRate );
				m_Font.End();
			}
		}
		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText(m_nXOffset+32, 16*3,  0xffffffff, L"SMSPlus for XBOX");
			m_Font.DrawText(m_nXOffset+32, 16*5,  0xffffffff, L"Main Menu Controls");
			m_Font.DrawText(m_nXOffset+32, 16*6,  0xffffffff, L"A - Play Selected Game as US system");
			m_Font.DrawText(m_nXOffset+32, 16*7,  0xffffffff, L"X - Play Selected Game as JPN system");
			m_Font.DrawText(m_nXOffset+32, 16*8,  0xffffffff, L"Y - Show This Help Screen");
			m_Font.DrawText(m_nXOffset+32, 16*9,  0xffffffff, L"UP/DOWN - Select Game");
			m_Font.DrawText(m_nXOffset+32, 16*10,  0xffffffff, L"RIGHT/LEFT - Next/Prev Page");
			m_Font.DrawText(m_nXOffset+32, 16*11,  0xffffffff, L"LS/RS - Next/Prev Letter");
			m_Font.DrawText(m_nXOffset+32, 16*12,  0xffffffff, L"START+BACK+LS+RS - Exit to dashboard");
			m_Font.DrawText(m_nXOffset+32, 16*13,  0xffffffff, L"X+B - Reload list");
			m_Font.DrawText(m_nXOffset+32, 16*14,  0xffffffff, L"BLACK+WHITE - Delete save files");
			m_Font.DrawText(m_nXOffset+32, 16*15,  0xff00ff00, L"Lines colored like this have save files on the HD.");

			m_Font.DrawText(m_nXOffset+32, 16*17, 0xffffffff, L"In-Game Controls");
			m_Font.DrawText(m_nXOffset+32, 16*18, 0xffffffff, L"A - A Button");
			m_Font.DrawText(m_nXOffset+32, 16*19, 0xffffffff, L"X - B Button");
			m_Font.DrawText(m_nXOffset+32, 16*20, 0xffffffff, L"DPAD - Joystick Movement");
			m_Font.DrawText(m_nXOffset+32, 16*21, 0xffffffff, L"START - Start");
			m_Font.DrawText(m_nXOffset+32, 16*22, 0xffffffff, L"Y - Options Menu");
			m_Font.DrawText( m_nXOffset+32, 16*23, 0xffffffff, L"LS+BLACK - Save state");
			m_Font.DrawText( m_nXOffset+32, 16*24, 0xffffffff, L"LS+WHITE - Load state");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText(m_nXOffset+48, 32, 0xffffffff, L"SMSPlus for XBOX - made by me");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) )
		{
			deleteSaveFiles( curr ) ;
		}
		else
		{
			WCHAR str[2000];
			swprintf( str, L"SMSPlus for XBOX  Y-Help Screen  Found %u games", numfiles);

			m_Font.Begin(); 
			m_FontSmall.Begin(); 
			m_Font.DrawText(m_nXOffset+ 48, 32, 0xffffffff, str );
			//m_Font.DrawText(48, 32, 0x40ffffff, L"SMSPlus for XBOX  Y-Help Screen");


			
			
			float fWinX = 32, fWinY = 64;

			MenuBar( m_nXOffset+fWinX, fWinY+ (( m_nFontHeight+2)*(curr-topIdx)) + 3, 600, m_nFontHeight+3 ) ;

			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+m_namesPerPage) ; idx++ )
			{
				if ( curr == idx )
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText(m_nXOffset+fWinX  , fWinY, 0xffff00ff, files[idx].name );
					else
						m_FontSmall.DrawText(m_nXOffset+fWinX , fWinY, 0xff000000, files[idx].name );
				}
				else
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText(m_nXOffset+fWinX, fWinY, 0xff00ff00, files[idx].name );
					else
						m_FontSmall.DrawText(m_nXOffset+fWinX, fWinY, 0xffffffff, files[idx].name );
				}
				fWinY += (m_nFontHeight + 2);
			}
			

			// end font drawing
			m_Font.End();
			m_FontSmall.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
		InitializeWithScreen() ;
	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

void CXBoxSample::handleEvents()
{

    memset(&input, 0, sizeof(t_input));

	for ( int i = 0 ; i < 2 ; i++ )
	{
	
		if ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			input.pad[i] |= INPUT_BUTTON1 ;

		if ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			input.pad[i] |= INPUT_BUTTON2 ;

		if ( g_Gamepads[i].hDevice && g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			input.pad[i] |= INPUT_LEFT ;

		if ( g_Gamepads[i].hDevice && g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			input.pad[i] |= INPUT_RIGHT ;

		if ( g_Gamepads[i].hDevice && g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			input.pad[i] |= INPUT_UP ;
		
		if ( g_Gamepads[i].hDevice && g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			input.pad[i] |= INPUT_DOWN ;
		
		if ( g_Gamepads[i].hDevice && g_Gamepads[i].wButtons & XINPUT_GAMEPAD_START )  
			input.system |= (cart.type)? INPUT_START : INPUT_PAUSE;

		if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			load_state( g_stateFile ) ;
		}
		else if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			save_state( g_stateFile ) ;
		}
	}

}


void CXBoxSample::FindAvailRoms()
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( "D:\\smsroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	files = new FILENAME[numfiles];

	numfiles = 0 ;

	hFind = FindFirstFile( "D:\\smsroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		// Mame's games are in 8-bit ansi convert them to unicode for display
		//WCHAR wcName[200];
		//mbsrtowcs(wcName, &pName, 200, NULL);

		files[numfiles].name[0] = 0 ;
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
		strlwr( (char*)( files[numfiles].filename )) ;
        swprintf( files[numfiles].name, L"%S", files[numfiles].filename );
//		mbsrtowcs(files[numfiles].name, (const char**)( &(oFindData.cFileName) ), 30, NULL);
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	QuickSort( 0, numfiles-1 ) ;
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{
	char c ;
	int  lcv ;

		if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv < numfiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
				lcv++ ;

			if ( lcv < numfiles )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
				lcv-- ;

			if ( lcv >= 0 )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( topIdx >= m_namesPerPage )
			{
				topIdx -= m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( topIdx + m_namesPerPage < numfiles )
			{
				topIdx += m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (m_namesPerPage-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

}



void CXBoxSample::initConsole( UINT32 idx, int country )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;

	global_error_message[0] = 0 ;

	m_numFrames = 0 ;
	m_skipNext = 0 ;

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;

	strcpy((char*)filename, "D:\\smsroms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;

	m_sound.init() ;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	strcpy(g_stateFile, g_saveprefix);
	strcat(g_stateFile, ".sta");

	// Create our texture
	init_texture();


	//region
	//smoothing
    //sms.use_fm   = RegistryInfo.EnableFMSound;

	//audio_init(Frequency, RegistryInfo.UpdateFrequency);

	OpenROM( filename ) ;


	if ( m_smsFPS == 60 )
		system_init(44100, 60 ) ;
	else if ( m_smsFPS == 50 )
		system_init(44100, 50 ) ;
	else
	{
		strcpy( global_error_message, "*nono") ;
		return ;
	}


	system_reset();

	
    sms.country  = country ;
    sms.use_fm   = 1;
	snd.callback = UpdateSoundRecording;

	
	
	
	
	
	m_consoleMemory = sms.ram ;


	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	


	//BEGIN EACH TIME


	cht_load();

	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;


	//put 3 frames of data in the audio buffer
	processEmu(FALSE) ;
	processEmu(FALSE) ;
	processEmu(FALSE) ;


	//Then start it up
	m_sound.pause( FALSE ) ;

}

void CXBoxSample::cleanupConsole( )
{
	cht_save() ;

	system_shutdown() ;
	SaveSRAM( g_sramfile ) ;
	free(cart.rom) ;
	cart.rom = NULL ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
}

void CXBoxSample::cht_load()
{
	FILE *f;
	CHEAT_CODE code ;
	int fsize ;
	int numread ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	

	f = fopen(g_chtfile, "rb");
	if (!f) return ;

	fseek( f, 0, SEEK_END ) ;
	fsize = ftell( f ) ;
	fseek( f, 0, SEEK_SET ) ;

	m_numCheats = fsize / sizeof(CHEAT_CODE) ;

	m_cheatCodes = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) *  m_numCheats );


	numread = 0 ;
	fread(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
}

void CXBoxSample::cht_save()
{
	FILE *f;
	CHEAT_CODE code ;

	if ( m_numCheats == 0 )
	{
		DeleteFile( g_chtfile ) ;
		return ;
	}

	f = fopen(g_chtfile, "wb");
	if (!f) return ;

	fwrite(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
	
}

BOOL CXBoxSample::hasFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");
	
	strcpy(g_stateFile, g_saveprefix);
	strcat(g_stateFile, ".sta");
	
	infile = fopen( g_sramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_chtfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_stateFile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	return FALSE ;

}
void CXBoxSample::updateCheats( )
{
	for ( int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( m_cheatCodes[i].enabled )
			m_consoleMemory[ m_cheatCodes[i].adr] = ( m_cheatCodes[i].val & 0xFF ) ;
	}
}

void CXBoxSample::deleteSaveFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;

	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	strcpy(g_stateFile, g_saveprefix);
	strcat(g_stateFile, ".sta");

	DeleteFile( g_sramfile ) ;
	DeleteFile( g_chtfile ) ;
	DeleteFile( g_stateFile ) ;

}

#ifdef __cplusplus
extern "C" {
#endif

void audio_callback()
{
//	g_sound->process( *g_apptime, *g_numframes ) ;

}

#ifdef __cplusplus
}
#endif

void CXBoxSample::processEmu( BOOL render )
{
			
			updateCheats() ;

		    sms_frame( m_skipNext );

			if ( render && !m_skipNext)
			{
				render_to_texture();
				m_numFrames++ ;
			}

			while ( m_sound.process( (char*)snd.buffer, snd.bufsize ) )
			{
			    sms_frame( 1 );
				UpdatePalette() ;
				handleEvents();
			}

			UpdatePalette() ;

			handleEvents();
			


}


int CXBoxSample::rom_load_zip()
{
	byte c, *data, *header;
	int len = 0, rlen;

//    unzFile file = unzOpen(romfile);
/*
    if(file == NULL)
		die("cannot open rom file: %s\n", romfile);


    char filename[132];
    int filesize = 0;
    int port = unzGoToFirstFile(file);
    unz_file_info info;

    while(port == UNZ_OK)
    {
		char name[132];
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ((int) info.uncompressed_size > filesize)
		{
			strcpy(filename,name);
			filesize = info.uncompressed_size;
		}
		port = unzGoToNextFile(file);
    }

    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || filesize == 0)
    {
		unzClose(file) ;
		die("cannot open rom file: %s\n", romfile);
    }

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		die("cannot open rom file: %s\n", romfile);
    }

	data = (byte*)malloc( info.uncompressed_size ) ;

	int l = unzReadCurrentFile(file,data,info.uncompressed_size);
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(data) ;
	    unzClose(file);
		die("cannot open rom file: %s\n", romfile);
	}

    unzClose(file);

	len = info.uncompressed_size ;

	header = data ;
	

*/
	return 0;
}

void CXBoxSample::UpdatePalette(void)
{
    unsigned char	r, g, b;
    int				index;

    if (bitmap.pal.update == 0) return;

    for (index = 0; index < 32; index++)
    {
        if(bitmap.pal.color[index])
        {
			
			//if (UseDirectDraw && RegistryInfo.EnableDirectDraw)
			//{
	            r = bitmap.pal.color[index][0];
				g = bitmap.pal.color[index][1];
				b = bitmap.pal.color[index][2];
			//}
			//else
			//{
	            //r = bitmap.pal.color[index][0];
				//g = bitmap.pal.color[index][1];
				//b = bitmap.pal.color[index][2];
			//}

			r = (unsigned char)(255.0f * pow((float)r / 255.0f, 1.0f / m_fGamma) + 0.5f);
			g = (unsigned char)(255.0f * pow((float)g / 255.0f, 1.0f / m_fGamma) + 0.5f);
			b = (unsigned char)(255.0f * pow((float)b / 255.0f, 1.0f / m_fGamma) + 0.5f);

			pixel[index] = MAKE_PIXEL(b, g, r);

			Bmp.Palette[0x00 | index].rgbRed	  = r;
			Bmp.Palette[0x00 | index].rgbGreen	  = g;
			Bmp.Palette[0x00 | index].rgbBlue	  = b;
			Bmp.Palette[0x20 | index].rgbRed	  = r;
			Bmp.Palette[0x20 | index].rgbGreen	  = g;
			Bmp.Palette[0x20 | index].rgbBlue	  = b;
			Bmp.Palette[0x40 | index].rgbRed	  = r;
			Bmp.Palette[0x40 | index].rgbGreen	  = g;
			Bmp.Palette[0x40 | index].rgbBlue	  = b;
        }
    }

    bitmap.pal.update = 0;
    memset(bitmap.pal.dirty, 0, 32);
}

void CXBoxSample::QuickSort( int lo, int hi )
{
	int i = lo;
	int j = hi;
	char partitionStr[200];
	FILENAME tmpf;

	strcpy( partitionStr, (const char*)files[(i+j)/2].filename ) ;
	do
	{
		while ( strcmp( (const char*)files[i].filename, partitionStr ) < 0 ) i++ ;
		while ( strcmp( partitionStr, (const char*)files[j].filename ) < 0 ) j-- ;

		if (i <= j)
		{
			memcpy( &tmpf, &(files[i]), sizeof(tmpf) ) ;
			memcpy( &(files[i]), &(files[j]), sizeof(tmpf) ) ;
			memcpy( &(files[j]), &tmpf, sizeof(tmpf) ) ;
			i++;
			j--;
		}
	} while (i <= j);

	if (lo < j) QuickSort(lo, j);
	if (i < hi) QuickSort(i, hi);

	
}

void CXBoxSample::MenuBar( int xpos, int ypos, int xlen, int ylen )
{
	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( xpos, ypos ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	RECT rectSource;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = ylen - 1 ;
	rectSource.right  = xlen - 1;
	
	MenuSprite->Draw(WhiteTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
}
