#include <windows.h>
#include "shared.h"
#include "dinput.h"
#include "main.h"
#include "input.h"
#include "registry.h"
#include "screenshot.h"

void Screenshot(void)
{
	int				i;
	int				AppendPos;
	char			Filename[MAX_PATH];
	HANDLE			FileHandle;

	// Add the game name (as used for SRAM save), and add it to the screenshots path
	wsprintf(Filename, "%s%s", RegistryInfo.ScreenshotPath, GetGameName());

	// Calculate the position where we can trim off the old .sav extension
	AppendPos = strlen(Filename);

	for (i = 0 ; i < 9999 ; i++)
	{
		// Add a numbered index and the extension .bmp
		wsprintf(&Filename[AppendPos], "(%04d).bmp", i);

		// Attempt to create a new file
	    FileHandle = CreateFile(Filename, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

		// If we're successful, stop looking for a new name
		if (FileHandle != INVALID_HANDLE_VALUE) break;
	}

	// Should never be the case, unless you get 10000 pics from the same game!
	if (FileHandle != INVALID_HANDLE_VALUE)
	{
		unsigned int		BytesWritten;
		BITMAPFILEHEADER	*pBMP;
		unsigned int		HeaderSize;
		unsigned int		FileSize;	
		int					BitDepth  = ((BITMAPINFOHEADER *)GetBitmapInfoHeader())->biBitCount;
		int					ByteDepth = BitDepth >> 3; 

		if (BitDepth == 8)
		{
			HeaderSize = sizeof(BITMAPFILEHEADER) + sizeof(BMP);
			FileSize   = HeaderSize + (256 * 192);
		}
		else
		{
			HeaderSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
			FileSize   = HeaderSize + (256 * 192 * 2);
		}

		pBMP = (BITMAPFILEHEADER *)malloc(FileSize);

		if (pBMP)
		{
			BOOL		Success;

			// Setup the bitmap file header
			pBMP->bfType	  = 'MB';
			pBMP->bfOffBits	  = HeaderSize;
			pBMP->bfSize	  = FileSize;
			pBMP->bfReserved1 = 0;
			pBMP->bfReserved2 = 0;

			// Copy over the bitmap info header
			memcpy((char *)((int)pBMP + sizeof(BITMAPFILEHEADER)), GetBitmapInfoHeader(), HeaderSize - sizeof(BITMAPFILEHEADER));

			if (DirectDrawAvailable() && RegistryInfo.EnableDirectDraw)
			{
				RGBQUAD			*pPalette = (RGBQUAD *)((int)pBMP + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));
				char			Temp;

				for (i = 0 ; i < 256 ; i++)
				{
					Temp			    = pPalette[i].rgbBlue;
					pPalette[i].rgbBlue = pPalette[i].rgbRed;
					pPalette[i].rgbRed  = Temp;
				}
			}

			if (cart.type == TYPE_GG)
			{
				BITMAPINFOHEADER *pBMPInfo = (BITMAPINFOHEADER *)((int)pBMP + sizeof(BITMAPFILEHEADER));
				char			 *pSource  = GetBitmapData() + (24 * 256 * ByteDepth) + (48 * ByteDepth);
				char			 *pDest	   = (char *)((int)pBMP + HeaderSize);
				int				 i;

				// Screen size is smaller for gamegear
				pBMPInfo->biWidth  = 160;
				pBMPInfo->biHeight = 144;

				// Re-build smaller bitmap
				for (i = 0 ; i < 144 ; i++)
				{
					memcpy(pDest, pSource, 160 * ByteDepth);
					pSource += 256 * ByteDepth;
					pDest	+= 160 * ByteDepth;
				}

				// Adjust file size
				FileSize -= (48 * 256 * ByteDepth) + (144 * 96 * ByteDepth);

				pBMP->bfSize = FileSize;
			}
			else
			{
				// Copy over the image data
				memcpy((char *)((int)pBMP + HeaderSize), GetBitmapData(), 256 * 192 * ByteDepth);
			}

			// Write out the .bmp
		    Success = WriteFile(FileHandle, pBMP, FileSize, &BytesWritten, NULL);

			// Check the file was written out properly
			if (!Success || (BytesWritten != FileSize))
			{
				char		Message[MAX_PATH];

				// Print up an error message
				wsprintf(Message, "Error writing : %s", Filename); 
				MessageBox(NULL, Message, "Error", MB_OK | MB_ICONWARNING);
			}

			// Free the allocation
			free(pBMP);
		}

		// Close the file
		CloseHandle(FileHandle);
	}
}