#ifndef __MODES_HEADER
#define __MODES_HEADER

#define MAX_MODES								32

typedef struct MODE
{
	int											Width;
	int											Height;
	int											BitDepth;
} MODE;

BOOL											InitModes(void);
void											TidyModes(void);
HRESULT WINAPI									EnumModes(LPDDSURFACEDESC2, LPVOID);
BOOL											ChangeMode(int, BOOL);
void											RestoreMode(HWND);
void											FlipScreens(void);
void											UpdateModeWindowCoords(HWND);
BOOL											CreateTexture(void);
void											DestroyTexture(void);
BOOL											UpdateTexture(void);
BOOL											DrawTexture(void);
void											SetModeSmoothing(BOOL);
BOOL											FullScreenMode(void);
void											ClearBorders(void);
void											FlipToGDISurface(BOOL);
void											PopulateModesCombo(HWND);

#endif