#ifndef __AUDIO_HEADER_FILE
#define __AUDIO_HEADER_FILE

#define NO_OF_AUDIO_BUFFERS					6

typedef struct RIFF_HEADER
{
	char									ID[4];
	unsigned int							Length;
} RIFF_HEADER, RIFF_CHUNK;

#pragma pack (push, 1)

typedef struct WAV_HEADER
{
	RIFF_HEADER								RiffHeader;
	char									WaveID[4];
	RIFF_CHUNK								FormatChunk;
	WAVEFORMATEX							WaveFormat;
	RIFF_CHUNK								DataChunk;
} WAV_HEADER;

#pragma pack (pop)

BOOL										InitAudio(HWND, int, int);
BOOL										InitSimpleAudio(HWND, int, int);
void										TidyAudio(void);
void										UpdateAudio(short *, int, int);
void										StopAudio(void);
BOOL										CreateSoundRecording(void);
void										UpdateSoundRecording(int);
void										CloseSoundRecording(void);
void										SetWavHeaderInfo(unsigned int, int, int);

#endif