//============================================================================
//
//   SSSS    tt          lll  lll       
//  SS  SS   tt           ll   ll        
//  SS     tttttt  eeee   ll   ll   aaaa 
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-1998 by Bradford W. Mott
//
// See the file "license" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: PropsSet.cxx,v 1.4 2002/04/12 21:53:02 stephena Exp $
//============================================================================

//#include <assert.h>
#include "Props.hxx"
#include "PropsSet.hxx"

#ifdef __cplusplus
extern "C" {
#endif

#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "string.h"

#ifdef __cplusplus
}
#endif

extern GPDRAWSURFACE gpDraw[];
extern uInt32 numframes  ;
extern uInt32 totalStart ;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
PropertiesSet::PropertiesSet()
{
  root = 0;
  mySize = 0;
  useMemList = true;
  proStream = 0 ;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
PropertiesSet::~PropertiesSet()
{
  deleteNode(root);
//  proStream.close();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::getMD5(char *md5, Properties &properties)
{

	char *currentMd5 = myProperties.get("Cartridge.MD5");

	if( gp_str_func.compare(currentMd5, md5 )==0)
	{
		properties = myProperties ;
	}
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::insert(Properties& properties)
{
	myProperties = properties ;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::insertNode(TreeNode* &t, Properties& properties)
{
  if(t)
  {
    char *md5 = properties.get("Cartridge.MD5");
    char *currentMd5 = t->props->get("Cartridge.MD5");

    if( gp_str_func.compare( md5, currentMd5) < 0 )
      insertNode(t->left, properties);
    else if( gp_str_func.compare(md5, currentMd5 ) > 0 )
      insertNode(t->right, properties);
    else
    {
      delete t->props;
      t->props = new Properties(properties);
    }
  }
  else
  {
    t = new TreeNode;
    t->props = new Properties(properties);
    t->left = 0;
    t->right = 0;
  }
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::deleteNode(TreeNode *node)
{
  if(node)
  {
    deleteNode(node->left);
    deleteNode(node->right);
    delete node->props;
    delete node;
  }
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::load(unsigned char *buf, unsigned char *md5, Properties& defproperties ) 
{
	unsigned char line[200] ;
	unsigned char *md5loc ;

	if ( ( md5loc = (unsigned char*)strstr( (const char*)buf, (const char*)md5 ) ) == NULL )
	{
		return ;
	}


	Properties properties( defproperties ) ;
	

	properties.load( md5loc ) ;


	if ( properties.mySize > 0 )
	{
		myProperties = properties ;
		mySize = 1 ;

	}
	else
	{
		mySize = 0 ;
	}
}

void PropertiesSet::load(char *filename, Properties* defaults, bool useList, GPDRAWSURFACE *screen)
{
	useMemList = useList;
//	defProps   = defaults;
	F_HANDLE fhandle ;
	unsigned char line[200] ;
	unsigned char *gname ;

	if ( GpFileOpen( filename, OPEN_R, &fhandle ) != SM_OK )
	{
		return ;
	}

	// Loop reading properties
	for(;;)
	{
		// Get the property list associated with this profile
		/*
		Properties properties(defProps);
		if ( properties.load( fhandle ) )
		{
			if ( properties.mySize > 0 )
			{
				insert(properties);
				gname = (unsigned char*)properties.get( "Cartridge.Name" ) ;

				GpRectFill(NULL, screen, 0, 32, 320, 16, 0x00 ) ;
				GpTextOut(NULL, screen, 0, 32, (char*)gname, 0xFF ) ;

			}
		}
		else
		{
			break ;
		}
		*/
	}

	GpFileClose( fhandle ) ;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::save( F_HANDLE out)
{
  saveNode(out, root);
}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void PropertiesSet::saveNode( F_HANDLE out, TreeNode *node)
{
  if(node)
  {
    saveNode(out, node->left);
    saveNode(out, node->right);
    node->props->save(out);
  }
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
uInt32 PropertiesSet::size() 
{
  return mySize;
}
