//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#ifndef __TLCS900H_SINGLE__
#define __TLCS900H_SINGLE__
//=========================================================================

//===== NOP
void NOP(void);

//===== NORMAL
void NORMAL(void);

//===== PUSH SR
void PUSHSR(void);

//===== POP SR
void POPSR(void);

//===== MAX
void MAX(void);

//===== HALT
void HALT(void);

//===== EI #3
void EI(void);

//===== RETI
void RETI(void);

//===== LD (n), n
void LD8_8(void);

//===== PUSH n
void PUSH8(void);

//===== LD (n), nn
void LD8_16(void);

//===== PUSH nn
void PUSH16(void);

//===== INCF
void INCF(void);

//===== DECF
void DECF(void);

//===== RET condition
void RET(void);

//===== RETD dd
void RETD(void);

//===== RCF
void RCF(void);

//===== SCF
void SCF(void);

//===== CCF
void CCF(void);

//===== ZCF
void ZCF(void);

//===== PUSH A
void PUSHA(void);

//===== POP A
void POPA(void);

//===== EX F,F'
void EX(void);

//===== LDF #3
void LDF(void);

//===== PUSH F
void PUSHF(void);

//===== POP F
void POPF(void);

//===== JP nn
void JP16(void);

//===== JP nnn
void JP24(void);

//===== CALL #16
void CALL16(void);

//===== CALL #24
void CALL24(void);

//===== CALR $+3+d16
void CALR(void);

//===== LD R, n
void LDB(void);

//===== PUSH RR
void PUSHW(void);

//===== LD RR, nn
void LDW(void);

//===== PUSH XRR
void PUSHL(void);

//===== LD XRR, nnnn
void LDL(void);

//===== POP RR
void POPW(void);

//===== POP XRR
void POPL(void);

//===== JR cc,PC + d
void JR(void);

//===== JR cc,PC + dd
void JRL(void);

//===== LDX dst,src
void LDX(void);

//===== SWI num
void SWI(void);

//=============================================================================
#endif
