//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

21 JUL 2002 - neopop_uk
=======================================
- Created this file to abstract the storage and retrieval of
configuration settings

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include <windows.h>

//For default keys
#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>

//=============================================================================

//Window positions
int mainview_x, mainview_y;
int debugview_x, debugview_y;
int codeview_x, codeview_y;
int memview_x, memview_y;
int regview_x, regview_y;
int z80regview_x, z80regview_y;

char RomDirectory[_MAX_PATH];

char StateDirectory[_MAX_PATH];

//Controls
int BUTTONA;
int BUTTONB;
int BUTTONO;

int KEYA;
int KEYB;
int KEYO;
int KEYU;
int KEYD;
int KEYL;
int KEYR;

bool AUTOA;	//Autofire A
bool AUTOB;	//Autofire B

int zoom;

bool mute;

//=============================================================================

//-----------------------------------------------------------------------------
// system_get_config()
//-----------------------------------------------------------------------------
void system_get_config(void)
{
	HKEY handle = NULL;
	DWORD value;
	DWORD size;
	char path[_MAX_PATH];

	//Try and open
	RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\NeoPop", 0, KEY_QUERY_VALUE, &handle);

	size = sizeof(DWORD);

	//***** Zoom
	if (RegQueryValueEx(handle, "zoom", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		zoom = min(max(value, 1), 4); else zoom = 1;

	//***** Mute
	if (RegQueryValueEx(handle, "mute", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		mute = (bool)value; else mute = false;

	//***** Stereo
	if (RegQueryValueEx(handle, "stereo", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		stereo = (bool)value; else stereo = true;

	//***** Language
	if (RegQueryValueEx(handle, "language", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		language_english = (bool)value; else language_english = true;

	//***** Colour
	if (RegQueryValueEx(handle, "colour", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		system_colour = (bool)value; else system_colour = true;

	//***** Frequency
	if (RegQueryValueEx(handle, "frequency", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
	{
		if (value == 11025)
			sound_frequency = 11025;
		else
		{
			if (value == 22050)
				sound_frequency = 22050;
			else
				sound_frequency = 44100;
		}
	}

	//***** Joystick Buttons
	if (RegQueryValueEx(handle, "button_a", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		BUTTONA = min(max(value, 0), 31); else BUTTONA = 0;
	if (RegQueryValueEx(handle, "button_b", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		BUTTONB = min(max(value, 0), 31); else BUTTONB = 1;
	if (RegQueryValueEx(handle, "button_o", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		BUTTONO = min(max(value, 0), 31); else BUTTONO = 5;

	if (RegQueryValueEx(handle, "auto_a", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		AUTOA = (bool)value; else AUTOA = false;
	if (RegQueryValueEx(handle, "auto_b", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		AUTOB = (bool)value; else AUTOB = false;

	//***** Keyboard Buttons
	if (RegQueryValueEx(handle, "key_a", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYA = min(max(value, 0), 0xFF); else KEYA = DIK_Z;
	if (RegQueryValueEx(handle, "key_b", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYB = min(max(value, 0), 0xFF); else KEYB = DIK_X;
	if (RegQueryValueEx(handle, "key_o", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYO = min(max(value, 0), 0xFF); else KEYO = DIK_TAB;

	//***** Keyboard Directions
	if (RegQueryValueEx(handle, "key_u", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYU = min(max(value, 0), 0xFF); else KEYU = DIK_UP;
	if (RegQueryValueEx(handle, "key_d", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYD = min(max(value, 0), 0xFF); else KEYD = DIK_DOWN;
	if (RegQueryValueEx(handle, "key_l", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYL = min(max(value, 0), 0xFF); else KEYL = DIK_LEFT;
	if (RegQueryValueEx(handle, "key_r", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		KEYR = min(max(value, 0), 0xFF); else KEYR = DIK_RIGHT;

	//***** Main Window Positions
	if (RegQueryValueEx(handle, "mainview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		mainview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 20); 
	else mainview_x = (int)(GetSystemMetrics(SM_CXSCREEN) * 0.25f);
	if (RegQueryValueEx(handle, "mainview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		mainview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); 
	else mainview_y = (int)(GetSystemMetrics(SM_CYSCREEN) * 0.25f);

#ifdef NEOPOP_DEBUG
	//***** Debugger Window Positions
	if (RegQueryValueEx(handle, "debugview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		debugview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 40); else debugview_x = 10;
	if (RegQueryValueEx(handle, "debugview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		debugview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); else debugview_y = 10;

	//***** Code View Window Positions
	if (RegQueryValueEx(handle, "codeview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		codeview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 40); else codeview_x = 20;
	if (RegQueryValueEx(handle, "codeview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		codeview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); else codeview_y = 20;

	//***** Reg View Window Positions
	if (RegQueryValueEx(handle, "regview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		regview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 40); else regview_x = 30;
	if (RegQueryValueEx(handle, "regview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		regview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); else regview_y = 30;

	//***** Z80 Reg View Window Positions
	if (RegQueryValueEx(handle, "z80regview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		z80regview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 40); else z80regview_x = 50;
	if (RegQueryValueEx(handle, "z80regview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		z80regview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); else z80regview_y = 50;

	//***** Mem View Window Positions
	if (RegQueryValueEx(handle, "memview_x", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		memview_x = min(max((int)value, 0), GetSystemMetrics(SM_CXSCREEN) - 40); else memview_x = 40;
	if (RegQueryValueEx(handle, "memview_y", 0, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		memview_y = min(max((int)value, 0), GetSystemMetrics(SM_CYSCREEN) - 10); else memview_y = 40;

	//***** Debug Filters
	if (RegQueryValueEx(handle, "filter_sound", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		filter_sound = min(max(value, 0), 1); else filter_sound = 0;
	if (RegQueryValueEx(handle, "filter_dma", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		filter_dma = min(max(value, 0), 1); else filter_dma = 0;
	if (RegQueryValueEx(handle, "filter_bios", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		filter_bios = min(max(value, 0), 1); else filter_bios = 0;
	if (RegQueryValueEx(handle, "filter_mem", NULL, NULL, (BYTE*)(&value), &size) == ERROR_SUCCESS)
		filter_mem = min(max(value, 0), 1); else filter_mem = 0;
#endif

	//***** RomDirectory
	size = _MAX_PATH;
	if (RegQueryValueEx(handle, "dir", NULL, NULL, (BYTE*)(path), &size) == ERROR_SUCCESS)
		sprintf(RomDirectory, "%s", path);
	else
		sprintf(RomDirectory, ".\\ROMS\\");

	//***** StateDirectory
	size = _MAX_PATH;
	if (RegQueryValueEx(handle, "state_dir", NULL, NULL, (BYTE*)(path), &size) == ERROR_SUCCESS)
		sprintf(StateDirectory, "%s", path);
	else
		sprintf(StateDirectory, ".\\STATES\\");

	//Close the key
	if (handle)
		RegCloseKey(handle);
}

//=============================================================================

//-----------------------------------------------------------------------------
// system_put_config()
//-----------------------------------------------------------------------------
void system_put_config(void)
{
	HKEY handle;
	DWORD disposition;
	DWORD value;
	DWORD size;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\NeoPop", 0,
		"Settings", REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
		&handle, &disposition) != ERROR_SUCCESS)
		return;

	//***** Zoom
	value = zoom;
	RegSetValueEx(handle, "zoom", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Mute
	value = mute;
	RegSetValueEx(handle, "mute", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Stereo
	value = stereo;
	RegSetValueEx(handle, "stereo", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Language
	value = language_english;
	RegSetValueEx(handle, "language", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Language
	value = system_colour;
	RegSetValueEx(handle, "colour", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Frequency
	value = sound_frequency;
	RegSetValueEx(handle, "frequency", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** RomDirectory
	size = strlen(RomDirectory) + 1;
	RegSetValueEx(handle, "dir", 0, REG_SZ, RomDirectory, size);

	//***** StateDirectory
	size = strlen(StateDirectory) + 1;
	RegSetValueEx(handle, "state_dir", 0, REG_SZ, StateDirectory, size);

	//***** Joystick Buttons
	value = BUTTONA;RegSetValueEx(handle, "button_a", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = BUTTONB;RegSetValueEx(handle, "button_b", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = BUTTONO;RegSetValueEx(handle, "button_o", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = AUTOA;RegSetValueEx(handle, "auto_a", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = AUTOB;RegSetValueEx(handle, "auto_b", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Keyboard Buttons
	value = KEYA;RegSetValueEx(handle, "key_a", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = KEYB;RegSetValueEx(handle, "key_b", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = KEYO;RegSetValueEx(handle, "key_o", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Keyboard Directions
	value = KEYU;RegSetValueEx(handle, "key_u", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = KEYD;RegSetValueEx(handle, "key_d", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = KEYL;RegSetValueEx(handle, "key_l", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = KEYR;RegSetValueEx(handle, "key_r", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Main Window Positions
	value = mainview_x;RegSetValueEx(handle, "mainview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = mainview_y;RegSetValueEx(handle, "mainview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

#ifdef NEOPOP_DEBUG
	//***** Debugger Window Positions
	value = debugview_x;RegSetValueEx(handle, "debugview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = debugview_y;RegSetValueEx(handle, "debugview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Code View Window Positions
	value = codeview_x;RegSetValueEx(handle, "codeview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = codeview_y;RegSetValueEx(handle, "codeview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Reg View Window Positions
	value = regview_x;RegSetValueEx(handle, "regview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = regview_y;RegSetValueEx(handle, "regview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Z80 Reg View Window Positions
	value = z80regview_x;RegSetValueEx(handle, "z80regview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = z80regview_y;RegSetValueEx(handle, "z80regview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Mem View Window Positions
	value = memview_x;RegSetValueEx(handle, "memview_x", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = memview_y;RegSetValueEx(handle, "memview_y", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));

	//***** Debug Filters
	value = filter_sound;RegSetValueEx(handle, "filter_sound", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = filter_dma;RegSetValueEx(handle, "filter_dma", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = filter_bios;RegSetValueEx(handle, "filter_bios", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
	value = filter_mem;RegSetValueEx(handle, "filter_mem", 0, REG_DWORD, (BYTE*)(&value), sizeof(DWORD));
#endif
	
	//Close the key
	RegCloseKey(handle);
}

//=============================================================================
