//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// History of changes:
// ===================
//
// Version 0.50 / 20 JUL 2002 - neopop_uk
// ======================================
//	- Cleaned and tidied up for the source release
//
//---------------------------------------------------------------------------

#include "neopop.h"
#include "system_windows.h"
#include <tchar.h>
#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>
#include "system_input.h"

//=============================================================================

typedef struct 
{
	int dik;
	char name[16];
}
Skey;

static Skey keymap[] =
{
	DIK_UP,			"Up",
	DIK_DOWN,		"Down",
	DIK_LEFT,		"Left",
	DIK_RIGHT,		"Right",

	DIK_SPACE,		"Space",
	DIK_ESCAPE,		"Escape",
	DIK_TAB,		"Tab",
	DIK_RETURN,		"Return",
	DIK_BACKSPACE,	"Backspace",
	DIK_LCONTROL,	"Ctrl (L)",
	DIK_RCONTROL,	"Ctrl (R)",
	DIK_LSHIFT,		"Shift (L)",
	DIK_RSHIFT,		"Shift (R)",
	DIK_LALT,		"Alt (L)",
	DIK_RALT,		"Alt (R)",

	//

	DIK_A, "A",	DIK_B, "B",	DIK_C, "C",	DIK_D, "D",	DIK_E, "E",	DIK_F, "F",
	DIK_G, "G",	DIK_H, "H",	DIK_I, "I",	DIK_J, "J",	DIK_K, "K",	DIK_L, "L",
	DIK_M, "M",	DIK_N, "N",	DIK_O, "O",	DIK_P, "P",	DIK_Q, "Q",	DIK_R, "R",
	DIK_S, "S",	DIK_T, "T",	DIK_U, "U",	DIK_V, "V",	DIK_W, "W",	DIK_X, "X",
	DIK_Y, "Y",	DIK_Z, "Z",

	//

	-1, "error"
};

//=============================================================================
static HWND g_controlU, g_controlD;
static HWND g_controlL, g_controlR;
static HWND g_controlA, g_controlKA, g_controlAA;
static HWND g_controlB, g_controlKB, g_controlAB;
static HWND g_controlO, g_controlKO;

static void update(HWND hDlg)
{
	int i;
	DWORD item;

	g_controlAA = GetDlgItem( hDlg, IDC_CHECKA );
	g_controlAB = GetDlgItem( hDlg, IDC_CHECKB );

	g_controlU = GetDlgItem( hDlg, IDC_COMBOU );
	g_controlD = GetDlgItem( hDlg, IDC_COMBOD );
	g_controlL = GetDlgItem( hDlg, IDC_COMBOL );
	g_controlR = GetDlgItem( hDlg, IDC_COMBOR );

	g_controlKA = GetDlgItem( hDlg, IDC_COMBOKA );
	g_controlKB = GetDlgItem( hDlg, IDC_COMBOKB );
	g_controlKO = GetDlgItem( hDlg, IDC_COMBOKO );
	g_controlA = GetDlgItem( hDlg, IDC_COMBOA );
	g_controlB = GetDlgItem( hDlg, IDC_COMBOB );
	g_controlO = GetDlgItem( hDlg, IDC_COMBOO );

	//Autofire
	Button_SetCheck(g_controlAA, AUTOA);
	Button_SetCheck(g_controlAB, AUTOB);

	//joystick?
	if (system_input_buttoncount() > 0)
	{
		//Add the button choices
		for (i = 0; i < system_input_buttoncount(); i++)
		{
			char* b = system_input_buttonname(i);
			TCHAR string[16];
			wsprintf( string, _T("%s"), b);

			//Select button A
			item = ComboBox_AddString(g_controlA, string);
			if (i == BUTTONA) ComboBox_SetCurSel(g_controlA, item);

			//Select button B
			item = ComboBox_AddString(g_controlB, string);
			if (i == BUTTONB) ComboBox_SetCurSel(g_controlB, item);

			//Select button Option
			item = ComboBox_AddString(g_controlO, string);
			if (i == BUTTONO) ComboBox_SetCurSel(g_controlO, item);			

			free(b);
		}
	}
	else
	{
		//Disable
		ComboBox_Enable(g_controlA, false);
		ComboBox_Enable(g_controlB, false);
		ComboBox_Enable(g_controlO, false);
	}

	i = 0;

	//Keyboard, Add the choices
	while(keymap[i].dik != -1)
	{
		TCHAR string[16];
		wsprintf( string, _T("%s"), keymap[i].name);
		
		//Select key UP
		item = ComboBox_AddString(g_controlU, string);
		if (keymap[i].dik == KEYU)	ComboBox_SetCurSel(g_controlU, item);
		//Select key DOWN
		item = ComboBox_AddString(g_controlD, string);
		if (keymap[i].dik == KEYD)	ComboBox_SetCurSel(g_controlD, item);
		//Select key LEFT
		item = ComboBox_AddString(g_controlL, string);
		if (keymap[i].dik == KEYL)	ComboBox_SetCurSel(g_controlL, item);
		//Select key RIGHT
		item = ComboBox_AddString(g_controlR, string);
		if (keymap[i].dik == KEYR)	ComboBox_SetCurSel(g_controlR, item);
		
		//Select key A
		item = ComboBox_AddString(g_controlKA, string);
		if (keymap[i].dik == KEYA) ComboBox_SetCurSel(g_controlKA, item);

		//Select key B
		item = ComboBox_AddString(g_controlKB, string);
		if (keymap[i].dik == KEYB) ComboBox_SetCurSel(g_controlKB, item);

		//Select key Option
		item = ComboBox_AddString(g_controlKO, string);
		if (keymap[i].dik == KEYO) ComboBox_SetCurSel(g_controlKO, item);
		
		i ++;
	}
}


BOOL CALLBACK InputDlg(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		update(hDlg);
		return 1;

	case WM_COMMAND:
		{
			DWORD selA = ComboBox_GetCurSel(g_controlA);
			DWORD selB = ComboBox_GetCurSel(g_controlB);
			DWORD selO = ComboBox_GetCurSel(g_controlO);

			DWORD selKA = ComboBox_GetCurSel(g_controlKA);
			DWORD selKB = ComboBox_GetCurSel(g_controlKB);
			DWORD selKO = ComboBox_GetCurSel(g_controlKO);
		
			DWORD selU = ComboBox_GetCurSel(g_controlU);
			DWORD selD = ComboBox_GetCurSel(g_controlD);
			DWORD selL = ComboBox_GetCurSel(g_controlL);
			DWORD selR = ComboBox_GetCurSel(g_controlR);

			switch(LOWORD(wParam))
			{
			case IDCANCEL:
				EndDialog(hDlg, 0);
				return 1;

			case IDDEFAULT:
				if (MessageBox(hDlg, 
					"Are you sure you want to revert to the default control setup?",
					PROGRAM_NAME, MB_YESNO | MB_ICONQUESTION) == IDYES)
				{					
					KEYU = DIK_UP;
					KEYD = DIK_DOWN;
					KEYL = DIK_LEFT;
					KEYR = DIK_RIGHT;
					KEYA = DIK_Z;
					KEYB = DIK_X;
					KEYO = DIK_TAB;
					BUTTONA = 0;
					BUTTONB = 1;
					BUTTONO = 5;
				}
			
				update(hDlg);
				break;

			case IDC_CHECKA:	AUTOA = ! AUTOA;	return 1;
			case IDC_CHECKB:	AUTOB = ! AUTOB;	return 1;
			}

			if (HIWORD(wParam) == CBN_SELENDOK)
			{
				switch (LOWORD(wParam))
				{
				//Joy buttons
				case IDC_COMBOA:	BUTTONA = selA; break;
				case IDC_COMBOB:	BUTTONB = selB; break;
				case IDC_COMBOO:	BUTTONO = selO; break;

				//Key buttons
				case IDC_COMBOKA:	KEYA = keymap[selKA].dik; break;
				case IDC_COMBOKB:	KEYB = keymap[selKB].dik; break;
				case IDC_COMBOKO:	KEYO = keymap[selKO].dik; break;

				//Key D-Pad
				case IDC_COMBOU:	KEYU = keymap[selU].dik; break;
				case IDC_COMBOD:	KEYD = keymap[selD].dik; break;
				case IDC_COMBOL:	KEYL = keymap[selL].dik; break;
				case IDC_COMBOR:	KEYR = keymap[selR].dik; break;
				}

				return 1;
			}
		}

		break;
	}

	return 0;
}
