//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#ifndef __MEM__
#define __MEM__
//=============================================================================

#define RAM_START	0x000000
#define RAM_END		0x00BFFF

#define ROM_START	0x200000
#define ROM_END		0x3FFFFF

#define HIROM_START	0x800000
#define HIROM_END	0x9FFFFF

#define BIOS_START	0xFF0000
#define BIOS_END	0xFFFFFF

extern _u8 ram[1 + RAM_END - RAM_START];

void reset_memory(void);

void* translate_address_read(_u32 address);
void* translate_address_write(_u32 address);

void dump_memory(_u32 start, _u32 length);

extern bool debug_abort_memory;

extern bool debug_mask_memory_error_messages;
extern _u32 eepromData;	//Pretty hacky way to detect it, but what the hell!

extern bool memory_unlock_flash_write;
extern bool memory_flash_error;

//=============================================================================

_u8  loadB(_u32 address);
_u16 loadW(_u32 address);
_u32 loadL(_u32 address);

void storeB(_u32 address, _u8 data);
void storeW(_u32 address, _u16 data);
void storeL(_u32 address, _u32 data);


//=============================================================================
#endif
