//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

21 JUL 2002 - neopop_uk
=======================================
- Omitted the failure message for VECT_FLASHWRITE until games like
	"Bust-a-Move" can use it properly.

22 JUL 2002 - neopop_uk
=======================================
- Re-added the failure message because the games that had problems are
	now fixed due to the modification of the "SWI" instruction.
- Fixed "Fatal Fury" by removing the failure message on VECT_COMCREATEDATA

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "bios.h"
#include "TLCS900h_registers.h"
#include "TLCS900h_interpret.h"
#include "mem.h"

//=============================================================================

/* This is the custom HLE instruction. I considered it was the fastest and
most streamlined way of intercepting a bios call. The operation performed
is dependant on the current program counter. */

void iBIOSHLE(void)
{
#ifdef BIOSHLE
	//Ony works in the bios)
	if ((pc & 0xFFFF0000) != 0x00FF0000)
		return;

	pc --;	//Compensate for processing this instruction.

	cycles = 8;		//TODO: Correct cycle counts (or approx?)

	switch (pc & 0xFFFFFF)
	{	
		//VECT_SHUTDOWN
	case 0xFF27A2: 
		//TODO
		break;

		//VECT_CLOCKGEARSET
	case 0xFF1030:
		//TODO
		break;

		//VECT_RTCGET
	case 0xFF1440:
		
		update_rtc();	//Update hardware area

		if (rCodeL(0x3C) < 0xC000)
		{
			//Copy data from hardware area
			ram[rCodeL(0x3C) + 0] = ram[0x91];
			ram[rCodeL(0x3C) + 1] = ram[0x92];
			ram[rCodeL(0x3C) + 2] = ram[0x93];
			ram[rCodeL(0x3C) + 3] = ram[0x94];
			ram[rCodeL(0x3C) + 4] = ram[0x95];
			ram[rCodeL(0x3C) + 5] = ram[0x96];
			ram[rCodeL(0x3C) + 6] = ram[0x97];
		}

		break; 
	
		//?
	case 0xFF12B4: break;
	
		//VECT_INTLVSET
	case 0xFF1222:
		{

	_u8 level = rCodeB(0x35); //RB3
	_u8 interrupt = rCodeB(0x34);	//RC3

	//   0 - Interrupt from RTC alarm
	//   1 - Interrupt from the Z80 CPU
	//   2 - Interrupt from the 8 bit timer 0
	//   3 - Interrupt from the 8 bit timer 1
	//   4 - Interrupt from the 8 bit timer 2
	//   5 - Interrupt from the 8 bit timer 3
	//   6 - End of transfer interrupt from DMA channel 0
	//   7 - End of transfer interrupt from DMA channel 1
	//   8 - End of transfer interrupt from DMA channel 2
	//   9 - End of transfer interrupt from DMA channel 3

	switch(interrupt)
	{
	case 0x00:	ram[0x70] = (ram[0x70] & 0xf0) |  (level & 0x07);		break;
	case 0x01:	ram[0x71] = (ram[0x71] & 0x0f) | ((level & 0x07)<<4);	break;
	case 0x02:	ram[0x73] = (ram[0x73] & 0xf0) |  (level & 0x07);		break;
	case 0x03:	ram[0x73] = (ram[0x73] & 0x0f) | ((level & 0x07)<<4);	break;
	case 0x04:	ram[0x74] = (ram[0x74] & 0xf0) |  (level & 0x07);		break;
	case 0x05:	ram[0x74] = (ram[0x74] & 0x0f) | ((level & 0x07)<<4);	break;
	case 0x06:	ram[0x79] = (ram[0x79] & 0xf0) |  (level & 0x07);		break;
	case 0x07:	ram[0x79] = (ram[0x79] & 0x0f) | ((level & 0x07)<<4);	break;
	case 0x08:	ram[0x7a] = (ram[0x7a] & 0xf0) |  (level & 0x07);		break;
	case 0x09:	ram[0x7a] = (ram[0x7a] & 0x0f) | ((level & 0x07)<<4);	break;
	}
		}
		break;	
	
		//VECT_SYSFONTSET
	case 0xFF8D8A:
		{
			_u8 a,b,c, j;
			_u16 i, dst = 0xA000;

			b = rCodeB(0x30) >> 4;
			a = rCodeB(0x30) & 3;

			for (i = 0; i < 0x800; i++)
			{
				c = bios[0x8DCF + i];

				for (j = 0; j < 8; j++, c<<=1)
				{
					*(_u16*)(ram + dst) <<= 2;

					if (c & 0x80)	ram[dst] |= a;
					else			ram[dst] |= b;
				}

				dst += 2;
			}
		}
		
		break;
	
		//VECT_FLASHWRITE
	case 0xFF6FD8:
		{
			_u32 i, bank = 0x200000;

			//Select HI rom?
			if (rCodeB(0x30) == 1)
				bank = 0x800000;

#ifdef NEOPOP_DEBUG
			if (filter_bios)
				system_debug_message("VECT_FLASHWRITE: %08X -> %08X,  %d bytes",
					rCodeL(0x3C), rCodeL(0x38) + bank, rCodeW(0x34) * 256);
#endif
			
			memory_flash_error = false;
			memory_unlock_flash_write = true;
			//Copy as 32 bit values for speed
			for (i = 0; i < rCodeW(0x34) * 64ul; i++)
				storeL(rCodeL(0x38) + bank + (i * 4), loadL(rCodeL(0x3C) + (i * 4)));
			memory_unlock_flash_write = false;

			//<=== TODO - Save this data to an external file

			if (memory_flash_error)
			{
#ifdef NEOPOP_DEBUG
				if (filter_bios)
					system_debug_message("VECT_FLASHWRITE: Error");
#endif
				rCodeB(0x30) = 0xFF;	//RA3 = SYS_FAILURE
			}
			else
				rCodeB(0x30) = 0;		//RA3 = SYS_SUCCESS
		}

		break;
	
		//VECT_FLASHALLERS
	case 0xFF7042:
		//TODO
		rCodeB(0x30) = 0;	//RA3 = SYS_SUCCESS
		break;
	
		//VECT_FLASHERS
	case 0xFF7082:
#ifdef NEOPOP_DEBUG
		if (filter_bios)
			system_debug_message("FLASHERASE: bank %d, block %d", rCodeB(0x30), rCodeB(0x35));
#endif
		//TODO
		rCodeB(0x30) = 0;	//RA3 = SYS_SUCCESS
		break;
	
		//VECT_ALARMSET
	case 0xFF149B:
		//TODO
		rCodeB(0x30) = 0;	//RA3 = SYS_SUCCESS
		break;
	
		//?
	case 0xFF1033: break;
	
		//VECT_ALARMDOWNSET
	case 0xFF1487:
		//TODO
		rCodeB(0x30) = 0;	//RA3 = SYS_SUCCESS
		break;

		//?
	case 0xFF731F: break;
	
		//VECT_FLASHPROTECT
	case 0xFF70CA:
		//TODO
		rCodeB(0x30) = 0;	//RA3 = SYS_SUCCESS
		break;
	
		//VECT_GEMODESET
	case 0xFF17C4:
		//TODO
		break;
	
		//?
	case 0xFF1032: break;
	
		//VECT_COMINIT
	case 0xFF2BBD:
		//TODO
		rCodeB(0x30) = 0;	//RA3 = COM_BUF_OK
		break;
	
		//VECT_COMSENDSTART
	case 0xFF2C0C:
		//TODO
		break;
	
		//VECT_COMRECIVESTART
	case 0xFF2C44:
		//TODO
		break;
	
		//VECT_COMCREATEDATA
	case 0xFF2C86:
		rCodeB(0x30) = 0x0;			//RA3 = COM_BUF_OK
		break;
	
		//VECT_COMGETDATA
	case 0xFF2CB4:
		//TODO
		rCodeB(0x30) = 0x01;	//RA3 = COM_BUF_EMPTY
		break;
	
		//VECT_COMONRTS
	case 0xFF2D27:	ram[0xB2] = 0;	break;
	
		//VECT_COMOFFRTS
	case 0xFF2D33: 	ram[0xB2] = 1;	break;	
	
		//VECT_COMSENDSTATUS
	case 0xFF2D3A:
		//TODO
		rCodeW(0x30) = 0;	//RWA3 = 0
		break;
	
		//VECT_COMRECIVESTATUS
	case 0xFF2D4E:
		//TODO
		rCodeW(0x30) = 0;	//RWA3 = 0
		break;
	
		//VECT_COMCREATEBUFDATA
	case 0xFF2D6C:
		//TODO
		rCodeB(0x35) = 0x00;	//RB3 = 0
		break;
	
		//VECT_COMGETBUFDATA
	case 0xFF2D85:
		//TODO
		//rCodeB(0x35) = 0x00;	//RB3 = 0
		break;

	default:
#ifdef NEOPOP_DEBUG
		system_debug_message("Unemulated bios HLE function at %06X", pc);
#else
		system_message("Unemulated bios HLE function at %06X", pc);
#endif
		break;
	}

	//RET
	pc = pop32();

#endif
}

//=============================================================================
