//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"

//=============================================================================

//-----------------------------------------------------------------------------
// system_io_rom_read()
//-----------------------------------------------------------------------------
bool system_io_rom_read(char* filename, _u8* buffer, _u32 bufferLength)
{
	FILE* file;
	file = fopen(filename, "rb");

	if (file)
	{
		fread(buffer, bufferLength, sizeof(_u8), file);
		fclose(file);
		return true;
	}

	return false;
}

//-----------------------------------------------------------------------------
// system_io_flash_read()
//-----------------------------------------------------------------------------
bool system_io_flash_read(char* filename, _u8* buffer, _u32 bufferLength)
{
	//Not used
	return true;
}

//-----------------------------------------------------------------------------
// system_io_flash_write()
//-----------------------------------------------------------------------------
bool system_io_flash_write(char* filename, _u8* buffer, _u32 bufferLength)
{
	//Not used
	return true;
}

//-----------------------------------------------------------------------------
// system_io_state_read()
//-----------------------------------------------------------------------------
bool system_io_state_read(char* filename, _u8* buffer, _u32 bufferLength)
{
	FILE* file;
	file = fopen(filename, "rb");

	if (file)
	{
		fread(buffer, bufferLength, sizeof(_u8), file);
		fclose(file);
		return true;
	}

	return false;
}

//-----------------------------------------------------------------------------
// system_io_state_write()
//-----------------------------------------------------------------------------
bool system_io_state_write(char* filename, _u8* buffer, _u32 bufferLength)
{
	FILE* file;
	file = fopen(filename, "wb");

	if (file)
	{
		fwrite(buffer, bufferLength, sizeof(_u8), file);
		fclose(file);
		return true;
	}

	return false;
}


//=============================================================================
