//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

21 JUL 2002 - neopop_uk
=======================================
- This file holds the declarations for all debugger related data,
excluding the configuration options - these are held in 'system_config.h'
- Moved this file into the 'Debugger' folder. This is to aid
abstraction, and for porters who don't need to port the debugger.

//---------------------------------------------------------------------------
*/

#ifndef __SYSTEM_DEBUG__
#define __SYSTEM_DEBUG__
//=============================================================================

#ifdef NEOPOP_DEBUG

	void system_debug_init(void);

	void system_debug_shutdown(void);

	void system_debug_start(bool dis_TLCS900h, bool dis_Z80);

	bool system_debug_running(void);

	void system_debug_clear(void);

	//Address of breakpoint (z80 address is 0x000 - 0xFFF)
	// -1 means no breakpoint, hence signed value
	extern _s32 breakpoint, breakpoint_z80;

	//Returns true, prints a message and stops the debugger if
	//a breakpoint is reached.
	bool breakpoint_reached(void);

	//Debugger Windows
	extern bool memview_enabled;
	extern bool regview_enabled;
	extern bool z80regview_enabled;
	extern bool codeview_enabled;

	//Execution mode
	extern bool running_dis_TLCS900h;
	extern bool running_dis_Z80;

	//Address edit box
	extern HWND address_edit;

	//Register Viewer
	void reg_open(void);
	void reg_close(void);
	void reg_update(void);

	//Z80 Register Viewer
	void z80reg_open(void);
	void z80reg_close(void);
	void z80reg_update(void);

	//Memory Viewer
	void mem_open(void);
	void mem_close(void);
	void mem_update(void);

	//Code Viewer
	void code_open(void);
	void code_close(void);
	void code_update(void);

#endif

//=============================================================================
#endif
