//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "TLCS900H_disassemble.h"
#include "dma.h"
#include "mem.h"

//=============================================================================

_u32 dmaS[4], dmaD[4];
_u16 dmaC[4];
_u8 dmaM[4];

//=============================================================================

void reset_dma(void)
{
	memset(dmaS, 0, sizeof(dmaS));
	memset(dmaD, 0, sizeof(dmaD));
	memset(dmaC, 0, sizeof(dmaC));
	memset(dmaM, 0, sizeof(dmaM));
}

//=============================================================================

void dmaStoreB(_u8 cr, _u8 data)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Store: %s = %02X", crName[0][cr >> 0], data);
#endif
}

void dmaStoreW(_u8 cr, _u16 data)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Store: %s = %04X", crName[1][cr >> 1], data);
#endif

	switch(cr)
	{
	case 0: dmaC[0] = data; memcpy(ram + dmaD[0], ram + dmaS[0], dmaC[0]); break;	
	case 1: dmaC[1] = data; memcpy(ram + dmaD[1], ram + dmaS[1], dmaC[1]); break;	
	case 2: dmaC[2] = data; memcpy(ram + dmaD[2], ram + dmaS[2], dmaC[2]); break;	
	case 3: dmaC[3] = data; memcpy(ram + dmaD[3], ram + dmaS[3], dmaC[3]); break;	
	}
}

void dmaStoreL(_u8 cr, _u32 data)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Store: %s = %08X", crName[2][cr >> 2], data);
#endif

	switch(cr)
	{
	case 0: dmaS[0] = data; break;	
	case 1: dmaS[1] = data; break;	
	case 2: dmaS[2] = data; break;	
	case 3: dmaS[3] = data; break;	

	case 4: dmaD[0] = data; break;	
	case 5: dmaD[1] = data; break;	
	case 6: dmaD[2] = data; break;	
	case 7: dmaD[3] = data; break;	
	}
}

//=============================================================================

_u8 dmaLoadB(_u8 cr)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Load: %s (%02X)", crName[0][cr >> 0], 0);
#endif
	return 0;
}

_u16 dmaLoadW(_u8 cr)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Load: %s (%04X)", crName[1][cr >> 1], 0);
#endif
	return 0;
}

_u32 dmaLoadL(_u8 cr)
{
#ifdef NEOPOP_DEBUG
	if (filter_dma)
		system_debug_message("dma: Load: %s (%08X)", crName[2][cr >> 2], 0);
#endif
	return 0;
}

//=============================================================================
