//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "state.h"
#include "TLCS900h_registers.h"
#include "interrupt.h"
#include "bios.h"
#include "dma.h"

//=============================================================================

void state_restore(char* filename)
{
	NEOPOPSTATE	state;
	int i,j;

	if (system_io_state_read(filename, (_u8*)&state, sizeof(NEOPOPSTATE)))
	{
		//Verify correct state id
		if (state.valid_state_id != STATE_VALID_ID)
		{
			system_message("State is from a different version of NeoPop. Ignoring.");
			return;
		}

		//Verify correct rom...
		if (memcmp(rom_header, &state.header, sizeof(RomHeader)) != 0)
		{
			system_message("This state is from a different rom, Ignoring.");
			return;
		}

		//Apply state description
		reset();

		//TLCS-900h Registers
		pc = state.pc;
		sr = state.sr;				changedSP();
		f_dash = state.f_dash;
		halted = state.halted;

		for (i = 0; i < 4; i++)
		{
			gpr[i] = state.gpr[i];
			for (j = 0; j < 4; j++)
				gprBank[i][j] = state.gprBank[i][j];
		}

		//Timers
		timer_hint = state.timer_hint;

		for (i = 0; i < 4; i++)	//Up-counters
			timer[i] = state.timer[i];

		timer_clock0 = state.timer_clock0;
		timer_clock1 = state.timer_clock1;
		timer_clock2 = state.timer_clock2;
		timer_clock3 = state.timer_clock3;

		//Z80 Registers
		memcpy(&Z80_regs, &state.Z80_regs, sizeof(Z80));

		//Sound Chips
		memcpy(&leftChip, &state.leftChip, sizeof(SoundChip));
		memcpy(&rightChip, &state.rightChip, sizeof(SoundChip));

		//DMA
		for (i = 0; i < 4; i++)
		{
			dmaS[i] = state.dmaS[i];
			dmaD[i] = state.dmaD[i];
			dmaC[i] = state.dmaC[i];
			dmaM[i] = state.dmaM[i];
		}

		//Memory
		memcpy(ram, &state.ram, 1 + RAM_END - RAM_START);

#ifdef NEOPOP_DEBUG
		system_debug_message("Restoring State ...");
		system_debug_refresh();
#endif
	}

}

//=============================================================================

void state_store(char* filename)
{
	NEOPOPSTATE	state;
	int i,j;

	//Build a state description
	state.valid_state_id = STATE_VALID_ID;
	memcpy(&state.header, rom_header, sizeof(RomHeader));

	//TLCS-900h Registers
	state.pc = pc;
	state.sr = sr;
	state.f_dash = f_dash;
	state.halted = halted;

	for (i = 0; i < 4; i++)
	{
		state.gpr[i] = gpr[i];
		for (j = 0; j < 4; j++)
			state.gprBank[i][j] = gprBank[i][j];
	}

	//Z80 Registers
	memcpy(&state.Z80_regs, &Z80_regs, sizeof(Z80));

	//Sound Chips
	memcpy(&state.leftChip, &leftChip, sizeof(SoundChip));
	memcpy(&state.rightChip, &rightChip, sizeof(SoundChip));

	//Memory
	memcpy(&state.ram, ram, 1 + RAM_END - RAM_START);

	//Timers
	state.timer_hint = timer_hint;

	for (i = 0; i < 4; i++)	//Up-counters
		state.timer[i] = timer[i];

	state.timer_clock0 = timer_clock0;
	state.timer_clock1 = timer_clock1;
	state.timer_clock2 = timer_clock2;
	state.timer_clock3 = timer_clock3;

	//DMA
	for (i = 0; i < 4; i++)
	{
		state.dmaS[i] = dmaS[i];
		state.dmaD[i] = dmaD[i];
		state.dmaC[i] = dmaC[i];
		state.dmaM[i] = dmaM[i];
	}

#ifdef NEOPOP_DEBUG
	system_debug_message("Saving State ...");
#endif

	system_io_state_write(filename, (_u8*)&state, sizeof(NEOPOPSTATE));
}

//=============================================================================
