//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#ifndef __INTERRUPT__
#define __INTERRUPT__
//=============================================================================

void interrupt(_u8 index);

#define TIMER_HINT_RATE		515		//CPU Ticks between horizontal interrupts

#define TIMER_T1_RATE		8 * 16		//384khz ticks
#define TIMER_T4_RATE		32 * 16
#define TIMER_T16_RATE		128 * 16
#define TIMER_T256_RATE		2048 * 16

void reset_timers(void);

//Pass how many cpu ticks have been taken
void updateTimers(_u8 cputicks);

//H-INT Timer
extern _u32 timer_hint;
extern _u8 timer[4];	//Up-counters
extern _u32 timer_clock0, timer_clock1, timer_clock2, timer_clock3;

//=============================================================================
#endif




