/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *  Copyright (C) 2002 Paul Kuliniewicz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../common/config.h"
#include "../common/args.h"

static char BaseDirectory[2048];

static void BaseDirInit(void)
{
 #ifdef UNIX
 char *ol;
 char TempArray[2048];

 ol=getenv("HOME");
 BaseDirectory[0]=0;
 if(ol)
 {
  strncpy(BaseDirectory,ol,2047);
  BaseDirectory[2047]=0;
  strcat(BaseDirectory,"/.fceultra");
  FCEUI_SetBaseDirectory(BaseDirectory);
 }

 mkdir(BaseDirectory,S_IRWXU);
 sprintf(TempArray,"%s/fcs",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/snaps",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/gameinfo",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/sav",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/cheats",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 #else
 #endif
}
/* PK: added joystick-related stuff */
extern int joy[4];
extern int joyAMap[4][2];
extern int joyBMap[4][4];
#define CONFIGITEMS 7
static CFGSTRUCT fceuconfig[CONFIGITEMS]={
        {"xres",&_xres,sizeof(_xres)},
        {"yres",&_yres,sizeof(_yres)},
        {"bpp",&_bpp,sizeof(_bpp)},
        {"fullscreen",&_fullscreen,sizeof(_fullscreen)},
	{"joy",joy,sizeof(joy)},
	{"joyamap",joyAMap,sizeof(joyAMap)},
	{"joybmap",joyBMap,sizeof(joyBMap)},
};


#define GetConFN(x) sprintf(x,"%s"PSS"fceusdl.cfg",BaseDirectory);

static void LoadConfig(void)
{
 char tmp[2048];

 GetConFN(tmp);
 LoadFCEUConfig(tmp,fceuconfig,CONFIGITEMS);
}

static void SaveConfig(void)
{
 char tmp[2048];

 GetConFN(tmp);
 SaveFCEUConfig(tmp,fceuconfig,CONFIGITEMS);
}


/* PK: added joyx args */
static const char UsageString[]="
Options:\n\
-xres	x	Set horizontal resolution to x for full screen mode.\n\
-yres	x	Set vertical resolution to x for full screen mode.\n\
-bpp	x	Set bits per pixel to x for full screen mode.\n\
-fullscreen x	Select full screen mode if x is non zero.\n\
-sline	x	Set lirst scanline to draw to x.\n\
-eline	x	Set last scanline to draw to x.\n\
-joyx	y	Use joystick y as virtual joystick x.\n\
-gg		Enable Game Genie emulation.\n\
-pal		Enable PAL emulation.\n\
";

static int ParseArgs(int argc, char *argv[])
{
 if(argc<=1)
 {
  printf("Usage is as follows:\n%s <options> filename\n",argv[0]);
  puts(UsageString);
  return(0);
 }

 if(argc>2)
 {
  static int docheckie[2];
  static ARGPSTRUCT FCEUArgs[12]=
  {
   {"-gg",&docheckie[1],0,0},
   {"-pal",&docheckie[0],0,0},
   {"-xres",0,&_xres,0},
   {"-yres",0,&_yres,0},
   {"-bpp",0,&_bpp,0},
   {"-fullscreen",0,&_fullscreen,0},   
   {"-sline",0,&_sline,0},
   {"-eline",0,&_eline,0},
   {"-joy1",0,&joy[0],0},
   {"-joy2",0,&joy[1],0},
   {"-joy3",0,&joy[2],0},
   {"-joy4",0,&joy[3],0},
  };
  memset(docheckie,0,sizeof(docheckie));
  ParseArguments(argc-2, &argv[1], FCEUArgs, 12);
  if(docheckie[0])
   FCEUI_SetVidSystem(1);
  if(docheckie[1])
   FCEUI_SetGameGenie(1);

 }
 return(1);
}
