// Vampire Savior: The Lord of Vampire

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x400000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x400000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;

  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//==========================================
//Vampire Savior: The Lord of Vampire (Euro)
//==========================================


static struct BurnRomInfo VsavRomDesc[]=
{

  {"vm3ex.03d",0x80000,0xfa586edf, 0x10},
  {"vm3ex.04d",0x80000,0xeb912f2b, 0x10},

  {"vm3e.03d" ,0x80000,0xf5962a8c, 0x10},
  {"vm3e.04d" ,0x80000,0x21b40ea2, 0x10},
  {"vm3.05a"  ,0x80000,0x4118e00f, 0x10},
  {"vm3.06a"  ,0x80000,0x2f4fd3a9, 0x10},
  {"vm3.07b"  ,0x80000,0xcbda91b8, 0x10},
  {"vm3.08a"  ,0x80000,0x6ca47259, 0x10},
  {"vm3.09b"  ,0x80000,0xf4a339e3, 0x10},
  {"vm3.10b"  ,0x80000,0xfffbb5b8, 0x10},

  {"vm3.13"  ,0x400000,0xfd8a11eb,    1},
  {"vm3.15"  ,0x400000,0xdd1e7d4e,    1},
  {"vm3.17"  ,0x400000,0x6b89445e,    1},
  {"vm3.19"  ,0x400000,0x3830fdc7,    1},
  {"vm3.14"  ,0x400000,0xc1a28e6c,    1},
  {"vm3.16"  ,0x400000,0x194a7304,    1},
  {"vm3.18"  ,0x400000,0xdf9a9f47,    1},
  {"vm3.20"  ,0x400000,0xc22fc3d9,    1},

  {"vm3.01"  ,0x020000,0xf778769b,    2},
  {"vm3.02"  ,0x020000,0xcc09faa1,    2},

  {"vm3.11"  ,0x400000,0xe80e956e,    2},
  {"vm3.12"  ,0x400000,0x9cd71557,    2},
};

STD_ROM_PICK(Vsav) STD_ROM_FN(Vsav)

struct BurnDriver BurnDrvCpsVsav=
{
  {"vsav" ,"Vampire Savior: The Lord of Vampire (Euro 970519)","","Capcom","CPS2","1997",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VsavRomInfo, VsavRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================================
//Vampire Savior: The Lord of Vampire (Japan)
//===========================================


static struct BurnRomInfo VsavjRomDesc[]=
{

  {"vm3jx.03d",0x80000,0xa9ab54df, 0x10},
  {"vm3jx.04d",0x80000,0x20c4aa2d, 0x10},

  {"vm3j.03d" ,0x80000,0x2a2e74a4, 0x10},
  {"vm3j.04d" ,0x80000,0x1c2427bc, 0x10},
  {"vm3j.05a" ,0x80000,0x95ce88d5, 0x10},
  {"vm3j.06b" ,0x80000,0x2c4297e0, 0x10},
  {"vm3j.07b" ,0x80000,0xa38aaae7, 0x10},
  {"vm3j.08a" ,0x80000,0x5773e5c9, 0x10},
  {"vm3j.09b" ,0x80000,0xd064f8b9, 0x10},
  {"vm3j.10b" ,0x80000,0x434518e9, 0x10},

  {"vm3.13"  ,0x400000,0xfd8a11eb,    1},
  {"vm3.15"  ,0x400000,0xdd1e7d4e,    1},
  {"vm3.17"  ,0x400000,0x6b89445e,    1},
  {"vm3.19"  ,0x400000,0x3830fdc7,    1},
  {"vm3.14"  ,0x400000,0xc1a28e6c,    1},
  {"vm3.16"  ,0x400000,0x194a7304,    1},
  {"vm3.18"  ,0x400000,0xdf9a9f47,    1},
  {"vm3.20"  ,0x400000,0xc22fc3d9,    1},

  {"vm3.01"  ,0x020000,0xf778769b,    2},
  {"vm3.02"  ,0x020000,0xcc09faa1,    2},

  {"vm3.11"  ,0x400000,0xe80e956e,    2},
  {"vm3.12"  ,0x400000,0x9cd71557,    2},
};

STD_ROM_PICK(Vsavj) STD_ROM_FN(Vsavj)

struct BurnDriver BurnDrvCpsVsavj=
{
  {"vsavj" ,"Vampire Savior: The Lord of Vampire (Japan 970519)","","Capcom","CPS2","1997","vsav", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VsavjRomInfo, VsavjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=========================================
//Vampire Savior: The Lord of Vampire (USA)
//=========================================


static struct BurnRomInfo VsavuRomDesc[]=
{

  {"vm3ux.03d",0x80000,0xfb135627, 0x10},
  {"vm3ux.04d",0x80000,0xcf02f61d, 0x10},

  {"vm3u.03d" ,0x80000,0x1f295274, 0x10},
  {"vm3u.04d" ,0x80000,0xc46adf81, 0x10},
  {"vm3.05a"  ,0x80000,0x4118e00f, 0x10},
  {"vm3.06a"  ,0x80000,0x2f4fd3a9, 0x10},
  {"vm3.07b"  ,0x80000,0xcbda91b8, 0x10},
  {"vm3.08a"  ,0x80000,0x6ca47259, 0x10},
  {"vm3.09b"  ,0x80000,0xf4a339e3, 0x10},
  {"vm3.10b"  ,0x80000,0xfffbb5b8, 0x10},

  {"vm3.13"  ,0x400000,0xfd8a11eb,    1},
  {"vm3.15"  ,0x400000,0xdd1e7d4e,    1},
  {"vm3.17"  ,0x400000,0x6b89445e,    1},
  {"vm3.19"  ,0x400000,0x3830fdc7,    1},
  {"vm3.14"  ,0x400000,0xc1a28e6c,    1},
  {"vm3.16"  ,0x400000,0x194a7304,    1},
  {"vm3.18"  ,0x400000,0xdf9a9f47,    1},
  {"vm3.20"  ,0x400000,0xc22fc3d9,    1},

  {"vm3.01"  ,0x020000,0xf778769b,    2},
  {"vm3.02"  ,0x020000,0xcc09faa1,    2},

  {"vm3.11"  ,0x400000,0xe80e956e,    2},
  {"vm3.12"  ,0x400000,0x9cd71557,    2},
};

STD_ROM_PICK(Vsavu) STD_ROM_FN(Vsavu)

struct BurnDriver BurnDrvCpsVsavu=
{
  {"vsavu" ,"Vampire Savior: The Lord of Vampire (US 970519)","","Capcom","CPS2","1997","vsav", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VsavuRomInfo, VsavuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================================
//Vampire Savior: The Lord of Vampire (Asia)
//===========================================


static struct BurnRomInfo VsavaRomDesc[]=
{

  {"vm3ax.03d",0x80000,0x3aea7d92, 0x10},
  {"vm3ax.04d",0x80000,0xb5697f3a, 0x10},

  {"vm3a.03d" ,0x80000,0x44c1198f, 0x10},
  {"vm3a.04d" ,0x80000,0x2218b781, 0x10},
  {"vm3.05a"  ,0x80000,0x4118e00f, 0x10},
  {"vm3.06a"  ,0x80000,0x2f4fd3a9, 0x10},
  {"vm3.07b"  ,0x80000,0xcbda91b8, 0x10},
  {"vm3.08a"  ,0x80000,0x6ca47259, 0x10},
  {"vm3.09b"  ,0x80000,0xf4a339e3, 0x10},
  {"vm3.10b"  ,0x80000,0xfffbb5b8, 0x10},

  {"vm3.13"  ,0x400000,0xfd8a11eb,    1},
  {"vm3.15"  ,0x400000,0xdd1e7d4e,    1},
  {"vm3.17"  ,0x400000,0x6b89445e,    1},
  {"vm3.19"  ,0x400000,0x3830fdc7,    1},
  {"vm3.14"  ,0x400000,0xc1a28e6c,    1},
  {"vm3.16"  ,0x400000,0x194a7304,    1},
  {"vm3.18"  ,0x400000,0xdf9a9f47,    1},
  {"vm3.20"  ,0x400000,0xc22fc3d9,    1},

  {"vm3.01"  ,0x020000,0xf778769b,    2},
  {"vm3.02"  ,0x020000,0xcc09faa1,    2},

  {"vm3.11"  ,0x400000,0xe80e956e,    2},
  {"vm3.12"  ,0x400000,0x9cd71557,    2},
};

STD_ROM_PICK(Vsava) STD_ROM_FN(Vsava)

struct BurnDriver BurnDrvCpsVsava=
{
  {"vsava" ,"Vampire Savior: The Lord of Vampire (Asia 970519)","","Capcom","CPS2","1997","vsav", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VsavaRomInfo, VsavaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================================
//Vampire Savior: The Lord of Vampire (Hispanic)
//==============================================


static struct BurnRomInfo VsavhRomDesc[]=
{

  {"vm3hx.03a",0x80000,0x00000000, 0x10},
  {"vm3hx.04d",0x80000,0x00000000, 0x10},

  {"vm3h.03a" ,0x80000,0x7cc62df8, 0x10},
  {"vm3h.04d" ,0x80000,0xd716f3b5, 0x10},
  {"vm3.05a"  ,0x80000,0x4118e00f, 0x10},
  {"vm3.06a"  ,0x80000,0x2f4fd3a9, 0x10},
  {"vm3.07b"  ,0x80000,0xcbda91b8, 0x10},
  {"vm3.08a"  ,0x80000,0x6ca47259, 0x10},
  {"vm3.09b"  ,0x80000,0xf4a339e3, 0x10},
  {"vm3.10b"  ,0x80000,0xfffbb5b8, 0x10},

  {"vm3.13"  ,0x400000,0xfd8a11eb,    1},
  {"vm3.15"  ,0x400000,0xdd1e7d4e,    1},
  {"vm3.17"  ,0x400000,0x6b89445e,    1},
  {"vm3.19"  ,0x400000,0x3830fdc7,    1},
  {"vm3.14"  ,0x400000,0xc1a28e6c,    1},
  {"vm3.16"  ,0x400000,0x194a7304,    1},
  {"vm3.18"  ,0x400000,0xdf9a9f47,    1},
  {"vm3.20"  ,0x400000,0xc22fc3d9,    1},

  {"vm3.01"  ,0x020000,0xf778769b,    2},
  {"vm3.02"  ,0x020000,0xcc09faa1,    2},

  {"vm3.11"  ,0x400000,0xe80e956e,    2},
  {"vm3.12"  ,0x400000,0x9cd71557,    2},
};

STD_ROM_PICK(Vsavh) STD_ROM_FN(Vsavh)

struct BurnDriverX BurnDrvCpsVsavh=
{
  {"vsavh" ,"Vampire Savior: The Lord of Vampire (Hispanic 970519)","Encrypted","Capcom","CPS2","1997","vsav", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, VsavhRomInfo, VsavhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
