//Street Fighter II - The World Warrior

#include "cps.h"

static struct BurnInputInfo DrvInputList[] =
{
{"P1 Coin"       , 0, CpsInp018+0, "p1 coin"},
{"P1 Start"      , 0, CpsInp018+4, "p1 start"},
{"P1 Up"         , 0, CpsInp001+3, "p1 up"},
{"P1 Down"       , 0, CpsInp001+2, "p1 down"},
{"P1 Left"       , 0, CpsInp001+1, "p1 left"},
{"P1 Right"      , 0, CpsInp001+0, "p1 right"},
{"P1 Low Punch"  , 0, CpsInp001+4, "p1 fire 4"},
{"P1 Mid Punch"  , 0, CpsInp001+5, "p1 fire 5"},
{"P1 High Punch" , 0, CpsInp001+6, "p1 fire 6"},
{"P1 Low Kick"   , 0, CpsInp177+0, "p1 fire 1"},
{"P1 Mid Kick"   , 0, CpsInp177+1, "p1 fire 2"},
{"P1 High Kick"  , 0, CpsInp177+2, "p1 fire 3"},

{"P2 Coin"       , 0, CpsInp018+1, "p2 coin"},
{"P2 Start"      , 0, CpsInp018+5, "p2 start"},
{"P2 Up"         , 0, CpsInp000+3, "p2 up"},
{"P2 Down"       , 0, CpsInp000+2, "p2 down"},
{"P2 Left"       , 0, CpsInp000+1, "p2 left"},
{"P2 Right"      , 0, CpsInp000+0, "p2 right"},
{"P2 Low Punch"  , 0, CpsInp000+4, "p2 fire 4"},
{"P2 Mid Punch"  , 0, CpsInp000+5, "p2 fire 5"},
{"P2 High Punch" , 0, CpsInp000+6, "p2 fire 6"},
{"P2 Low Kick"   , 0, CpsInp177+4, "p2 fire 1"},
{"P2 Mid Kick"   , 0, CpsInp177+5, "p2 fire 2"},
{"P2 High Kick"  , 0, CpsInp177+6, "p2 fire 3"},

{"Diagnostic"    , 0, CpsInp018+6, "diag"},
{"Reset"         , 0, &CpsReset  , "reset"},
{"Service"       , 0, CpsInp018+2, "service"},
{"Dip A"         , 2, &Cpi01A    , "dip"},
{"Dip B"         , 2, &Cpi01C    , "dip"},
{"Dip C"         , 2, &Cpi01E    , "dip"},
};


// Treble Winner - Input for sf2ue
static struct BurnInputInfo Sf2ueInputList[]=
{
{"P1 Coin"       , 0, CpsInp018+0, "p1 coin"},
{"P1 Start"      , 0, CpsInp018+4, "p1 start"},
{"P1 Up"         , 0, CpsInp001+3, "p1 up"},
{"P1 Down"       , 0, CpsInp001+2, "p1 down"},
{"P1 Left"       , 0, CpsInp001+1, "p1 left"},
{"P1 Right"      , 0, CpsInp001+0, "p1 right"},
{"P1 Low Punch"  , 0, CpsInp001+4, "p1 fire 4"},
{"P1 Mid Punch"  , 0, CpsInp001+5, "p1 fire 5"},
{"P1 High Punch" , 0, CpsInp001+6, "p1 fire 6"},
{"P1 Low Kick"   , 0, CpsInp1fd+0, "p1 fire 1"},
{"P1 Mid Kick"   , 0, CpsInp1fd+1, "p1 fire 2"},
{"P1 High Kick"  , 0, CpsInp1fd+2, "p1 fire 3"},

{"P2 Coin"       , 0, CpsInp018+1, "p2 coin"},
{"P2 Start"      , 0, CpsInp018+5, "p2 start"},
{"P2 Up"         , 0, CpsInp000+3, "p2 up"},
{"P2 Down"       , 0, CpsInp000+2, "p2 down"},
{"P2 Left"       , 0, CpsInp000+1, "p2 left"},
{"P2 Right"      , 0, CpsInp000+0, "p2 right"},
{"P2 Low Punch"  , 0, CpsInp000+4, "p2 fire 4"},
{"P2 Mid Punch"  , 0, CpsInp000+5, "p2 fire 5"},
{"P2 High Punch" , 0, CpsInp000+6, "p2 fire 6"},
{"P2 Low Kick"   , 0, CpsInp1fd+4, "p2 fire 1"},
{"P2 Mid Kick"   , 0, CpsInp1fd+5, "p2 fire 2"},
{"P2 High Kick"  , 0, CpsInp1fd+6, "p2 fire 3"},

{"Diagnostic"    , 0, CpsInp018+6, "diag"},
{"Reset"         , 0, &CpsReset  , "reset"},
{"Dip A"         , 2, &Cpi01A    , "dip"},
{"Dip B"         , 2, &Cpi01C    , "dip"},
{"Dip C"         , 2, &Cpi01E    , "dip"},
};

STDINPUTINFO(Sf2ue);

STDINPUTINFO(Drv);

static struct BurnDIPInfo sf2DIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                },
	{0x1c, 0xff, 0xff, 0x00, NULL                },
	{0x1d, 0xff, 0xff, 0x00, NULL                },

	// Dip A
	{0   , 0xfe, 0   , 8   , "A Side"                 },
	{0x1b, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x07, 0x01, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x07, 0x02, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x07, 0x03, "1 Coin 4 Credits"       },
	{0x1b, 0x01, 0x07, 0x04, "1 Coin 6 Credits"       },

	{0   , 0xfe, 0   , 8   , "B Side"                 },
	{0x1b, 0x01, 0x38, 0x38, "4 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x30, "3 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x28, "2 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x38, 0x08, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x38, 0x10, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x38, 0x18, "1 Coin 4 Credits"       },
	{0x1b, 0x01, 0x38, 0x20, "1 Coin 6 Credits"       },

	{0   , 0xfe, 0   , 2   , "Continue Coin"          },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//	{0x1b, 0x01, 0x80, 0x00, "Off"                    },
//	{0x1b, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Game Level"             },
	{0x1c, 0x01, 0x07, 0x00, "0"                 },
	{0x1c, 0x01, 0x07, 0x01, "1"                 },
	{0x1c, 0x01, 0x07, 0x02, "2"                 },
	{0x1c, 0x01, 0x07, 0x03, "3"              },
	{0x1c, 0x01, 0x07, 0x04, "4"            },
	{0x1c, 0x01, 0x07, 0x05, "5"            },
	{0x1c, 0x01, 0x07, 0x06, "6"            },
	{0x1c, 0x01, 0x07, 0x07, "7"         },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//	{0x1c, 0x01, 0x08, 0x00, "Off"                    },
//	{0x1c, 0x01, 0x08, 0x08, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x10, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x10, 0x10, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//	{0x1c, 0x01, 0x20, 0x00, "Off"                    },
//	{0x1c, 0x01, 0x20, 0x20, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x40, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x40, 0x40, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x80, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
//	{0   , 0xfe, 0   , 4   , "Unknown"                },
//      {0x1d, 0x01, 0x03, 0x00, "1"                      },
//      {0x1d, 0x01, 0x03, 0x01, "2"                      },
//      {0x1d, 0x01, 0x03, 0x02, "3"                      },
//      {0x1d, 0x01, 0x03, 0x03, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
        {0x1d, 0x01, 0x04, 0x00, "Off"                    },
        {0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Stop"                   },
        {0x1d, 0x01, 0x08, 0x00, "Off"                    },
        {0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
        {0x1d, 0x01, 0x10, 0x00, "Off"                    },
        {0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
        {0x1d, 0x01, 0x20, 0x00, "Off"                    },
        {0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Continue"               },
        {0x1d, 0x01, 0x40, 0x00, "Off"                    },
        {0x1d, 0x01, 0x40, 0x40, "On"                     },
};

STDDIPINFO(sf2);

static struct BurnDIPInfo sf2jDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                },
	{0x1c, 0xff, 0xff, 0x00, NULL                },
	{0x1d, 0xff, 0xff, 0x00, NULL                },

	// Dip A
	{0   , 0xfe, 0   , 8   , "A Side"                 },
	{0x1b, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       },
	{0x1b, 0x01, 0x07, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x07, 0x01, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x07, 0x02, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x07, 0x03, "1 Coin 4 Credits"       },
	{0x1b, 0x01, 0x07, 0x04, "1 Coin 6 Credits"       },

	{0   , 0xfe, 0   , 8   , "B Side"                 },
	{0x1b, 0x01, 0x38, 0x38, "4 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x30, "3 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x28, "2 Coins 1 Credit"       },
	{0x1b, 0x01, 0x38, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x38, 0x08, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x38, 0x10, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x38, 0x18, "1 Coin 4 Credits"       },
	{0x1b, 0x01, 0x38, 0x20, "1 Coin 6 Credits"       },

	{0   , 0xfe, 0   , 2   , "Continue Coin"          },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//	{0x1b, 0x01, 0x80, 0x00, "Off"                    },
//	{0x1b, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Game Level"             },
	{0x1c, 0x01, 0x07, 0x00, "0"                 },
	{0x1c, 0x01, 0x07, 0x01, "1"                 },
	{0x1c, 0x01, 0x07, 0x02, "2"                 },
	{0x1c, 0x01, 0x07, 0x03, "3"              },
	{0x1c, 0x01, 0x07, 0x04, "4"            },
	{0x1c, 0x01, 0x07, 0x05, "5"            },
	{0x1c, 0x01, 0x07, 0x06, "6"            },
	{0x1c, 0x01, 0x07, 0x07, "7"         },

	{0   , 0xfe, 0   , 2   , "2 Players Game"         },
	{0x1c, 0x01, 0x08, 0x00, "1 Credit/No Continue"   },
	{0x1c, 0x01, 0x08, 0x08, "2 Credits/Winner Continue"},

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x10, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x10, 0x10, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//	{0x1c, 0x01, 0x20, 0x00, "Off"                    },
//	{0x1c, 0x01, 0x20, 0x20, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x40, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x40, 0x40, "On"                     },

//	{0   , 0xfe, 0   , 2   , "Unknown"                },
//      {0x1c, 0x01, 0x80, 0x00, "Off"                    },
//      {0x1c, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
//	{0   , 0xfe, 0   , 4   , "Unknown"                },
//      {0x1d, 0x01, 0x03, 0x00, "1"                      },
//      {0x1d, 0x01, 0x03, 0x01, "2"                      },
//      {0x1d, 0x01, 0x03, 0x02, "3"                      },
//      {0x1d, 0x01, 0x03, 0x03, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
        {0x1d, 0x01, 0x04, 0x00, "Off"                    },
        {0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Stop"                   },
        {0x1d, 0x01, 0x08, 0x00, "Off"                    },
        {0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
        {0x1d, 0x01, 0x10, 0x00, "Off"                    },
        {0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
        {0x1d, 0x01, 0x20, 0x00, "Off"                    },
        {0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Continue"               },
        {0x1d, 0x01, 0x40, 0x00, "Off"                    },
        {0x1d, 0x01, 0x40, 0x40, "On"                     },
};

STDDIPINFO(sf2j);


static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsAdLen=0; nCpsZRomLen=0; nCpsGfxLen=0; nCpsRomLen=0;
  Cps=0; Sf2jc=0;
  return 0;
}

//============================================
//Street Fighter II - The World Warrior Init12
//============================================

static int Drv12Init()
{
  int nRet=0; int i=0;
  Cps=1; Sf2jc=1;
  nCpsRomLen =  0x100000;
  nCpsGfxLen =3*0x200000;
  nCpsZRomLen=  0x010000;
  nCpsAdLen  =2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  for (i=0;i<8;i++)
  {
    int a; a=(i>>1)*0x40000; a+=(i&1); a^=1;
    nRet=BurnLoadRom(CpsRom+a,i,2); if (nRet!=0) return 1;
  }

  // Load up and interleve each set of 4 roms to make the 16x16 tiles
  for (i=0;i<3;i++) CpsLoadTiles(CpsGfx+i*0x200000,8+i*4);

  nCpsGfxScroll[1]=nCpsGfxScroll[2]=nCpsGfxScroll[3]=0x400000; // Offset to Scroll tiles

  nCpsLcReg=0x6c; // Layer control register is at 0x6c
  CpsLayEn[1]=0x02;
  CpsLayEn[2]=0x04;
  CpsLayEn[3]=0x08; // Layer enable is different

  // Start of Board ID improvments by KEV. 0x60,0x0402
  CpsBID[0]=0x60;
  CpsBID[1]=0x04;
  CpsBID[2]=0x02;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,20,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,21,1);
  nRet=BurnLoadRom(CpsAd+0x20000,22,1);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//============================================
//Street Fighter II - The World Warrior Init13
//============================================

static int Drv13Init()
{
  int nRet=0; int i=0;
  Cps=1;
  nCpsRomLen =  0x100000;
  nCpsGfxLen =3*0x200000;
  nCpsZRomLen=  0x010000;
  nCpsAdLen  =2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  for (i=0;i<8;i++)
  {
    int a; a=(i>>1)*0x40000; a+=(i&1); a^=1;
    nRet=BurnLoadRom(CpsRom+a,i,2); if (nRet!=0) return 1;
  }

  // Load up and interleve each set of 4 roms to make the 16x16 tiles
  for (i=0;i<3;i++) CpsLoadTiles(CpsGfx+i*0x200000,8+i*4);

  nCpsGfxScroll[1]=nCpsGfxScroll[2]=nCpsGfxScroll[3]=0x400000; // Offset to Scroll tiles

  nCpsLcReg=0x62; // Layer control register is at 0x62
  CpsLayEn[1]=0x20;
  CpsLayEn[2]=0x04;
  CpsLayEn[3]=0x02; // Layer enable is different

  // Start of Board ID improvments by KEV. 0x6e,0x0403
  CpsBID[0]=0x6e;
  CpsBID[1]=0x04;
  CpsBID[2]=0x03;

  MaskAddr[0]=0x64;
  MaskAddr[1]=0x66;
  MaskAddr[2]=0x68;
  MaskAddr[3]=0x6a;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,20,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,21,1);
  nRet=BurnLoadRom(CpsAd+0x20000,22,1);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//============================================
//Street Fighter II - The World Warrior Init14
//============================================

static int Drv14Init()
{
  int nRet=0; int i=0;
  Cps=1;
  nCpsRomLen =  0x100000;
  nCpsGfxLen =3*0x200000;
  nCpsZRomLen=  0x010000;
  nCpsAdLen  =2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  for (i=0;i<8;i++)
  {
    int a; a=(i>>1)*0x40000; a+=(i&1); a^=1;
    nRet=BurnLoadRom(CpsRom+a,i,2); if (nRet!=0) return 1;
  }

  // Load up and interleve each set of 4 roms to make the 16x16 tiles
  for (i=0;i<3;i++) CpsLoadTiles(CpsGfx+i*0x200000,8+i*4);

  nCpsGfxScroll[1]=nCpsGfxScroll[2]=nCpsGfxScroll[3]=0x400000; // Offset to Scroll tiles

  nCpsLcReg=0x52; // Layer control register is at 0x52
  CpsLayEn[1]=0x08;
  CpsLayEn[2]=0x30;
  CpsLayEn[3]=0x30; // Layer enable is different

  // Start of Board ID improvments by KEV. 0x5E,0x0404
  CpsBID[0]=0x5E;
  CpsBID[1]=0x04;
  CpsBID[2]=0x04;

  MaskAddr[0]=0x54;
  MaskAddr[1]=0x56;
  MaskAddr[2]=0x58;
  MaskAddr[3]=0x5a;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,20,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,21,1);
  nRet=BurnLoadRom(CpsAd+0x20000,22,1);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//============================================
//Street Fighter II - The World Warrior Init17
//============================================

static int Drv17Init()
{
  int nRet=0; int i=0;
  Cps=1;
  nCpsRomLen =  0x100000;
  nCpsGfxLen =3*0x200000;
  nCpsZRomLen=  0x010000;
  nCpsAdLen  =2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  for (i=0;i<8;i++)
  {
    int a; a=(i>>1)*0x40000; a+=(i&1); a^=1;
    nRet=BurnLoadRom(CpsRom+a,i,2); if (nRet!=0) return 1;
  }

  // Load up and interleve each set of 4 roms to make the 16x16 tiles
  for (i=0;i<3;i++) CpsLoadTiles(CpsGfx+i*0x200000,8+i*4);

  nCpsGfxScroll[1]=nCpsGfxScroll[2]=nCpsGfxScroll[3]=0x400000; // Offset to Scroll tiles

  nCpsLcReg=0x54; // Layer control register is at 0x54
  CpsLayEn[1]=0x08;
  CpsLayEn[2]=0x10;
  CpsLayEn[3]=0x02; // Layer enable is different

  // Start of Board ID improvments by KEV. 0x48,0x0407
  CpsBID[0]=0x48;
  CpsBID[1]=0x04;
  CpsBID[2]=0x07;

  MaskAddr[0]=0x52;
  MaskAddr[1]=0x50;
  MaskAddr[2]=0x4e;
  MaskAddr[3]=0x4c;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,20,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,21,1);
  nRet=BurnLoadRom(CpsAd+0x20000,22,1);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//============================================
//Street Fighter II - The World Warrior Init18
//============================================

static int Drv18Init()
{
  int nRet=0; int i=0;
  Cps=1;
  nCpsRomLen =  0x100000;
  nCpsGfxLen =3*0x200000;
  nCpsZRomLen=  0x010000;
  nCpsAdLen  =2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  for (i=0;i<8;i++)
  {
    int a; a=(i>>1)*0x40000; a+=(i&1); a^=1;
    nRet=BurnLoadRom(CpsRom+a,i,2); if (nRet!=0) return 1;
  }

  // Load up and interleve each set of 4 roms to make the 16x16 tiles
  for (i=0;i<3;i++) CpsLoadTiles(CpsGfx+i*0x200000,8+i*4);

  nCpsGfxScroll[1]=nCpsGfxScroll[2]=nCpsGfxScroll[3]=0x400000; // Offset to Scroll tiles

  nCpsLcReg=0xdc; // Layer control register is at 0xdc
  CpsLayEn[1]=0x10;
  CpsLayEn[2]=0x0a;
  CpsLayEn[3]=0x0a; // Layer enable is different

  // Start of Board ID improvments by KEV. 0xd0,0x0408
  CpsBID[0]=0xd0;
  CpsBID[1]=0x04;
  CpsBID[2]=0x08;

  MaskAddr[0]=0xda;
  MaskAddr[1]=0xd8;
  MaskAddr[2]=0xd6;
  MaskAddr[3]=0xd4;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,20,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,21,1);
  nRet=BurnLoadRom(CpsAd+0x20000,22,1);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//=============================================
//Street Fighter II - The World Warrior (World)
//=============================================


static struct BurnRomInfo Sf2RomDesc[]=
{
// 0
  {"sf2_30a.bin",0x20000,0x57bd7051, 0x10}, //  0 68000 code
  {"sf2e_37b.rom",0x20000,0x62691cdd, 0x10},
  {"sf2_31a.bin",0x20000,0xa673143d, 0x10},
  {"sf2_38a.bin",0x20000,0x4c2ccef7, 0x10},
  {"sf2_28a.bin" ,0x20000,0x4009955e, 0x10},
  {"sf2_35a.bin" ,0x20000,0x8c1f3994, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2) STD_ROM_FN(Sf2)

struct BurnDriver BurnDrvCpsSf2=
{
  {"sf2","Street Fighter II - The World Warrior (World 910214)","","Capcom","CPS1","1991",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2RomInfo,Sf2RomName,DrvInputInfo, sf2DIPInfo,
  Drv17Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==================================================
//Street Fighter II - The World Warrior (USA Rev. A)
//==================================================


static struct BurnRomInfo Sf2uaRomDesc[]=
{
// 0
  {"sf2u.30a",0x20000,0x08beb861, 0x10}, //  0 68000 code
  {"sf2u.37a",0x20000,0xb7638d69, 0x10},
  {"sf2u.31a",0x20000,0x0d5394e0, 0x10},
  {"sf2u.38a",0x20000,0x42d6a79e, 0x10},
  {"sf2u.28a" ,0x20000,0x387a175c, 0x10},
  {"sf2u.35a" ,0x20000,0xa1a5adcc, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2ua) STD_ROM_FN(Sf2ua)

struct BurnDriver BurnDrvCpsSf2ua=
{
  {"sf2ua","Street Fighter II - The World Warrior (US 910206)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2uaRomInfo,Sf2uaRomName,DrvInputInfo, sf2DIPInfo,
  Drv17Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==================================================
//Street Fighter II - The World Warrior (USA Rev. B)
//==================================================


static struct BurnRomInfo Sf2ubRomDesc[]=
{
// 0
  {"sf2_30a.bin",0x20000,0x57bd7051, 0x10}, //  0 68000 code
  {"sf2u.37b",0x20000,0x4a54d479, 0x10},
  {"sf2_31a.bin",0x20000,0xa673143d, 0x10},
  {"sf2_38a.bin",0x20000,0x4c2ccef7, 0x10},
  {"sf2_28a.bin" ,0x20000,0x4009955e, 0x10},
  {"sf2_35a.bin" ,0x20000,0x8c1f3994, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2ub) STD_ROM_FN(Sf2ub)

struct BurnDriver BurnDrvCpsSf2ub=
{
  {"sf2ub","Street Fighter II - The World Warrior (US 910214)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2ubRomInfo,Sf2ubRomName,DrvInputInfo, sf2DIPInfo,
  Drv17Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==================================================
//Street Fighter II - The World Warrior (USA Rev. E)
//==================================================


static struct BurnRomInfo Sf2ueRomDesc[]=
{
// 0
  {"sf2u.30e",0x20000,0xf37cd088, 0x10}, //  0 68000 code
  {"sf2u.37e",0x20000,0x6c61a513, 0x10},
  {"sf2u.31e",0x20000,0x7c4771b4, 0x10},
  {"sf2u.38e",0x20000,0xa4bd0cd9, 0x10},
  {"sf2u.28e",0x20000,0xe3b95625, 0x10},
  {"sf2u.35e",0x20000,0x3648769a, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2ue) STD_ROM_FN(Sf2ue)

struct BurnDriver BurnDrvCpsSf2ue=
{
  {"sf2ue","Street Fighter II - The World Warrior (US 910228)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2ueRomInfo,Sf2ueRomName,Sf2ueInputInfo, sf2DIPInfo,
  Drv18Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==================================================
//Street Fighter II - The World Warrior (USA Rev. I)
//==================================================


static struct BurnRomInfo Sf2uiRomDesc[]=
{
// 0
  {"sf2u.30i",0x20000,0xfe39ee33, 0x10}, //  0 68000 code
  {"sf2u.37i",0x20000,0x9df707dd, 0x10},
  {"sf2u.31i",0x20000,0x69a0a301, 0x10},
  {"sf2u.38i",0x20000,0x4cb46daf, 0x10},
  {"sf2u.28i" ,0x20000,0x1580be4c, 0x10},
  {"sf2u.35i" ,0x20000,0x1468d185, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2ui) STD_ROM_FN(Sf2ui)

struct BurnDriver BurnDrvCpsSf2ui=
{
  {"sf2ui","Street Fighter II - The World Warrior (US 910522)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2uiRomInfo,Sf2uiRomName,DrvInputInfo, sf2DIPInfo,
  Drv14Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=============================================
//Street Fighter II - The World Warrior (Japan)
//=============================================


static struct BurnRomInfo Sf2jRomDesc[]=
{
// 0
  {"sf2j30.bin",0x20000,0x79022b31, 0x10}, //  0 68000 code
  {"sf2j37.bin",0x20000,0x516776ec, 0x10},
  {"sf2j31.bin",0x20000,0xfe15cb39, 0x10},
  {"sf2j38.bin",0x20000,0x38614d70, 0x10},
  {"sf2j28.bin" ,0x20000,0xd283187a, 0x10},
  {"sf2j35.bin" ,0x20000,0xd28158e4, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2j) STD_ROM_FN(Sf2j)

struct BurnDriver BurnDrvCpsSf2j=
{
  {"sf2j","Street Fighter II - The World Warrior (Japan 911210)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2jRomInfo,Sf2jRomName,DrvInputInfo, sf2jDIPInfo,
  Drv13Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================================================
//Street Fighter II - The World Warrior (Japan Rev. A)
//====================================================


static struct BurnRomInfo Sf2jaRomDesc[]=
{
// 0
  {"sf2_30a.bin",0x20000,0x57bd7051, 0x10}, //  0 68000 code
  {"sf2j_37a.bin",0x20000,0x1e1f6844, 0x10},
  {"sf2_31a.bin",0x20000,0xa673143d, 0x10},
  {"sf2_38a.bin",0x20000,0x4c2ccef7, 0x10},
  {"sf2_28a.bin" ,0x20000,0x4009955e, 0x10},
  {"sf2_35a.bin" ,0x20000,0x8c1f3994, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2ja) STD_ROM_FN(Sf2ja)

struct BurnDriver BurnDrvCpsSf2ja=
{
  {"sf2ja","Street Fighter II - The World Warrior (Japan 910214)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2jaRomInfo,Sf2jaRomName,DrvInputInfo, sf2jDIPInfo,
  Drv17Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================================================
//Street Fighter II - The World Warrior (Japan Rev. C)
//====================================================


static struct BurnRomInfo Sf2jcRomDesc[]=
{
// 0
  {"sf2_30c.bin",0x20000,0x8add35ec, 0x10}, //  0 68000 code
  {"sf2j_37c.bin",0x20000,0x0d74a256, 0x10},
  {"sf2_31c.bin",0x20000,0xc4fff4a9, 0x10},
  {"sf2_38c.bin",0x20000,0x8210fc0e, 0x10},
  {"sf2_28c.bin" ,0x20000,0x6eddd5e8, 0x10},
  {"sf2_35c.bin" ,0x20000,0x6bcb404c, 0x10},
  {"sf2_29a.bin" ,0x20000,0xbb4af315, 0x10},
  {"sf2_36a.bin" ,0x20000,0xc02a13eb, 0x10},

// 8
  {"sf2_06.bin",0x80000,0x22c9cc8e,    1},
  {"sf2_08.bin",0x80000,0x57213be8,    1},
  {"sf2_05.bin",0x80000,0xba529b4f,    1},
  {"sf2_07.bin",0x80000,0x4b1b33a8,    1},
  {"sf2_15.bin",0x80000,0x2c7e2229,    1},
  {"sf2_17.bin",0x80000,0xb5548f17,    1},
  {"sf2_14.bin",0x80000,0x14b84312,    1},
  {"sf2_16.bin",0x80000,0x5e9cd89a,    1},
  {"sf2_25.bin",0x80000,0x994bfa58,    1},
  {"sf2_27.bin",0x80000,0x3e66ad9d,    1},
  {"sf2_24.bin",0x80000,0xc1befaa8,    1},
  {"sf2_26.bin",0x80000,0x0627c831,    1},

// 20
// z80 program
  {"sf2_09.bin"  ,0x10000,0xa4823a1b,    2},
// adpcm samples
  {"sf2_18.bin"  ,0x20000,0x7f162009,    2},
  {"sf2_19.bin"  ,0x20000,0xbeade53f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Sf2jc) STD_ROM_FN(Sf2jc)

struct BurnDriver BurnDrvCpsSf2jc=
{
  {"sf2jc","Street Fighter II - The World Warrior (Japan 910306)","","Capcom","CPS1","1991","sf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,Sf2jcRomInfo,Sf2jcRomName,DrvInputInfo, sf2jDIPInfo,
  Drv12Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
