#include "cps.h"

/*==============================================
 Gigawing
==============================================*/

static struct BurnInputInfo DrvInputList[] =
{
	{"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
	{"P1 Start"      , 0, CpsInp020+0, "p1 start"},
	{"P1 Up"         , 0, CpsInp001+3, "p1 up"},
	{"P1 Down"       , 0, CpsInp001+2, "p1 down"},
	{"P1 Left"       , 0, CpsInp001+1, "p1 left"},
	{"P1 Right"      , 0, CpsInp001+0, "p1 right"},
	{"P1 Shot"       , 0, CpsInp001+4, "p1 fire 1"},
	{"P1 Bomb"       , 0, CpsInp001+5, "p1 fire 2"},

	{"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
	{"P2 Start"      , 0, CpsInp020+1, "p2 start"},
	{"P2 Up"         , 0, CpsInp000+3, "p2 up"},
	{"P2 Down"       , 0, CpsInp000+2, "p2 down"},
	{"P2 Left"       , 0, CpsInp000+1, "p2 left"},
	{"P2 Right"      , 0, CpsInp000+0, "p2 right"},
	{"P2 Shot"       , 0, CpsInp000+4, "p2 fire 1"},
	{"P2 Bomb"       , 0, CpsInp000+5, "p2 fire 2"},

	{"Reset"         , 0, &CpsReset  , "reset"},
	{"Diagnostic"    , 0, CpsInp021+1, "diag"},
	{"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
	int i = 0;
	unsigned char* pqs = NULL;

	Cps = 2;
	nCpsRomLen = 3 * 0x080000;
	nCpsCodeLen = 2 * 0x080000;
	nCpsGfxLen = 4 * 0x400000;
	nCpsZRomLen = 1 * 0x020000;
	nCpsQSamLen = 2 * 0x400000;
	if (CpsInit()) {
		return 1;
	}

	for (i = 0; i < 3; i++) {
		if (BurnLoadRom(CpsRom + 0x080000 * i, 2 + i, 1)) {
			return 1;
		}
	}

	memcpy(CpsCode, CpsRom, nCpsCodeLen);
	for (i = 0; i < 2; i++) {
		if (BurnXorRom(CpsCode + 0x080000 * i, 0 + i, 1)) {
			return 1;
		}
	}

	Cps2LoadTiles(CpsGfx, 5);

	BurnLoadRom(CpsZRom, 9, 1);

	pqs = (unsigned char*)CpsQSam;
	BurnLoadRom(pqs           , 10, 1);
	BurnLoadRom(pqs + 0x400000, 11, 1);
	BurnByteswap(pqs, nCpsQSamLen);

	if (CpsRunInit()) {
		return 1;
	}

	return 0;
}

static int DrvExit()
{
	CpsRunExit();
	CpsExit();
	
	nCpsQSamLen=0;
	nCpsZRomLen=0;
	nCpsGfxLen=0;
	nCpsCodeLen=0;
	nCpsRomLen=0;
	Cps=0;

	return 0;
}


/*==========
 Gigawing (USA)
==========*/

static struct BurnRomInfo GigawingRomDesc[]=
{
	{"ggwux.03" ,0x80000,0x2f18fd96, 0x10},
	{"ggwux.04" ,0x80000,0x7be82def, 0x10},

	{"ggwu.03"  ,0x80000,0xac725eb2, 0x10},
	{"ggwu.04"  ,0x80000,0x392f4118, 0x10},
	{"ggwu.05"  ,0x80000,0x3239d642, 0x10},

	{"ggw.13"  ,0x400000,0x105530a4,    1},
	{"ggw.15"  ,0x400000,0x9e774ab9,    1},
	{"ggw.17"  ,0x400000,0x466e0ba4,    1},
	{"ggw.19"  ,0x400000,0x840c8dea,    1},

	{"ggw.01"  ,0x020000,0x4c6351d5,    2},

	{"ggw.11"  ,0x400000,0xe172acf5,    2},
	{"ggw.12"  ,0x400000,0x4bee4e8f,    2},
};

STD_ROM_PICK(Gigawing) STD_ROM_FN(Gigawing)

struct BurnDriver BurnDrvCpsGigawing=
{
	{"gigawing" ,"Giga Wing (US 990222)","","Capcom","CPS2","1999",NULL, NULL},
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS2,
	NULL, GigawingRomInfo, GigawingRomName, DrvInputInfo, NULL,
	DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
	&CpsRecalcPal,384,224,4,3
};

/*==========
 Gigawing (Japan)
==========*/

static struct BurnRomInfo GwingjRomDesc[]=
{
	{"ggwjx.03a",0x80000,0xdeb45124, 0x10},
	{"ggwjx.04a",0x80000,0x8b981d04, 0x10},

	{"ggwj.03a" ,0x80000,0xfdd23b91, 0x10},
	{"ggwj.04a" ,0x80000,0x8c6e093c, 0x10},
	{"ggwj.05a" ,0x80000,0x43811454, 0x10},

	{"ggw.13"  ,0x400000,0x105530a4,    1},
	{"ggw.15"  ,0x400000,0x9e774ab9,    1},
	{"ggw.17"  ,0x400000,0x466e0ba4,    1},
	{"ggw.19"  ,0x400000,0x840c8dea,    1},

	{"ggw.01"  ,0x020000,0x4c6351d5,    2},

	{"ggw.11"  ,0x400000,0xe172acf5,    2},
	{"ggw.12"  ,0x400000,0x4bee4e8f,    2},
};

STD_ROM_PICK(Gwingj) STD_ROM_FN(Gwingj)

struct BurnDriver BurnDrvCpsGwingj=
{
	{"gwingj" ,"Giga Wing (Japan 990223)","","Capcom","CPS2","1999","gigawing", NULL},
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS2,
	NULL, GwingjRomInfo, GwingjRomName, DrvInputInfo, NULL,
	DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
	&CpsRecalcPal,384,224,4,3
};

