#include "cps.h"

/*================================================================
 D&D: Shadow Over Mystara
================================================================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
  {"P1 Start"      , 0, CpsInp020+0, "p1 start"},
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"      , 0, CpsInp001+0, "p1 right"},
  {"P1 Attack"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Jump"       , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Select"     , 0, CpsInp001+6, "p1 fire 3"},
  {"P1 Use"        , 0, CpsInp001+7, "p1 fire 4"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
  {"P2 Start"      , 0, CpsInp020+1, "p2 start"},
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"      , 0, CpsInp000+0, "p2 right"},
  {"P2 Attack"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Jump"       , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Select"     , 0, CpsInp000+6, "p2 fire 3"},
  {"P2 Use"        , 0, CpsInp000+7, "p2 fire 4"},

  {"P3 Coin"       , 0, CpsInp020+6, "p3 coin"},
  {"P3 Start"      , 0, CpsInp020+2, "p3 start"},
  {"P3 Up"         , 0, CpsInp011+3, "p3 up"},
  {"P3 Down"       , 0, CpsInp011+2, "p3 down"},
  {"P3 Left"       , 0, CpsInp011+1, "p3 left"},
  {"P3 Right"      , 0, CpsInp011+0, "p3 right"},
  {"P3 Attack"     , 0, CpsInp011+4, "p3 fire 1"},
  {"P3 Jump"       , 0, CpsInp011+5, "p3 fire 2"},
  {"P3 Select"     , 0, CpsInp011+6, "p3 fire 3"},
  {"P3 Use"        , 0, CpsInp011+7, "p3 fire 4"},

  {"P4 Coin"       , 0, CpsInp020+7, "p4 coin"},
  {"P4 Start"      , 0, CpsInp020+3, "p4 start"},
  {"P4 Up"         , 0, CpsInp010+3, "p4 up"},
  {"P4 Down"       , 0, CpsInp010+2, "p4 down"},
  {"P4 Left"       , 0, CpsInp010+1, "p4 left"},
  {"P4 Right"      , 0, CpsInp010+0, "p4 right"},
  {"P4 Attack"     , 0, CpsInp010+4, "p4 fire 1"},
  {"P4 Jump"       , 0, CpsInp010+5, "p4 fire 2"},
  {"P4 Select"     , 0, CpsInp010+6, "p4 fire 3"},
  {"P4 Use"        , 0, CpsInp010+7, "p4 fire 4"},

  {"Reset"         , 0, &CpsReset  , "reset"},
  {"Diagnostic"    , 0, CpsInp021+1, "diag"},
  {"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=   0x1800000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);
  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*==============================
 D&D: Shadow Over Mystara (Euro)
==============================*/


static struct BurnRomInfo DdsomRomDesc[]=
{
  {"dd2ex.03b",0x80000,0xe4924c80, 0x10}, // xor decryption tables
  {"dd2ex.04d",0x80000,0x13c8b16f, 0x10},

  {"dd2e.03b" ,0x80000,0xcd2deb66, 0x10}, // 68000 code (encrypted)
  {"dd2e.04d" ,0x80000,0xbfee43cc, 0x10},
  {"dd2e.05b" ,0x80000,0x049ab19d, 0x10},
  {"dd2e.06d" ,0x80000,0x3994fb8b, 0x10},
  {"dd2e.07"  ,0x80000,0xbb777a02, 0x10},
  {"dd2e.08"  ,0x80000,0x30970890, 0x10},
  {"dd2e.09"  ,0x80000,0x99e2194d, 0x10},
  {"dd2e.10"  ,0x80000,0xe198805e, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsom) STD_ROM_FN(Ddsom)

struct BurnDriver BurnDrvCpsDdsom=
{
  {"ddsom" ,"Dungeons & Dragons: Shadow over Mystara (Euro 960209)","","Capcom","CPS2","1996",NULL, NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdsomRomInfo, DdsomRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*================================
 D&D: Shadow Over Mystara (USA r1)
================================*/


static struct BurnRomInfo Ddsomur1RomDesc[]=
{
  {"dd2ux.03d",0x80000,0x5cecbdb3, 0x10}, // xor decryption tables
  {"dd2ux.04d",0x80000,0x1307a77d, 0x10},

  {"dd2u.03d" ,0x80000,0x0f700d84, 0x10}, // 68000 code (encrypted)
  {"dd2u.04d" ,0x80000,0xb99eb254, 0x10},
  {"dd2.05d"  ,0x80000,0xb23061f3, 0x10},
  {"dd2.06d"  ,0x80000,0x8bf1d8ce, 0x10},
  {"dd2.07"   ,0x80000,0x909a0b8b, 0x10},
  {"dd2.08"   ,0x80000,0xe53c4d01, 0x10},
  {"dd2.09"   ,0x80000,0x5f86279f, 0x10},
  {"dd2.10"   ,0x80000,0xad954c26, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsomur1) STD_ROM_FN(Ddsomur1)

struct BurnDriver BurnDrvCpsDdsomur1=
{
  {"ddsomur1" ,"Dungeons & Dragons: Shadow over Mystara (US 960209)","","Capcom","CPS2","1996","ddsom", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, Ddsomur1RomInfo, Ddsomur1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==================================
 D&D: Shadow Over Mystara (Japan r1)
==================================*/


static struct BurnRomInfo Ddsomjr1RomDesc[]=
{
  {"dd2jx.03b",0x80000,0xa63488bb, 0x10}, // xor decryption tables
  {"dd2jx.04b",0x80000,0xe3ff7985, 0x10},

  {"dd2j.03b" ,0x80000,0x965d74e5, 0x10}, // 68000 code (encrypted)
  {"dd2j.04b" ,0x80000,0x958eb8f3, 0x10},
  {"dd2.05b"  ,0x80000,0xd38571ca, 0x10},
  {"dd2.06b"  ,0x80000,0x6d5a3bbb, 0x10},
  {"dd2.07"   ,0x80000,0x909a0b8b, 0x10},
  {"dd2.08"   ,0x80000,0xe53c4d01, 0x10},
  {"dd2.09"   ,0x80000,0x5f86279f, 0x10},
  {"dd2.10"   ,0x80000,0xad954c26, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsomjr1) STD_ROM_FN(Ddsomjr1)

struct BurnDriver BurnDrvCpsDdsomjr1=
{
  {"ddsomjr1" ,"Dungeons & Dragons: Shadow over Mystara (Japan 960206)","","Capcom","CPS2","1996","ddsom", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, Ddsomjr1RomInfo, Ddsomjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================================
 D&D: Shadow Over Mystara (Japan) Encrypted
==========================================*/


static struct BurnRomInfo DdsomjRomDesc[]=
{
  {"dd2jx.03g",0x80000,0x00000000, 0x10}, // xor decryption tables
  {"dd2jx.04g",0x80000,0x00000000, 0x10},

  {"dd2j.03g" ,0x80000,0xe6c8c985, 0x10}, // 68000 code (encrypted)
  {"dd2j.04g" ,0x80000,0x8386c0bd, 0x10},
  {"dd2.05g"  ,0x80000,0x5eb1991c, 0x10},
  {"dd2.06g"  ,0x80000,0xc26b5e55, 0x10},
  {"dd2.07"   ,0x80000,0x909a0b8b, 0x10},
  {"dd2.08"   ,0x80000,0xe53c4d01, 0x10},
  {"dd2.09"   ,0x80000,0x5f86279f, 0x10},
  {"dd2.10"   ,0x80000,0xad954c26, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsomj) STD_ROM_FN(Ddsomj)

struct BurnDriverX BurnDrvCpsDdsomj=
{
  {"ddsomj" ,"Dungeons & Dragons: Shadow over Mystara (Japan 960619)","Encrypted","Capcom","CPS2","1996","ddsom", NULL},
  0,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdsomjRomInfo, DdsomjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*========================================
 D&D: Shadow Over Mystara (Asia) Encrypted
========================================*/


static struct BurnRomInfo DdsomaRomDesc[]=
{
  {"dd2ax.03g",0x80000,0x00000000, 0x10}, // xor decryption tables
  {"dd2ax.04g",0x80000,0x00000000, 0x10},

  {"dd2a.03g" ,0x80000,0x0b4fec22, 0x10}, // 68000 code (encrypted)
  {"dd2a.04g" ,0x80000,0x055b7019, 0x10},
  {"dd2.05g"  ,0x80000,0x5eb1991c, 0x10},
  {"dd2.06g"  ,0x80000,0xc26b5e55, 0x10},
  {"dd2.07"   ,0x80000,0x909a0b8b, 0x10},
  {"dd2.08"   ,0x80000,0xe53c4d01, 0x10},
  {"dd2.09"   ,0x80000,0x5f86279f, 0x10},
  {"dd2.10"   ,0x80000,0xad954c26, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsoma) STD_ROM_FN(Ddsoma)

struct BurnDriverX BurnDrvCpsDdsoma=
{
  {"ddsoma" ,"Dungeons & Dragons: Shadow over Mystara (Asia 960619)","Encrypted","Capcom","CPS2","1996","ddsom", NULL},
  0,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdsomaRomInfo, DdsomaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=============================
 D&D: Shadow Over Mystara (USA)
=============================*/


static struct BurnRomInfo DdsomuRomDesc[]=
{
  {"dd2ux.03g",0x80000,0x124ad51a, 0x10}, // xor decryption tables
  {"dd2ux.04g",0x80000,0x5401c248, 0x10},

  {"dd2u.03g" ,0x80000,0xfb089b39, 0x10}, // 68000 code (encrypted)
  {"dd2u.04g" ,0x80000,0xcd432b73, 0x10},
  {"dd2.05g"  ,0x80000,0x5eb1991c, 0x10},
  {"dd2.06g"  ,0x80000,0xc26b5e55, 0x10},
  {"dd2.07"   ,0x80000,0x909a0b8b, 0x10},
  {"dd2.08"   ,0x80000,0xe53c4d01, 0x10},
  {"dd2.09"   ,0x80000,0x5f86279f, 0x10},
  {"dd2.10"   ,0x80000,0xad954c26, 0x10},

  // graphics:
  {"dd2.13"  ,0x400000,0xa46b4e6e,    1}, // 8
  {"dd2.15"  ,0x400000,0xd5fc50fc,    1},
  {"dd2.17"  ,0x400000,0x837c0867,    1},
  {"dd2.19"  ,0x400000,0xbb0ec21c,    1},
  {"dd2.14"  ,0x200000,0x6d824ce2,0x1000000},
  {"dd2.16"  ,0x200000,0x79682ae5,    1},
  {"dd2.18"  ,0x200000,0xacddd149,    1},
  {"dd2.20"  ,0x200000,0x117fb0c0,    1},

  // sound - z80 roms
  {"dd2.01"  ,0x020000,0x99d657e5,    2}, // 16
  {"dd2.02"  ,0x020000,0x117a3824,    2},
  // sound - samples
  {"dd2.11"  ,0x200000,0x98d0c325,    2},
  {"dd2.12"  ,0x200000,0x5ea2e7fa,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddsomu) STD_ROM_FN(Ddsomu)

struct BurnDriver BurnDrvCpsDdsomu=
{
  {"ddsomu" ,"Dungeons & Dragons: Shadow over Mystara (US 960619)",NULL,"Capcom","CPS2","1996","ddsom", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdsomuRomInfo, DdsomuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
