#include "cps.h"

/*===========================================
 Alien vs. Predator
===========================================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"  },
  {"P1 Start"      , 0, CpsInp020+0, "p1 start" },
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"    },
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"  },
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"  },
  {"P1 Right"      , 0, CpsInp001+0, "p1 right" },
  {"P1 Shot"       , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Attack"     , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Jump"       , 0, CpsInp001+6, "p1 fire 3"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"  },
  {"P2 Start"      , 0, CpsInp020+1, "p2 start" },
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"    },
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"  },
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"  },
  {"P2 Right"      , 0, CpsInp000+0, "p2 right" },
  {"P2 Shot"       , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Attack"     , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Jump"       , 0, CpsInp000+6, "p2 fire 3"},

  {"P3 Coin"       , 0, CpsInp020+6, "p3 coin"  },
  {"P3 Start"      , 0, CpsInp020+2, "p3 start" },
  {"P3 Up"         , 0, CpsInp011+3, "p3 up"    },
  {"P3 Down"       , 0, CpsInp011+2, "p3 down"  },
  {"P3 Left"       , 0, CpsInp011+1, "p3 left"  },
  {"P3 Right"      , 0, CpsInp011+0, "p3 right" },
  {"P3 Shot"       , 0, CpsInp011+4, "p3 fire 1"},
  {"P3 Attack"     , 0, CpsInp011+5, "p3 fire 2"},
  {"P3 Jump"       , 0, CpsInp011+6, "p3 fire 3"},

  {"Reset"         , 0, &CpsReset  , "reset"    },
  {"Diagnostic"    , 0, CpsInp021+1, "diag"     },
  {"Service"       , 0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  4*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=   0x1000000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<4;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<2;i++)
  { nRet=BurnXorRom(CpsCode+0x080000*i,0+i,1); if (nRet!=0) return 1; }

  nRet=Cps2LoadTiles(CpsGfx          ,6);
  nRet=Cps2LoadTiles(CpsGfx+0x0800000,10);

  nRet=BurnLoadRom(CpsZRom,14,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,15,1);
  nRet=BurnLoadRom(pqs+0x200000,16,1);
  BurnByteswap(pqs,nCpsQSamLen);




  nRet=CpsRunInit(); if (nRet!=0) return 1;
  return 0;
}

static int DrvExit()
{
  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*=========================
 Alien vs. Predator (Euro)
=========================*/


static struct BurnRomInfo AvspRomDesc[]=
{
  {"avpex.03d",0x80000,0x73dd740e, 0x10},
  {"avpex.04d",0x80000,0x185f8c43, 0x10},

  {"avpe.03d" ,0x80000,0x774334a9, 0x10},
  {"avpe.04d" ,0x80000,0x7fa83769, 0x10},
  {"avp.05d"  ,0x80000,0xfbfb5d7a, 0x10},
  {"avp.06"   ,0x80000,0x190b817f, 0x10},

  {"avp.13"  ,0x200000,0x8f8b5ae4,    1},
  {"avp.15"  ,0x200000,0xb00280df,    1},
  {"avp.17"  ,0x200000,0x94403195,    1},
  {"avp.19"  ,0x200000,0xe1981245,    1},
  {"avp.14"  ,0x200000,0xebba093e,    1},
  {"avp.16"  ,0x200000,0xfb228297,    1},
  {"avp.18"  ,0x200000,0x34fb7232,    1},
  {"avp.20"  ,0x200000,0xf90baa21,    1},

  {"avp.01"  ,0x020000,0x2d3b4220,    2},
  {"avp.11"  ,0x200000,0x83499817,    2},
  {"avp.12"  ,0x200000,0xf4110d49,    2},
};

STD_ROM_PICK(Avsp) STD_ROM_FN(Avsp)

struct BurnDriver BurnDrvCpsAvsp=
{
  {"avsp" ,"Alien vs. Predator (Euro 940520)","","Capcom","CPS2","1994",NULL, NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, AvspRomInfo, AvspRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================
 Alien vs. Predator (Japan)
==========================*/


static struct BurnRomInfo AvspjRomDesc[]=
{
  {"avpjx.03d",0x80000,0x94095fb0, 0x10},
  {"avpjx.04d",0x80000,0xa56b00ae, 0x10},

  {"avpj.03d" ,0x80000,0x49799119, 0x10},
  {"avpj.04d" ,0x80000,0x8cd2bba8, 0x10},
  {"avp.05d"  ,0x80000,0xfbfb5d7a, 0x10},
  {"avp.06"   ,0x80000,0x190b817f, 0x10},

  {"avp.13"  ,0x200000,0x8f8b5ae4,    1},
  {"avp.15"  ,0x200000,0xb00280df,    1},
  {"avp.17"  ,0x200000,0x94403195,    1},
  {"avp.19"  ,0x200000,0xe1981245,    1},
  {"avp.14"  ,0x200000,0xebba093e,    1},
  {"avp.16"  ,0x200000,0xfb228297,    1},
  {"avp.18"  ,0x200000,0x34fb7232,    1},
  {"avp.20"  ,0x200000,0xf90baa21,    1},

  {"avp.01"  ,0x020000,0x2d3b4220,    2},
  {"avp.11"  ,0x200000,0x83499817,    2},
  {"avp.12"  ,0x200000,0xf4110d49,    2},
};

STD_ROM_PICK(Avspj) STD_ROM_FN(Avspj)

struct BurnDriver BurnDrvCpsAvspj=
{
  {"avspj" ,"Alien vs. Predator (Japan 940520)","","Capcom","CPS2","1994","avsp", NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, AvspjRomInfo, AvspjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*========================
 Alien vs. Predator (USA)
========================*/


static struct BurnRomInfo AvspuRomDesc[]=
{
// 0
  {"avpux.03d",0x80000,0xd5b01046, 0x10}, // xor decryption table
  {"avpux.04d",0x80000,0x94bd7603, 0x10}, // xor decryption table

  {"avpu.03d" ,0x80000,0x42757950, 0x10}, // 68000 code (encrypted)
  {"avpu.04d" ,0x80000,0x5abcdee6, 0x10},
  {"avp.05d"  ,0x80000,0xfbfb5d7a, 0x10},
  {"avp.06"   ,0x80000,0x190b817f, 0x10},

  {"avp.13"  ,0x200000,0x8f8b5ae4,    1}, // 10
  {"avp.15"  ,0x200000,0xb00280df,    1},
  {"avp.17"  ,0x200000,0x94403195,    1},
  {"avp.19"  ,0x200000,0xe1981245,    1},
  {"avp.14"  ,0x200000,0xebba093e,    1},
  {"avp.16"  ,0x200000,0xfb228297,    1},
  {"avp.18"  ,0x200000,0x34fb7232,    1},
  {"avp.20"  ,0x200000,0xf90baa21,    1},

  {"avp.01"  ,0x020000,0x2d3b4220,    2}, // 18
  {"avp.11"  ,0x200000,0x83499817,    2},
  {"avp.12"  ,0x200000,0xf4110d49,    2},
};

STD_ROM_PICK(Avspu) STD_ROM_FN(Avspu)

struct BurnDriver BurnDrvCpsAvspu=
{
  {"avspu" ,"Alien vs. Predator (US 940520)","","Capcom","CPS2","1994","avsp", NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, AvspuRomInfo, AvspuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};


/*===================================
 Alien Vs. Predator (Asia) Encrypted
===================================*/


static struct BurnRomInfo AvspaRomDesc[]=
{
// 0
  {"avpax.03d",0x80000,0x00000000, 0x10}, // xor decryption table
  {"avpax.04d",0x80000,0x00000000, 0x10}, // xor decryption table

  {"avpa.03d" ,0x80000,0x6c1c1858, 0x10}, // 68000 code (encrypted)
  {"avpa.04d" ,0x80000,0x94f50b0c, 0x10},
  {"avp.05d"  ,0x80000,0xfbfb5d7a, 0x10},
  {"avp.06"   ,0x80000,0x190b817f, 0x10},

  {"avp.13"  ,0x200000,0x8f8b5ae4,    1}, // 10
  {"avp.15"  ,0x200000,0xb00280df,    1},
  {"avp.17"  ,0x200000,0x94403195,    1},
  {"avp.19"  ,0x200000,0xe1981245,    1},
  {"avp.14"  ,0x200000,0xebba093e,    1},
  {"avp.16"  ,0x200000,0xfb228297,    1},
  {"avp.18"  ,0x200000,0x34fb7232,    1},
  {"avp.20"  ,0x200000,0xf90baa21,    1},

  {"avp.01"  ,0x020000,0x2d3b4220,    2}, // 18
  {"avp.11"  ,0x200000,0x83499817,    2},
  {"avp.12"  ,0x200000,0xf4110d49,    2},
};

STD_ROM_PICK(Avspa) STD_ROM_FN(Avspa)

struct BurnDriverX BurnDrvCpsAvspa=
{
  {"avspa" ,"Alien vs. Predator (Asia 940520)","Encrypted","Capcom","CPS2","1994","avsp", NULL},
  0,3,HARDWARE_CAPCOM_CPS2,
  NULL, AvspaRomInfo, AvspaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
