#include "cps.h"

/*=========================================
 Armored Warriors
=========================================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"  },
  {"P1 Start"      , 0, CpsInp020+0, "p1 start" },
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"    },
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"  },
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"  },
  {"P1 Right"      , 0, CpsInp001+0, "p1 right" },
  {"P1 Attack"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Jump"       , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Shot"       , 0, CpsInp001+6, "p1 fire 3"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"  },
  {"P2 Start"      , 0, CpsInp020+1, "p2 start" },
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"    },
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"  },
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"  },
  {"P2 Right"      , 0, CpsInp000+0, "p2 right" },
  {"P2 Attack"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Jump"       , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Shot"       , 0, CpsInp000+6, "p2 fire 3"},

  {"P3 Coin"       , 0, CpsInp020+6, "p3 coin"  },
  {"P3 Start"      , 0, CpsInp020+2, "p3 start" },
  {"P3 Up"         , 0, CpsInp011+3, "p3 up"    },
  {"P3 Down"       , 0, CpsInp011+2, "p3 down"  },
  {"P3 Left"       , 0, CpsInp011+1, "p3 left"  },
  {"P3 Right"      , 0, CpsInp011+0, "p3 right" },
  {"P3 Attack"     , 0, CpsInp011+4, "p3 fire 1"},
  {"P3 Jump"       , 0, CpsInp011+5, "p3 fire 2"},
  {"P3 Shot"       , 0, CpsInp011+6, "p3 fire 3"},

  {"Reset"         , 0, &CpsReset  , "reset"    },
  {"Diagnostic"    , 0, CpsInp021+1, "diag"     },
  {"Service"       , 0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=   0x1800000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;

  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*======================
 Armored Warriors (Euro)
======================*/


static struct BurnRomInfo ArmwarRomDesc[]=
{
  {"pwgex.03b",0x80000,0x741fc2b0, 0x10},
  {"pwgex.04b",0x80000,0x5bb96a5d, 0x10},

  {"pwge.03b" ,0x80000,0xe822e3e9, 0x10},
  {"pwge.04b" ,0x80000,0x4f89de39, 0x10},
  {"pwge.05a" ,0x80000,0x83df24e5, 0x10},
  {"pwg.06"   ,0x80000,0x87a60ce8, 0x10},
  {"pwg.07"   ,0x80000,0xf7b148df, 0x10},
  {"pwg.08"   ,0x80000,0xcc62823e, 0x10},
  {"pwg.09"   ,0x80000,0xddc85ca6, 0x10},
  {"pwg.10"   ,0x80000,0x07c4fb28, 0x10},

  {"pwg.13"  ,0x400000,0xae8fe08e,    1},
  {"pwg.15"  ,0x400000,0xdb560f58,    1},
  {"pwg.17"  ,0x400000,0xbc475b94,    1},
  {"pwg.19"  ,0x400000,0x07439ff7,    1},
  {"pwg.14"  ,0x100000,0xc3f9ba63,    1},
  {"pwg.16"  ,0x100000,0x815b0e7b,    1},
  {"pwg.18"  ,0x100000,0x0109c71b,    1},
  {"pwg.20"  ,0x100000,0xeb75ffbe,    1},

  {"pwg.01"  ,0x020000,0x18a5c0e4,    2},
  {"pwg.02"  ,0x020000,0xc9dfffa6,    2},

  {"pwg.11"  ,0x200000,0xa78f7433,    2},
  {"pwg.12"  ,0x200000,0x77438ed0,    2},
};

STD_ROM_PICK(Armwar) STD_ROM_FN(Armwar)

struct BurnDriver BurnDrvCpsArmwar=
{
  {"armwar" ,"Armored Warriors (Euro 941011)","","Capcom","CPS2","1994",NULL, NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, ArmwarRomInfo, ArmwarRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================
 Armored Warriors (USA)
======================*/


static struct BurnRomInfo ArmwaruRomDesc[]=
{
  {"pwgux.03b",0x80000,0x5d41ddde, 0x10},
  {"pwgux.04b",0x80000,0x4d0619f3, 0x10},

  {"pwgu.03b" ,0x80000,0x8b95497a, 0x10},
  {"pwgu.04b" ,0x80000,0x29eb5661, 0x10},
  {"pwgu.05b" ,0x80000,0xa54e9e44, 0x10},
  {"pwg.06"   ,0x80000,0x87a60ce8, 0x10},
  {"pwg.07"   ,0x80000,0xf7b148df, 0x10},
  {"pwg.08"   ,0x80000,0xcc62823e, 0x10},
  {"pwg.09a"  ,0x80000,0x4c26baee, 0x10},
  {"pwg.10"   ,0x80000,0x07c4fb28, 0x10},

  {"pwg.13"  ,0x400000,0xae8fe08e,    1},
  {"pwg.15"  ,0x400000,0xdb560f58,    1},
  {"pwg.17"  ,0x400000,0xbc475b94,    1},
  {"pwg.19"  ,0x400000,0x07439ff7,    1},
  {"pwg.14"  ,0x100000,0xc3f9ba63,    1},
  {"pwg.16"  ,0x100000,0x815b0e7b,    1},
  {"pwg.18"  ,0x100000,0x0109c71b,    1},
  {"pwg.20"  ,0x100000,0xeb75ffbe,    1},

  {"pwg.01"  ,0x020000,0x18a5c0e4,    2},
  {"pwg.02"  ,0x020000,0xc9dfffa6,    2},

  {"pwg.11"  ,0x200000,0xa78f7433,    2},
  {"pwg.12"  ,0x200000,0x77438ed0,    2},
};

STD_ROM_PICK(Armwaru) STD_ROM_FN(Armwaru)

struct BurnDriver BurnDrvCpsArmwaru=
{
  {"armwaru" ,"Armored Warriors (US 941024)","","Capcom","CPS2","1994","armwar", NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, ArmwaruRomInfo, ArmwaruRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==============================
 Powered Gear: S.V.A.E. (Japan)
==============================*/


static struct BurnRomInfo PgearRomDesc[]=
{
  {"pwgjx.03a" ,0x80000,0xcf0284a9, 0x10},
  {"pwgjx.04a" ,0x80000,0x99437cf1, 0x10},

  {"pwgj.03a"  ,0x80000,0xc79c0c02, 0x10},
  {"pwgj.04a"  ,0x80000,0x167c6ed8, 0x10},
  {"pwgj.05a"  ,0x80000,0xa63fb400, 0x10},
  {"pwg.06"    ,0x80000,0x87a60ce8, 0x10},
  {"pwg.07"    ,0x80000,0xf7b148df, 0x10},
  {"pwg.08"    ,0x80000,0xcc62823e, 0x10},
  {"pwg.09a"   ,0x80000,0x4c26baee, 0x10},
  {"pwg.10"    ,0x80000,0x07c4fb28, 0x10},

  {"pwg.13"   ,0x400000,0xae8fe08e,    1},
  {"pwg.15"   ,0x400000,0xdb560f58,    1},
  {"pwg.17"   ,0x400000,0xbc475b94,    1},
  {"pwg.19"   ,0x400000,0x07439ff7,    1},
  {"pwg.14"   ,0x100000,0xc3f9ba63,    1},
  {"pwg.16"   ,0x100000,0x815b0e7b,    1},
  {"pwg.18"   ,0x100000,0x0109c71b,    1},
  {"pwg.20"   ,0x100000,0xeb75ffbe,    1},

  {"pwg.01"   ,0x020000,0x18a5c0e4,    2},
  {"pwg.02"   ,0x020000,0xc9dfffa6,    2},

  {"pwg.11"   ,0x200000,0xa78f7433,    2},
  {"pwg.12"   ,0x200000,0x77438ed0,    2},
};

STD_ROM_PICK(Pgear) STD_ROM_FN(Pgear)

struct BurnDriver BurnDrvCpsPgear=
{
  {"pgear" ,"Powered Gear: Strategic Variant Armor Equipment (Japan 941024)","","Capcom","CPS2","1994","armwar", NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, PgearRomInfo, PgearRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=================================
 Powered Gear: S.V.A.E. (Japan r1)
=================================*/


static struct BurnRomInfo Pgearr1RomDesc[]=
{
  {"pwgjx.03" ,0x80000,0xebd9e371, 0x10},
  {"pwgjx.04" ,0x80000,0xe05a4756, 0x10},

  {"pwgj.03"  ,0x80000,0xf264e74b, 0x10},
  {"pwgj.04"  ,0x80000,0x23a84983, 0x10},
  {"pwgj.05"  ,0x80000,0xbef58c62, 0x10},
  {"pwg.06"   ,0x80000,0x87a60ce8, 0x10},
  {"pwg.07"   ,0x80000,0xf7b148df, 0x10},
  {"pwg.08"   ,0x80000,0xcc62823e, 0x10},
  {"pwg.09"   ,0x80000,0xddc85ca6, 0x10},
  {"pwg.10"   ,0x80000,0x07c4fb28, 0x10},

  {"pwg.13"  ,0x400000,0xae8fe08e,    1},
  {"pwg.15"  ,0x400000,0xdb560f58,    1},
  {"pwg.17"  ,0x400000,0xbc475b94,    1},
  {"pwg.19"  ,0x400000,0x07439ff7,    1},
  {"pwg.14"  ,0x100000,0xc3f9ba63,    1},
  {"pwg.16"  ,0x100000,0x815b0e7b,    1},
  {"pwg.18"  ,0x100000,0x0109c71b,    1},
  {"pwg.20"  ,0x100000,0xeb75ffbe,    1},

  {"pwg.01"  ,0x020000,0x18a5c0e4,    2},
  {"pwg.02"  ,0x020000,0xc9dfffa6,    2},

  {"pwg.11"  ,0x200000,0xa78f7433,    2},
  {"pwg.12"  ,0x200000,0x77438ed0,    2},
};

STD_ROM_PICK(Pgearr1) STD_ROM_FN(Pgearr1)

struct BurnDriver BurnDrvCpsPgearr1=
{
  {"pgearr1" ,"Powered Gear: Strategic Variant Armor Equipment (Japan 940916)","","Capcom","CPS2","1994","armwar", NULL},
  1,3,HARDWARE_CAPCOM_CPS2,
  NULL, Pgearr1RomInfo, Pgearr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=================================
 Armored Warriors (Asia) Encrypted
=================================*/


static struct BurnRomInfo ArmwaraRomDesc[]=
{
  {"pwgax.03a" ,0x80000,0x00000000, 0x10},
  {"pwgax.04a" ,0x80000,0x00000000, 0x10},

  {"pwga.03a"  ,0x80000,0x8d474ab1, 0x10},
  {"pwga.04a"  ,0x80000,0x81b5aec7, 0x10},
  {"pwga.05a"  ,0x80000,0x2618e819, 0x10},
  {"pwg.06"    ,0x80000,0x87a60ce8, 0x10},
  {"pwg.07"    ,0x80000,0xf7b148df, 0x10},
  {"pwg.08"    ,0x80000,0xcc62823e, 0x10},
  {"pwg.09"    ,0x80000,0xddc85ca6, 0x10},
  {"pwg.10"    ,0x80000,0x07c4fb28, 0x10},

  {"pwg.13"   ,0x400000,0xae8fe08e,    1},
  {"pwg.15"   ,0x400000,0xdb560f58,    1},
  {"pwg.17"   ,0x400000,0xbc475b94,    1},
  {"pwg.19"   ,0x400000,0x07439ff7,    1},
  {"pwg.14"   ,0x100000,0xc3f9ba63,    1},
  {"pwg.16"   ,0x100000,0x815b0e7b,    1},
  {"pwg.18"   ,0x100000,0x0109c71b,    1},
  {"pwg.20"   ,0x100000,0xeb75ffbe,    1},

  {"pwg.01"   ,0x020000,0x18a5c0e4,    2},
  {"pwg.02"   ,0x020000,0xc9dfffa6,    2},

  {"pwg.11"   ,0x200000,0xa78f7433,    2},
  {"pwg.12"   ,0x200000,0x77438ed0,    2},
};

STD_ROM_PICK(Armwara) STD_ROM_FN(Armwara)

struct BurnDriverX BurnDrvCpsArmwara=
{
  {"armwara" ,"Armored Warriors (Asia 940920)","Encrypted","Capcom","CPS2","1994","armwar", NULL},
  0,3,HARDWARE_CAPCOM_CPS2,
  NULL, ArmwaraRomInfo, ArmwaraRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
