//---------------------------------------------------------------------------
// Burn - Arcade emulator library
// Copyright (c) 2001 Dave (www.finalburn.com), all rights reserved.

// This refers to all the code except where stated otherwise
// (e.g. ym2151 emulator)

// You can use, modify and redistribute this code freely as long as you
// don't do so commercially. This copyright notice must remain with the code.
// If your program uses this code, you must either distribute or link to the
// source code. If you modify or improve this code, you must distribute
// the source code improvements.

// Dave
// Homepage: www.finalburn.com
// E-mail:  dave@finalburn.com
//---------------------------------------------------------------------------

#ifdef __cplusplus
 extern "C" {
#endif

#include <time.h>
#include "cheat.h"

extern unsigned int nCurrentFrame;

inline int GetCurrentFrame() {
	return nCurrentFrame;
}

inline void SetCurrentFrame(const unsigned int n) {
	nCurrentFrame = n;
}

extern int nBurnFPS;

extern unsigned int nFramesEmulated;
extern unsigned int nFramesRendered;
extern clock_t starttime;					// system time when emulation started and after roms loaded

extern int nBurnMask;

struct BurnRomInfo { char szName[16]; unsigned int nLen; unsigned int nCrc; unsigned int nType; };
struct BurnInputInfo { char* szName; unsigned char nType; unsigned char *pVal; char* szInfo; };
struct BurnDIPInfo { int nInput; unsigned char nFlags; unsigned char nMask; unsigned char nSetting; char* szText; };

struct BurnArea { void *Data; unsigned int nLen; int nAddress; char *szName; };

extern int nBurnVer;						// Version number of the library

// burn.cpp
extern int (__cdecl *dprintf) (char *szFormat,...);
extern unsigned int nBurnDrvCount;			// Count of game drivers
extern unsigned int nBurnDrvSelect;			// Which game driver is selected

extern int nMaxPlayers;

extern unsigned char *pBurnDraw;			// Pointer to correctly sized bitmap
extern unsigned char *pSShotBuffer;			// Pointer to DtosMem (for screenshot purposes)
extern int nBurnPitch;						// Pitch between each line
extern int nBurnBpp;						// Bytes per pixel (2, 3, or 4)
extern int nBurnBitDepth;					// Bitdepth of pBurnDraw (15, 16, 24, or 32)
extern unsigned char nBurnLayer;			// Can be used externally to select which layers to show
extern unsigned char nSpriteEnable;			// Can be used externally to select which Sprites to show

int BurnLibInit();
int BurnLibExit();
extern int (*BurnExtInput) (unsigned int i);// App-defined func to get the state of each input
char *BurnDrvText(unsigned int i);
int BurnDrvGetZipName(char **pszName, unsigned int i);
int BurnDrvGetRomInfo(struct BurnRomInfo *pri, unsigned int i);
int BurnDrvGetRomName(char **pszName, unsigned int i, int nAka);
int BurnDrvGetInputInfo(struct BurnInputInfo *pii, unsigned int i);
int BurnDrvGetDIPInfo(struct BurnDIPInfo *pdi, unsigned int i);
int BurnDrvGetScreen(int *pnWidth, int *pnHeight);
int BurnDrvGetAspect(int *pnXAspect, int *pnYAspect);
int BurnDrvGetHardwareCode();
int BurnDrvGetFlags();
bool BurnDrvIsWorking();
int BurnDrvInit();
int BurnDrvExit();
int BurnDrvFrame();
int BurnDrvRedraw();
int BurnRecalcPal();
extern unsigned int (*BurnHighCol) (int r, int g, int b, int i);
int BurnAreaScan(int nAction, int *pnMin);		// &1=for reading &2=for writing &4=Volatile &8=Non-Volatile
extern int (*BurnAcb) (struct BurnArea *pba);	// Area callback

// load.cpp
// Application-defined rom loading function:
extern int (*BurnExtLoadRom)(unsigned char *Dest, int *pnWrote, int i);

// sound.cpp
extern int nBurnSoundRate;					// sample rate of sound
extern int nBurnSoundLen;					// length in samples per frame
extern short *pBurnSoundOut;				// pointer to output buffer

// Flags used with the Burndriver structure

// Flags for the flags member
#define BDF_GAME_WORKING 1
#define BDF_ROTATE_GRAPHICS_CW 2
#define BDF_ROTATE_GRAPHICS_CCW 4
#define BDF_BOARDROM 8

// Flags for the hardware member
// Format: 0xDDEEFFFF, where EE: Manufacturer, DD: Hardware platform, FFFF: Flags (used by driver)

#define HARDWARE_PUBLIC_MASK	0xFFFF0000
#define HARDWARE_PREFIX_MISC	0x00000000
#define HARDWARE_PREFIX_CAPCOM	0x01000000
#define HARDWARE_PREFIX_SEGA	0x02000000
#define HARDWARE_PREFIX_KONAMI	0x03000000
#define HARDWARE_PREFIX_TOAPLAN	0x04000000
#define HARDWARE_PREFIX_SNK		0x05000000

#define HARDWARE_MISC_MISC HARDWARE_PREFIX_MISC

#define HARDWARE_CAPCOM_CPS1 (HARDWARE_PREFIX_CAPCOM | 0x00010000)
#define HARDWARE_CAPCOM_CPS1_QSOUND (HARDWARE_PREFIX_CAPCOM | 0x00020000)
#define HARDWARE_CAPCOM_CPS1_GENERIC (HARDWARE_PREFIX_CAPCOM | 0x00030000)
#define HARDWARE_CAPCOM_CPSCHANGER (HARDWARE_PREFIX_CAPCOM | 0x00040000)
#define HARDWARE_CAPCOM_CPS2 (HARDWARE_PREFIX_CAPCOM | 0x00050000)

#define HARDWARE_SEGA_AFTERBURNER (HARDWARE_PREFIX_SEGA | 0x00010000)
#define HARDWARE_SEGA_GALAXYFORCE (HARDWARE_PREFIX_SEGA | 0x00020000)
#define HARDWARE_SEGA_SYSTEM16A (HARDWARE_PREFIX_SEGA | 0x00030000)
#define HARDWARE_SEGA_SYSTEM16B (HARDWARE_PREFIX_SEGA | 0x00040000)
#define HARDWARE_SEGA_SYSTEM18 (HARDWARE_PREFIX_SEGA | 0x00050000)
#define HARDWARE_SEGA_HANGON (HARDWARE_PREFIX_SEGA | 0x00060000)
#define HARDWARE_SEGA_SPACEHARRIER (HARDWARE_PREFIX_SEGA | 0x00070000)
#define HARDWARE_SEGA_OUTRUN (HARDWARE_PREFIX_SEGA | 0x00080000)

#define HARDWARE_KONAMI_TMNT (HARDWARE_PREFIX_KONAMI | 0x00010000)

#define HARDWARE_TOAPLAN_RAIZING (HARDWARE_PREFIX_TOAPLAN | 0x00010000)
#define HARDWARE_TOAPLAN_68K_Zx80 (HARDWARE_PREFIX_TOAPLAN | 0x00020000)
#define HARDWARE_TOAPLAN_68K_ONLY (HARDWARE_PREFIX_TOAPLAN | 0x00030000)

#define HARDWARE_SNK_NEOGEO (HARDWARE_PREFIX_SNK | 0x00010000)
#define HARDWARE_SNK_SRAM 0x0002			// SRAM protection
#define HARDWARE_SNK_SWAPP 0x0004			// swap code roms
#define HARDWARE_SNK_SWAPV 0x0008			// swap sound roms
#define HARDWARE_SNK_SWAPC 0x0010			// swap sprite roms	
#define HARDWARE_SNK_ENCRYPTED_A 0x0020		// KOF99 encryption scheme
#define HARDWARE_SNK_ENCRYPTED_B 0x0040		// KOF2000 encryption scheme
#define HARDWARE_SNK_ALTERNATE_TEXT 0x0080	// KOF2000 text layer banks

#ifdef __cplusplus
 } // End of extern "C"
#endif

