// Audio Output
#include "..\..\fba.h"
#define wav_log_test

int nAudSampleRate = 44100;			// sample rate
int nAudSegCount = 6;				// Segs in the pdsbLoop buffer
int nAudSegLen = 0;					// Seg length in samples (calculated from Rate/Fps)
unsigned char bAudOkay = 0;			// True if DSound was initted okay
unsigned char bAudPlaying = 0;		// True if the Loop buffer is playing

short *nAudNextSound = NULL;		// The next sound seg we will add to the sample loop

static unsigned int nAudSelect = 0;	// Which audio plugin is selected

extern struct AudOut AudOutDx;

static struct AudOut *pAudOut[]=
{
	&AudOutDx,
};

#define AUD_LEN (sizeof(pAudOut)/sizeof(pAudOut[0]))

int AudBlankSound()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->BlankSound();
}

// This function checks the Sound loop, and if necessary gets some more sound
int AudSoundCheck()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundCheck();
}

int AudSoundInit()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundInit();
}

int AudSoundPlay()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundPlay();
}

int AudSoundStop()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundStop();
}

int AudSoundExit()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundExit();
}

int AudSoundSetVolume()
{
	if (nAudSelect>=AUD_LEN) return 1;
	return pAudOut[nAudSelect]->SoundSetVolume();
}
