// Burner Game Control
#include "fba.h"

static char szPlay[4][4]={"p1 ", "p2 ", "p3 ", "p4 "};

#define KEY(x) { pgi->nInput = 2; pgi->nCode = (unsigned short)(x); }

// Configure the misc game controls

int GamcMisc(struct GameInp *pgi, char *szi, int nPlayer)
{

	int nJoyBase = 0;
	int nDevice = 0;

	nJoyBase = 0x4000;
	nJoyBase |= nDevice << 8;


	if (strcmp(szi, "diag") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_BACK + XINPUT_GAMEPAD_WHITE);
		return 0;
	}
	if (strcmp(szi, "reset") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_LEFT_TRIGGER + XINPUT_GAMEPAD_RIGHT_TRIGGER + XINPUT_GAMEPAD_WHITE );
		return 0;
	}

	if (strcmp(szi, "service" ) == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_BACK + XINPUT_GAMEPAD_BLACK);
		return 0; 
	}

/*
 
	*/
	// Dip switches - set to a constant and get the value from the driver
	//if (strcmp(szi, "dip") == 0) {
	//	pgi->nInput = 1;
	//	pgi->nConst = *(pgi->pVal);
	
	//	return 0;
	//} 

	return 0;
}

static void SetSliderKey(struct GameInp* pgi, int k0, int k1, int nSlide)
{
	pgi->nInput = 6;
	pgi->nSlider[0] = (unsigned char)k0;
	pgi->nSlider[1] = (unsigned char)k1;

	if (nSlide == 2) {
		// Sliding
		pgi->nSliderSpeed = 0x0700;
		pgi->nSliderCenter = 0;
	} else {
		// Sliding (centering)
		pgi->nSliderSpeed = 0x0E00;
		pgi->nSliderCenter = 10;
	}
}

 
int GamcAnalogJoy(struct GameInp* pgi, char* szi, int nPlayer, int nJoy, int nSlide)
{
	char *szSearch = NULL;
	szSearch=szPlay[nPlayer & 3];
	if (strncmp(szSearch, szi, 3) != 0)	{	// Not our player
		return 1;
	}
	szi += 3;

	if (szi[0] == 0) {
		return 1;
	}
	if (strncmp(szi + 1, "-axis", 5) != 0 && strncmp(szi + 1, "-dial", 5) != 0) {
		return 1;
	}

	pgi->nJoy = (unsigned char)nJoy;
	if (strncmp(szi, "x", 1) == 0) {
		pgi->nAxis = 0;
	}
	if (strncmp(szi, "y", 1) == 0) {
		pgi->nAxis = 1;
	}
	if (strncmp(szi, "z", 1) == 0) {
		pgi->nAxis = 2;
	}

	if (strlen(szi) > 6) {
		if (strcmp(&szi[6], "-lo") == 0) {
			nSlide = 3;
		}
		if (strcmp(&szi[6], "-hi") == 0) {
			nSlide = 4;
		}
	}

	pgi->nSliderValue = 0x8000;				// Put slider in the middle
	switch (nSlide) {
		case 2:								// Sliding
			pgi->nInput = 7;
			pgi->nSliderSpeed = 0x0700;
			pgi->nSliderCenter = 0;
			break;
		case 1:								// Sliding (centering)
			pgi->nInput = 7;
			pgi->nSliderSpeed = 0x0E00;
			pgi->nSliderCenter = 10;
			break;
		case 3:								// Absolute, axis-hi
			pgi->nInput = 4;
			break;
		case 4:								// Absolute, axis-lo
			pgi->nInput = 5;
			break;
		default:							// Absolute, entire axis
			pgi->nInput = 3;
	}

	return 0;
}

// XBox Gamepad  support 
 
int GamcXboxPlayer(struct GameInp* pgi, char* szi, int nPlayer, int nDevice)
{
	char *szSearch = NULL;
	int nJoyBase = 0;
	szSearch = szPlay[nPlayer & 3];
	if (strncmp(szSearch, szi, 3) != 0) {	// Not our player
		return 1;
	}
	szi += 3;

	if (nDevice <= -2) {
		int bOurs = 0;
		if (strcmp(szi, "up") == 0 || strcmp(szi, "y-axis-lo") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "down") == 0 || strcmp(szi, "y-axis-hi") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "left") == 0 || strcmp(szi, "x-axis-lo") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "right") == 0 || strcmp(szi, "x-axis-hi") == 0) {
			bOurs = 1;
		}
		if (strncmp(szi, "fire ", 5) == 0) {
			bOurs = 1;
		}

		if (!bOurs)	{
			return 1;
		}

		pgi->nInput = 1;					// Constant zero
		pgi->nConst = 0;					//

		return 0;
	}
	
	// Now check the rest of it

	// Joystick
	nJoyBase = 0x4000;
	nJoyBase |= nDevice << 8;

	if (m_Config.GetJoyType(nPlayer) == 1)
	{
		if (strcmp(szi, "up") == 0)	{
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_UP + 20)			// + 20 for Analog
		}
		if (strcmp(szi, "down") == 0) {
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_DOWN + 20)
		}
		if (strcmp(szi, "left") == 0)	{
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_LEFT + 20)
		}
		if (strcmp(szi, "right") == 0) {
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_RIGHT + 20)
		}
	}
	else
	{
		if (strcmp(szi, "up") == 0)	{
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_UP)
		}
		if (strcmp(szi, "down") == 0) {
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_DOWN)
		}
		if (strcmp(szi, "left") == 0)	{
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_LEFT)
		}
		if (strcmp(szi, "right") == 0) {
			KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_RIGHT)
		}
	}


	if (strcmp(szi, "start") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_START);
			 
	}
	if (strcmp(szi, "coin" ) == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_BACK);
	}

	if (strcmp(szi, "fire 1") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_X);
	}
	
	if (strcmp(szi, "fire 2") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_A);
	}
	
	if (strcmp(szi, "fire 3") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_B);
	}
	
	if (strcmp(szi, "fire 4") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_Y);
	}
	
	if (strcmp(szi, "fire 5") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_BLACK);
	}
		
	if (strcmp(szi, "fire 6") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_WHITE);
	}

	

	
	return 0;
}

 

// XBox X-Arcade Stick support
 
int GamcXArcade(struct GameInp* pgi, char* szi, int nPlayer, int nDevice)
{
	char *szSearch = NULL;
	int nJoyBase = 0;
	szSearch = szPlay[nPlayer & 3];
	if (strncmp(szSearch, szi, 3) != 0) {	// Not our player
		return 1;
	}
	szi += 3;

	if (nDevice <= -2) {
		int bOurs = 0;
		if (strcmp(szi, "up") == 0 || strcmp(szi, "y-axis-lo") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "down") == 0 || strcmp(szi, "y-axis-hi") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "left") == 0 || strcmp(szi, "x-axis-lo") == 0) {
			bOurs = 1;
		}
		if (strcmp(szi, "right") == 0 || strcmp(szi, "x-axis-hi") == 0) {
			bOurs = 1;
		}
		if (strncmp(szi, "fire ", 5) == 0) {
			bOurs = 1;
		}

		if (!bOurs)	{
			return 1;
		}

		pgi->nInput = 1;					// Constant zero
		pgi->nConst = 0;					//

		return 0;
	}
	
	// Now check the rest of it

	// Joystick
	nJoyBase = 0x4000;
	nJoyBase |= nDevice << 8;

	if (strcmp(szi, "up") == 0)	{
		KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_UP)
	}
	if (strcmp(szi, "down") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_DOWN)
	}
	if (strcmp(szi, "left") == 0)	{
		KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_LEFT)
	}
	if (strcmp(szi, "right") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_DPAD_RIGHT)
	}

	if (strcmp(szi, "start") == 0) {
		KEY(nJoyBase + XINPUT_GAMEPAD_START);
			 
	}

	if (strcmp(szi, "coin" ) == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_LEFT_TRIGGER);

	}

	if (strcmp(szi, "fire 1") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_X);
	}
	
	if (strcmp(szi, "fire 2") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_A);
	}
	
	if (strcmp(szi, "fire 3") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_B);
	}
	
	if (strcmp(szi, "fire 4") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_Y);
	}
	
	if (strcmp(szi, "fire 5") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_WHITE);
	}
		
	if (strcmp(szi, "fire 6") == 0) {
		KEY(nJoyBase + 0x80 + XINPUT_GAMEPAD_BLACK);
	}
	
	return 0;
}


#undef KEY


