#include "tmnt.h"



// TMNT ------------------------------------------------
// Based on DTMNT and MAME
static struct BurnInputInfo DrvInputList[]=
{
	// Coins 
	{"P1 Coin" , 0, TmntCoin+0		,"p1 coin"},
	{"P1 Start" , 0, TmntStart+0	,"p1 start"},
	{"P1 Attack" , 0, TmntAttack+0	,"p1 fire 1"},
	{"P1 Jump" , 0, TmntJump+0		,"p1 fire 2"},
	{"P1 Up" , 0, TmntUp+0			,"p1 up"},
	{"P1 Down" , 0, TmntDown+0		,"p1 down"},
	{"P1 Left" , 0, TmntLeft+0		,"p1 left"},
	{"P1 Right" , 0, TmntRight+0	,"p1 right"},

	{"P2 Coin" , 0, TmntCoin+1		,"p2 coin"},
	{"P2 Start" , 0, TmntStart+1	,"p2 start"},
	{"P2 Attack" , 0, TmntAttack+1	,"p2 fire 1"},
	{"P2 Jump" , 0, TmntJump+1		,"p2 fire 2"},
	{"P2 Up" , 0, TmntUp+1			,"p2 up"},
	{"P2 Down" , 0, TmntDown+1		,"p2 down"},
	{"P2 Left" , 0, TmntLeft+1		,"p2 left"},
	{"P2 Right" , 0, TmntRight+1	,"p2 right"},

	{"P3 Coin" , 0, TmntCoin+2		,"p3 coin"},
	{"P3 Start" , 0, TmntStart+2	,"p3 start"},
	{"P3 Attack" , 0, TmntAttack+2	,"p3 fire 1"},
	{"P3 Jump" , 0, TmntJump+2		,"p3 fire 2"},
	{"P3 Up" , 0, TmntUp+2			,"p3 up"},
	{"P3 Down" , 0, TmntDown+2		,"p3 down"},
	{"P3 Left" , 0, TmntLeft+2		,"p3 left"},
	{"P3 Right" , 0, TmntRight+2	,"p3 right"},

	{"P4 Coin" , 0, TmntCoin+3		,"p4 coin"},
	{"P4 Start" , 0, TmntStart+3	,"p4 start"},
	{"P4 Attack" , 0, TmntAttack+3	,"p4 fire 1"},
	{"P4 Jump" , 0, TmntJump+3		,"p4 fire 2"},
	{"P4 Up" , 0, TmntUp+3			,"p4 up"},
	{"P4 Down" , 0, TmntDown+3		,"p4 down"},
	{"P4 Left" , 0, TmntLeft+3		,"p4 left"},
	{"P4 Right" , 0, TmntRight+3	,"p4 right"},

	{"Reset",		0, &DrvReset,		"reset"},

};

// Return 0 if a input number is defined, and (if pii!=NULL) information about each input
static int DrvInputInfo(struct BurnInputInfo *pii,unsigned int i)
{
	if (i>=sizeof(DrvInputList)/sizeof(DrvInputList[0])) 
		return 1;
	if (pii!=NULL) 
		*pii=DrvInputList[i];
	return 0;
}

//==============================================
//Teenage Mutant Ninja Turtles (World 4 Players)
//==============================================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct { char szName[16]; int nLen; unsigned int nCrc; int nType; } TmntRomDesc[]=
{
	{"963-x23",0x20000, 0xa9549004, 0x10}, //  0 68000 code (even)
	{"963-x24",0x20000, 0xe5cc9067, 0x10}, //  1            (odd)
	{"963-x21",0x10000, 0x5789cf92, 0x10}, //  2            (even)
	{"963-x22",0x10000, 0x0a74e277, 0x10}, //  3            (odd)

	{"963-a28",0x80000, 0xdb4769a8,    1}, //  4 tile bitmaps
	{"963-a29",0x80000, 0x8069cd2e,    1}, //  5
	{"963-a16",0x80000, 0xd4bd9984,    1}, //  6
	{"963-a18",0x80000, 0xdd51adef,    1}, //  7
	{"963-a15",0x80000, 0x1f324eed,    1}, //  8
	{"963-a17",0x80000, 0xb5239a44,    1}, //  9

	{"963-e20",0x08000, 0x1692a6d6,    1}, //  10 Z80 rom
	{"963-a26",0x20000, 0xe2ac3063,    1}, //  11 samples for 007232
	{"963-a27",0x20000, 0x2dfd674b,    1}, //  
	{"963-a25",0x80000, 0xfca078c7,    1}, //  

	{"963-a30",0x0100, 0xabd82680,    1}, //  sprite address decoder
	{"963-a31",0x0100, 0xf8004a1c,    1}, //  priority encoder (not used)
};


// Return 0 if a rom number is defined, and (if pri!=NULL) information about each rom
static int TmntRomInfo(struct BurnRomInfo *pri,unsigned int i)
{
	if (i>=sizeof(TmntRomDesc)/sizeof(TmntRomDesc[0])) 
		return 1; // Check i is in range
	// Return information about the rom
	if (pri!=NULL)
	{
		pri->nLen =TmntRomDesc[i].nLen;
		pri->nCrc =TmntRomDesc[i].nCrc;
		pri->nType=TmntRomDesc[i].nType;
	}
	return 0;
}

// Return possible names for rom number 'i'
static int TmntRomName(char **pszName,unsigned int i,int nAka)
{
	if (i>=sizeof(TmntRomDesc)/sizeof(TmntRomDesc[0])) 
		return 1; // Check i is in range
	if (nAka!=0) 
		return 1; // Roms known by one name
	*pszName=TmntRomDesc[i].szName;
	return 0;
}

struct BurnDriver BurnDrvTmnt=
{
	{"tmnt","Teenage Mutant Ninja Turtles (World 4 Players)","Preliminary Driver","Konami","TMNT","1989",NULL, NULL},
	1,2,HARDWARE_KONAMI_TMNT,
	NULL,TmntRomInfo,TmntRomName,DrvInputInfo, NULL,
	TmntInit,TmntExit,TmntFrame,NULL,TmntScan,
	&bTmntRecalcPal,304,224,4,3  
};
