#include <stdlib.h>
#include <stdio.h>
#include "cmc_int.h"

int ChannelMix_8S(int *Dest, int nLen,
		  char *Sample, int LoopEnd,
		  int *Pos,
		  int VolL, int VolR,
		  int LoopLen,
		  int IncPos)
{
	int p, sl, sr, slN, sl0, sl1, sl2, fp;		// int l, r, Active = 1;

	while (nLen--) {

		// Check for end of sample
		if (*Pos >= LoopEnd) {
			if (LoopLen > 0x1000) {				// Loop sample
				*Pos -= LoopLen;
				*Pos &= 0xFFFFF000;
			} else {
				if (LoopLen) {
					*Pos -= LoopLen;			// Looping a single sample (set looppoint & leave)
					*Pos &= 0xFFFFF000;
					return 1;
				} else {
					*Pos = 0;					// Quit playing
					return 0;
				}
			}
		}

		p = (*Pos) >> 12;						// Find the current sample position
		fp = (*Pos) & ((1 << 12) - 1);

		slN = *(Sample + p - 1);				// Get the sample
		sl0 = *(Sample + p);					// Get the sample
		sl1 = *(Sample + p + 1);				// Get the sample
		sl2 = *(Sample + p + 2);				// Get the sample

		sl = (slN * Precalc[fp * 4 + 0] + sl0 * Precalc[fp * 4 + 1] + sl1 * Precalc[fp * 4 + 2] + sl2 * Precalc[fp * 4 + 3]) / 64;	//16384;

		sr = sl;

		sl *= VolL;
		sr *= VolR;

		// Add to the sound currently in the buffer
		Dest[0] += sl; Dest[1] += sr;

		Dest += 2;

		*Pos += IncPos;							// increment sample position based on pitch
	}
	return 1;
}

int ChannelMix_8U(int *Dest, int nLen,
		  unsigned char *Sample, int LoopEnd,
		  int *Pos,
		  int VolL, int VolR,
		  int LoopLen,
		  int IncPos)
{
	int p, sl, sr, slN, sl0, sl1, sl2, fp;		// int l, r, Active = 1;

	while (nLen--) {

		// Check for end of sample
		if (*Pos >= LoopEnd) {
			if (LoopLen > 0x1000) {				// Loop sample
				*Pos -= LoopLen;
				*Pos &= 0xFFFFF000;
			} else {
				if (LoopLen) {
					*Pos -= LoopLen;			// Looping a single sample (set looppoint & leave)
					*Pos &= 0xFFFFF000;
					return 1;
				} else {
					*Pos = 0;					// Quit playing
					return 0;
				}
			}
		}

		p = (*Pos) >> 12;						// Find the current sample position
		p &= 0xFFFF;							// QSound banks are 0x10000 samples
		fp = (*Pos) & ((1 << 12) - 1);

		slN = (*(Sample + p - 1)) - 0x80;		// Get the sample
		sl0 = (*(Sample + p)) - 0x80;			// Get the sample
		sl1 = (*(Sample + p + 1)) - 0x80;		// Get the sample
		sl2 = (*(Sample + p + 2)) - 0x80;		// Get the sample

		sl = (slN*Precalc[fp*4 +0] + sl0*Precalc[fp*4 +1] + sl1*Precalc[fp*4 +2] + sl2*Precalc[fp*4 +3]) / 64;//16384;

		sr=sl;

		sl*=VolL;
		sr*=VolR;

		// Add to the sound currently in the buffer
		Dest[0]+=sl; Dest[1]+=sr;
		Dest+=2;

		*Pos += IncPos;							// increment sample position based on pitch
	}

	return 1;
}

void AdaptSoundBuff(int *Src, short *Dest, int Len)
{

#define CLIP(A) (  (A) < -0x8000 ? -0x8000 : (A) > 0x7fff ? 0x7fff : (A)  )

  Len *= 2;
  while (Len--)
  {
    *Dest = CLIP( (*Src >> 8) );
    Src++;
    Dest++;
  }
}

void AdaptSoundBuff_Add(int *Src, short *Dest, int Len)
{

#define CLIP(A) (  (A) < -0x8000 ? -0x8000 : (A) > 0x7fff ? 0x7fff : (A)  )

  Len *= 2;
  while (Len--)
  {
    *Dest = CLIP( (*Src >> 8) + *Dest );
    Src++;
    Dest++;
  }
}

