 #include "cps.h"

/*===================
Pocket Fighter Driver
===================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
  {"P1 Start"      , 0, CpsInp020+0, "p1 start"},
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"      , 0, CpsInp001+0, "p1 right"},
  {"P1 Punch"      , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Kick"       , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Special"    , 0, CpsInp001+6, "p1 fire 3"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
  {"P2 Start"      , 0, CpsInp020+1, "p2 start"},
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"      , 0, CpsInp000+0, "p2 right"},
  {"P2 Punch"      , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Kick"       , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Special"    , 0, CpsInp000+6, "p2 fire 3"},

  {"Reset"         , 0, &CpsReset   , "reset"},
  {"Diagnostic"    , 0, CpsInp021+1, "diag"},
  {"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
 int nRet=0; int i=0; unsigned char *pqs=NULL;

 Cps=2;
 nCpsRomLen=  5*0x080000;
 nCpsCodeLen= 1*0x080000;
 nCpsGfxLen=  5*0x400000;
 nCpsZRomLen= 2*0x020000;
 nCpsQSamLen= 2*0x400000;
 nRet=CpsInit(); if (nRet!=0) return 1;

 // Load program roms (as they are on the roms) for CpsRom
 for (i=0;i<5;i++)
 { nRet=BurnLoadRom(CpsRom+0x080000*i,1+i,1); if (nRet!=0) return 1; }

 // Make decrypted rom
 memcpy(CpsCode,CpsRom,nCpsCodeLen);
 nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;

 // Load graphics roms
 nRet=Cps2LoadTiles(CpsGfx           , 6);
 nRet=Cps2LoadTiles(CpsGfx+4*0x400000,10);

 // Load Z80 Roms
 nRet=BurnLoadRom(CpsZRom         ,14,1);
 nRet=BurnLoadRom(CpsZRom+ 0x20000,15,1);

 // Load Q Sample Roms
 pqs=(unsigned char *)CpsQSam;
 nRet=BurnLoadRom(pqs         ,16,1);
 nRet=BurnLoadRom(pqs+0x400000,17,1);
 BurnByteswap(pqs,nCpsQSamLen);


 nRet=CpsRunInit();

 if (nRet!=0) return 1;
 // Ready to go
 return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

/*=====================
Super Gem Fighter (USA)
=====================*/


static struct BurnRomInfo SgemfRomDesc[]=
{
  {"pcfux.03" ,0x080000,0x652b7647, 0x10},         // 0

  {"pcfu.03"  ,0x080000,0xac2e8566, 0x10},         // 1
  {"pcf.04"   ,0x080000,0xf4314c96, 0x10},
  {"pcf.05"   ,0x080000,0x215655f6, 0x10},
  {"pcf.06"   ,0x080000,0xea6f13ea, 0x10},
  {"pcf.07"   ,0x080000,0x5ac6d5ea, 0x10},

  {"pcf.13"   ,0x400000,0x22d72ab9,    1},         // 6
  {"pcf.15"   ,0x400000,0x16a4813c,    1},
  {"pcf.17"   ,0x400000,0x1097e035,    1},
  {"pcf.19"   ,0x400000,0xd362d874,    1},
  {"pcf.14"   ,0x100000,0x0383897c,    1},         // 10
  {"pcf.16"   ,0x100000,0x76f91084,    1},
  {"pcf.18"   ,0x100000,0x756c3754,    1},
  {"pcf.20"   ,0x100000,0x9ec9277d,    1},

  {"pcf.01"   ,0x020000,0x254e5f33,    2},         // 14
  {"pcf.02"   ,0x020000,0x6902f4f9,    2},

  {"pcf.11"   ,0x400000,0xa5dea005,    2},         // 16
  {"pcf.12"   ,0x400000,0x4ce235fe,    2},
};

STD_ROM_PICK(Sgemf) STD_ROM_FN(Sgemf)

struct BurnDriver BurnDrvCpsSgemf=
{
  {"sgemf" ,"Super Gem Fighter Mini Mix (US 970904)","","Capcom","CPS2","1997",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SgemfRomInfo, SgemfRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*====================
Pocket Fighter (Japan)
====================*/


static struct BurnRomInfo PfghtjRomDesc[]=
{
  {"pcfjx.03" ,0x080000,0xa523f21e, 0x10},         // 0

  {"pcfj.03"  ,0x080000,0x681da43e, 0x10},         // 1
  {"pcf.04"   ,0x080000,0xf4314c96, 0x10},
  {"pcf.05"   ,0x080000,0x215655f6, 0x10},
  {"pcf.06"   ,0x080000,0xea6f13ea, 0x10},
  {"pcf.07"   ,0x080000,0x5ac6d5ea, 0x10},

  {"pcf.13"   ,0x400000,0x22d72ab9,    1},         // 6
  {"pcf.15"   ,0x400000,0x16a4813c,    1},
  {"pcf.17"   ,0x400000,0x1097e035,    1},
  {"pcf.19"   ,0x400000,0xd362d874,    1},
  {"pcf.14"   ,0x100000,0x0383897c,    1},         // 10
  {"pcf.16"   ,0x100000,0x76f91084,    1},
  {"pcf.18"   ,0x100000,0x756c3754,    1},
  {"pcf.20"   ,0x100000,0x9ec9277d,    1},

  {"pcf.01"   ,0x020000,0x254e5f33,    2},         // 14
  {"pcf.02"   ,0x020000,0x6902f4f9,    2},

  {"pcf.11"   ,0x400000,0xa5dea005,    2},         // 16
  {"pcf.12"   ,0x400000,0x4ce235fe,    2},
};

STD_ROM_PICK(Pfghtj) STD_ROM_FN(Pfghtj)

struct BurnDriver BurnDrvCpsPfghtj=
{
  {"pfghtj" ,"Pocket Fighter (Japan 970904)","","Capcom","CPS2","1997","sgemf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, PfghtjRomInfo, PfghtjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================
Super Gem Fighter (Asia)
======================*/


static struct BurnRomInfo SgemfaRomDesc[]=
{
  {"pcfax.03" ,0x080000,0x750fabe2, 0x10},         // 0

  {"pcfa.03"  ,0x080000,0xe17c089a, 0x10},         // 1
  {"pcf.04"   ,0x080000,0xf4314c96, 0x10},
  {"pcf.05"   ,0x080000,0x215655f6, 0x10},
  {"pcf.06"   ,0x080000,0xea6f13ea, 0x10},
  {"pcf.07"   ,0x080000,0x5ac6d5ea, 0x10},

  {"pcf.13"   ,0x400000,0x22d72ab9,    1},         // 6
  {"pcf.15"   ,0x400000,0x16a4813c,    1},
  {"pcf.17"   ,0x400000,0x1097e035,    1},
  {"pcf.19"   ,0x400000,0xd362d874,    1},
  {"pcf.14"   ,0x100000,0x0383897c,    1},         // 10
  {"pcf.16"   ,0x100000,0x76f91084,    1},
  {"pcf.18"   ,0x100000,0x756c3754,    1},
  {"pcf.20"   ,0x100000,0x9ec9277d,    1},

  {"pcf.01"   ,0x020000,0x254e5f33,    2},         // 14
  {"pcf.02"   ,0x020000,0x6902f4f9,    2},

  {"pcf.11"   ,0x400000,0xa5dea005,    2},         // 16
  {"pcf.12"   ,0x400000,0x4ce235fe,    2},
};

STD_ROM_PICK(Sgemfa) STD_ROM_FN(Sgemfa)

struct BurnDriver BurnDrvCpsSgemfa=
{
  {"sgemfa" ,"Super Gem Fighter Mini Mix (Asia 970904)","","Capcom","CPS2","1997","sgemf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SgemfaRomInfo, SgemfaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================
Super Gem Fighter (Hispanic)
==========================*/


static struct BurnRomInfo SgemfhRomDesc[]=
{
  {"pcfhx.03" ,0x080000,0x00000000, 0x10},         // 0

  {"pcfh.03"  ,0x080000,0xe9103347, 0x10},         // 1
  {"pcf.04"   ,0x080000,0xf4314c96, 0x10},
  {"pcf.05"   ,0x080000,0x215655f6, 0x10},
  {"pcf.06"   ,0x080000,0xea6f13ea, 0x10},
  {"pcf.07"   ,0x080000,0x5ac6d5ea, 0x10},

  {"pcf.13"   ,0x400000,0x22d72ab9,    1},         // 6
  {"pcf.15"   ,0x400000,0x16a4813c,    1},
  {"pcf.17"   ,0x400000,0x1097e035,    1},
  {"pcf.19"   ,0x400000,0xd362d874,    1},
  {"pcf.14"   ,0x100000,0x0383897c,    1},         // 10
  {"pcf.16"   ,0x100000,0x76f91084,    1},
  {"pcf.18"   ,0x100000,0x756c3754,    1},
  {"pcf.20"   ,0x100000,0x9ec9277d,    1},

  {"pcf.01"   ,0x020000,0x254e5f33,    2},         // 14
  {"pcf.02"   ,0x020000,0x6902f4f9,    2},

  {"pcf.11"   ,0x400000,0xa5dea005,    2},         // 16
  {"pcf.12"   ,0x400000,0x4ce235fe,    2},
};

STD_ROM_PICK(Sgemfh) STD_ROM_FN(Sgemfh)

struct BurnDriverX BurnDrvCpsSgemfh=
{
  {"sgemfh" ,"Super Gem Fighter Mini Mix (Hispanic 970904)","Encrypted","Capcom","CPS2","1997","sgemf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, SgemfhRomInfo, SgemfhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
