// Street Fighter Alpha

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;
  Cps=2;
  nCpsRomLen=  4*0x080000;
  nCpsCodeLen= 1*0x080000;
  nCpsGfxLen=    0x800000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<4;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,1+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode,0,1); if (nRet!=0) return 1;

  Cps2LoadTiles(CpsGfx,5);

  nRet=BurnLoadRom(CpsZRom         , 9,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,10,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,11,1);
  nRet=BurnLoadRom(pqs+0x200000,12,1);
  BurnByteswap(pqs,nCpsQSamLen);

  nRet=CpsRunInit(); if (nRet!=0) return 1;


  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//===========================
//Street Fighter Alpha (Euro)
//===========================


static struct BurnRomInfo SfaRomDesc[]=
{
  {"sfzex.03b",0x80000,0x505a1b4a, 0x10},

  {"sfze.03b" ,0x80000,0xebf2054d, 0x10},
  {"sfz.04b"  ,0x80000,0x8b73b0e5, 0x10},
  {"sfz.05a"  ,0x80000,0x0810544d, 0x10},
  {"sfz.06"   ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfa) STD_ROM_FN(Sfa)

struct BurnDriver BurnDrvCpsSfa=
{
  {"sfa","Street Fighter Alpha: Warriors' Dreams (Euro 950727)","","Capcom","CPS2","1995",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SfaRomInfo, SfaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Street Fighter Alpha (Euro r2)
//==============================


static struct BurnRomInfo Sfar2RomDesc[]=
{
  {"sfzex.03a",0x80000,0xb50d87c7, 0x10},

  {"sfze.03a",0x80000,0xfdbcd434, 0x10},
  {"sfz.04"  ,0x80000,0x0c436d30, 0x10},
  {"sfz.05"  ,0x80000,0x1f363612, 0x10},
  {"sfz.06"  ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfar2) STD_ROM_FN(Sfar2)

struct BurnDriver BurnDrvCpsSfar2=
{
  {"sfar2","Street Fighter Alpha: Warriors' Dreams (Euro 950605)","","Capcom","CPS2","1995","sfa", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfar2RomInfo, Sfar2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Street Fighter Alpha (Euro r1)
//==============================


static struct BurnRomInfo Sfar1RomDesc[]=
{
  {"sfzex.03c",0x80000,0x00000000, 0x10},

  {"sfze.03c",0x80000,0xa1b69dd7, 0x10},
  {"sfze.04b",0x80000,0xbb90acd5, 0x10},
  {"sfz.05a" ,0x80000,0x0810544d, 0x10},
  {"sfz.06"  ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfar1) STD_ROM_FN(Sfar1)

struct BurnDriverX BurnDrvCpsSfar1=
{
  {"sfar1","Street Fighter Alpha: Warriors' Dreams (Euro 950718)","Encrypted","Capcom","CPS2","1995","sfa", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfar1RomInfo, Sfar1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================================
//Street Fighter Alpha: Warriors Dreams (USA)
//===========================================


static struct BurnRomInfo SfauRomDesc[]=
{
  {"sfzux.03a",0x80000,0x1a3160ed, 0x10},

  {"sfzu.03a" ,0x80000,0x49fc7db9, 0x10},
  {"sfz.04a"  ,0x80000,0x5f99e9a5, 0x10},
  {"sfz.05a"  ,0x80000,0x0810544d, 0x10},
  {"sfz.06"   ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfau) STD_ROM_FN(Sfau)

struct BurnDriver BurnDrvCpsSfau=
{
  {"sfau","Street Fighter Alpha: Warriors' Dreams (US 950627)","","Capcom","CPS2","1995","sfa", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SfauRomInfo, SfauRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================
//Street Fighter Zero (Japan)
//===========================


static struct BurnRomInfo SfzjRomDesc[]=
{
  {"sfzjx.03c",0x80000,0xd6b17a9b, 0x10},

  {"sfzj.03c" ,0x80000,0xf5444120, 0x10},
  {"sfz.04b"  ,0x80000,0x8b73b0e5, 0x10},
  {"sfz.05a"  ,0x80000,0x0810544d, 0x10},
  {"sfz.06"   ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfzj) STD_ROM_FN(Sfzj)

struct BurnDriver BurnDrvCpsSfzj=
{
  {"sfzj","Street Fighter Zero (Japan 950727)","","Capcom","CPS2","1995","sfa", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SfzjRomInfo, SfzjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Street Fighter Zero (Japan r1)
//==============================


static struct BurnRomInfo Sfzjr1RomDesc[]=
{
  {"sfzjx.03b",0x80000,0xb501f03c, 0x10},

  {"sfzj.03b" ,0x80000,0x844220c2, 0x10},
  {"sfz.04a"  ,0x80000,0x5f99e9a5, 0x10},
  {"sfz.05a"  ,0x80000,0x0810544d, 0x10},
  {"sfz.06"   ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfzjr1) STD_ROM_FN(Sfzjr1)

struct BurnDriver BurnDrvCpsSfzjr1=
{
  {"sfzjr1","Street Fighter Zero (Japan 950627)","","Capcom","CPS2","1995","sfa", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfzjr1RomInfo, Sfzjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Street Fighter Zero (Japan r2)
//==============================


static struct BurnRomInfo Sfzjr2RomDesc[]=
{
  {"sfzjx.03a",0x80000,0x3cc138b5, 0x10},

  {"sfzj.03a" ,0x80000,0x3cfce93c, 0x10},
  {"sfz.04"   ,0x80000,0x0c436d30, 0x10},
  {"sfz.05"   ,0x80000,0x1f363612, 0x10},
  {"sfz.06"   ,0x80000,0x806e8f38, 0x10},

  {"sfz.14"  ,0x200000,0x90fefdb3,    1},
  {"sfz.16"  ,0x200000,0x5354c948,    1},
  {"sfz.18"  ,0x200000,0x41a1e790,    1},
  {"sfz.20"  ,0x200000,0xa549df98,    1},

  {"sfz.01"  ,0x020000,0xffffec7d,    2},
  {"sfz.02"  ,0x020000,0x45f46a08,    2},

  {"sfz.11"  ,0x200000,0xc4b093cd,    2},
  {"sfz.12"  ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfzjr2) STD_ROM_FN(Sfzjr2)

struct BurnDriver BurnDrvCpsSfzjr2=
{
  {"sfzjr2","Street Fighter Zero (Japan 950605)","","Capcom","CPS2","1995","sfa", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfzjr2RomInfo, Sfzjr2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Street Fighter Zero (Hispanic)
//==============================


static struct BurnRomInfo SfzhRomDesc[]=
{
  {"sfzhx.03c",0x080000,0x00000000, 0x10},

  {"sfzh.03c" ,0x080000,0xbce635aa, 0x10},
  {"sfz.04a"  ,0x080000,0x5f99e9a5, 0x10},
  {"sfz.05a"  ,0x080000,0x0810544d, 0x10},
  {"sfz.06"   ,0x080000,0x806e8f38, 0x10},

  {"sfz.14"   ,0x200000,0x90fefdb3,    1},
  {"sfz.16"   ,0x200000,0x5354c948,    1},
  {"sfz.18"   ,0x200000,0x41a1e790,    1},
  {"sfz.20"   ,0x200000,0xa549df98,    1},

  {"sfz.01"   ,0x020000,0xffffec7d,    2},
  {"sfz.02"   ,0x020000,0x45f46a08,    2},

  {"sfz.11"   ,0x200000,0xc4b093cd,    2},
  {"sfz.12"   ,0x200000,0x8bdbc4b4,    2},
};

STD_ROM_PICK(Sfzh) STD_ROM_FN(Sfzh)

struct BurnDriverX BurnDrvCpsSfzh=
{
  {"sfzh","Street Fighter Zero (Hispanic 950627)","Encrypted","Capcom","CPS2","1995","sfa", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, SfzhRomInfo, SfzhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
