// Module for Xbox Gamepad
#include "..\..\fba.h"
 
#ifdef _XBOX
	#define MAX_JOYSTICKS (64)
#else
	#define MAX_JOYSTICKS (64)	
#endif
 
// Number of joysticks connected to this machine

#ifdef _XBOX
static int nJoystickCount=4;		// We poll all 4 gamepad Xbox ports by default
#else
static int nJoystickCount=0;
#endif
 

// Sets up one Joystick (for example the range of the joystick's axes)
static int SetUpJoystick(int i)
{
 	return 0;
}
 
static unsigned char bJoystickRead[MAX_JOYSTICKS];
//static int bKeyboardRead = 0;						// A flag to say if the Keyboard was read this frame
//static unsigned char KeyboardState[256];

int DinpStart()										// Call before checking for Input in a frame
{
	// No joysticks have been Read for this frame
	memset(&bJoystickRead, 0, nJoystickCount * sizeof(bJoystickRead[0]));
	
	// Keyboard not Read this frame
//	bKeyboardRead = 0;
	
	return 0;
}

// Read one of the joysticks
static inline int ReadXboxGamepad(int i)
{

	// Lantus - we dont need this for Xbox, so get the current gamepad state.

	VidXboxDoStrech();

//	XBInput_GetInput(g_Gamepads);
	
	return 0;
}

 
// Check a subcode (the 40xx bit in 4001, 4102 etc) for a joystick input code
 
static int XBoxGamepadState(int i, unsigned int nSubCode)
{
	const int DEADZONE = 0x4000;

	int nPlayerJoyType = m_Config.GetJoyType(i);

		switch (nSubCode) {

			// direction
			if(nPlayerJoyType == 0 || nPlayerJoyType == 2)
			{
				case 0x01: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_UP ? 1 : 0);		// Up
				case 0x02: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ? 1 : 0);		// Down
				case 0x04: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ? 1 : 0);		// Left
				case 0x08: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ? 1 : 0);		// Right
			}
			else if (nPlayerJoyType == 1)
			{
				// Analog :
				case 0x01 + 20: return (g_Gamepads[i].sThumbLY >  DEADZONE);		// Up
				case 0x02 + 20: return (g_Gamepads[i].sThumbLY < -DEADZONE);		// Down
				case 0x04 + 20: return (g_Gamepads[i].sThumbLX < -DEADZONE);		// Left
				case 0x08 + 20: return (g_Gamepads[i].sThumbLX >  DEADZONE);	    // Right

			}

			case 0x10: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_START ? 1 : 0);			// Start
			case 0x20: return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_BACK ? 1 : 0);			// Back	
			
			// misc
			case XINPUT_GAMEPAD_BACK + XINPUT_GAMEPAD_WHITE:
				return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_BACK 
					&& g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_WHITE] ? 1 : 0);				// diag

			case XINPUT_GAMEPAD_BACK + XINPUT_GAMEPAD_BLACK:
				return (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_BACK 
					&& g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_BLACK] ? 1 : 0);				// service

			case XINPUT_GAMEPAD_LEFT_TRIGGER + XINPUT_GAMEPAD_RIGHT_TRIGGER + XINPUT_GAMEPAD_WHITE: // reset
				return (g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] 
					&& g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]
					&& g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_WHITE]? 1 : 0);

			
			// Fire buttons

			case 0x80 + XINPUT_GAMEPAD_X:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,0)] ? 1 : 0);				// fire 1
			case 0x80 + XINPUT_GAMEPAD_A:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,1)] ? 1 : 0);				// fire 2
			case 0x80 + XINPUT_GAMEPAD_B:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,2)] ? 1 : 0);				// fire 3
			case 0x80 + XINPUT_GAMEPAD_Y:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,3)] ? 1 : 0);				// fire 4
			case 0x80 + XINPUT_GAMEPAD_WHITE:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,4)] ? 1 : 0);			// fire 5
			case 0x80 + XINPUT_GAMEPAD_BLACK:
				return (g_Gamepads[i].bAnalogButtons[m_Config.GetFireMapping(i,5)] ? 1 : 0);			// fire 6

			if (nPlayerJoyType == 2)
			{
			case 0x80 + XINPUT_GAMEPAD_LEFT_TRIGGER: 
				return (g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ? 1 : 0);			// Back	
			}


		}
 
  
	
	return 0;
}

// Get the state (pressed = 1, not pressed = 0) of a particular input code
int DinpState(int nCode)
{
	if (nCode < 0) {
		return 0;
	}

	if (nCode < 0x8000) {
		// Codes 4000-8000 = Joysticks
		int nJoyNumber = 0;
		nJoyNumber = (nCode - 0x4000) >> 8;
		if (nJoyNumber >= nJoystickCount) {					// This joystick number isn't connected
			return 0;
		}
		if (ReadXboxGamepad(nJoyNumber) != 0) {				// There was an error polling the joystick
			return 0;
		}
		
		// Find the joystick state in our array
		return XBoxGamepadState	(nJoyNumber, nCode & 0xFF);
	}

	return 0;
}

 

// Read the axis of a joystick
int DinpAxis(int i, int nAxis)
{
	if (i < 0 || i >= nJoystickCount) {			   // This joystick number isn't connected
		return 0;
	}
	if (ReadXboxGamepad(i) != 0) {						// There was an error polling the joystick
		return 0;
	}
	
	switch (nAxis) {
		case 0:
			return (g_Gamepads[i].sThumbLX);
			//return JoyState[i].lX;
		case 1:
			return -(g_Gamepads[i].sThumbLY);
			//return JoyState[i].lY;
		case 2:
			if (g_Gamepads[i].sThumbRX >= -4000 && g_Gamepads[i].sThumbRX <= 4000)
				return 0;
			else
				return g_Gamepads[i].sThumbRX;	
		case 3:
			return 0;
			//return g_Gamepads[i].sThumbRX;
			//return JoyState[i].lRx;
		case 4:
			return 0;
			//return g_Gamepads[i].sThumbRY;
			//return JoyState[i].lRy;
		case 5:
			return 0;								// Xbox Not Supported
			//return JoyState[i].lRz;
		case 6:
			return 0;								// Xbox Not Supported
			//return JoyState[i].rglSlider[0];
		case 7:
			return 0;								// Xbox Not Supported
			//return JoyState[i].rglSlider[1];
	}
	
	return 0;
}
