// all about the Xbox gamepads

#include "fba.h"
#include "GamepadConfig.h"

// Quick Instructions:

// if you want to get a button mapping use GetFireMapping();
// if you want to set a button mapping use SetFireMapping();


CConfiguration::CConfiguration()
{
	int i;

	m_nPlayerNumPos = 0;	// start at player 1 (0)

	// setup config stuff : default all all 4 players to DPad
	 
	m_ConfigMap[0] = DPAD;
	m_ConfigMap[1] = DPAD;
	m_ConfigMap[2] = DPAD;
	m_ConfigMap[3] = DPAD;

	m_ButtonMap[XINPUT_GAMEPAD_X] = 0;
	m_ButtonMap[XINPUT_GAMEPAD_A] = 1;
	m_ButtonMap[XINPUT_GAMEPAD_B] = 2;
	m_ButtonMap[XINPUT_GAMEPAD_Y] = 3;
	m_ButtonMap[XINPUT_GAMEPAD_WHITE] = 4;
	m_ButtonMap[XINPUT_GAMEPAD_BLACK] = 5;
	m_ButtonMap[XINPUT_GAMEPAD_LEFT_TRIGGER] = 6;
	m_ButtonMap[XINPUT_GAMEPAD_RIGHT_TRIGGER] = 7;

	m_LookupMap[0] = XINPUT_GAMEPAD_X;
	m_LookupMap[1] = XINPUT_GAMEPAD_A;
	m_LookupMap[2] = XINPUT_GAMEPAD_B;
	m_LookupMap[3] = XINPUT_GAMEPAD_Y;
	m_LookupMap[4] = XINPUT_GAMEPAD_WHITE;
	m_LookupMap[5] = XINPUT_GAMEPAD_BLACK;
	m_LookupMap[6] = XINPUT_GAMEPAD_LEFT_TRIGGER;
	m_LookupMap[7] = XINPUT_GAMEPAD_RIGHT_TRIGGER;

	// default mappings

	for (i = 0; i < MAXGAMEPADS; i++)
	{
		m_PlayerMappings[i].dwFire[0] = XINPUT_GAMEPAD_X;
		m_PlayerMappings[i].dwFire[1] = XINPUT_GAMEPAD_A;
		m_PlayerMappings[i].dwFire[2] = XINPUT_GAMEPAD_B;
		m_PlayerMappings[i].dwFire[3] = XINPUT_GAMEPAD_Y;
		m_PlayerMappings[i].dwFire[4] = XINPUT_GAMEPAD_WHITE;
		m_PlayerMappings[i].dwFire[5] = XINPUT_GAMEPAD_BLACK;
	}

}
void CConfiguration::ShowPlayerGamepadType(void)
{
	// Pretty Joytype Screen

		int i = 0;
		int nSelection = 0;

		WCHAR      m_ItemName[50]; 
		WCHAR      m_ModeString[50];
		
		
		m_Font.Begin();

		for (i = 0; i < MAXGAMEPADS; i++)
		{
			
			swprintf( m_ItemName, L"Player %d Control mode :\n", i+1);

			nSelection = m_ConfigMap[i];

			switch (nSelection){
			case 0 : swprintf( m_ModeString, L"Joypad Digital" );
						break;
			case 1 : swprintf( m_ModeString, L"Joypad Analog" );
						break;
			case 2 : swprintf( m_ModeString, L"X-Arcade" );
						break;
			}

			if (m_nPlayerNumPos == i)
				m_Font.DrawText( 150, 200 + (i*20) , 0xff4444FF, m_ItemName);
			else
				m_Font.DrawText( 150, 200 + (i*20), 0xff000000, m_ItemName);

			m_Font.DrawText( 380, 200 + (i*20), 0xffFF0000, m_ModeString);

		}
		 
		m_Font.DrawText( 320, 400, 0xff000000, L"'A' = Gamepad Mapping, 'Y' = Game Select ", XBFONT_CENTER_X);
		m_Font.End();


}

int CConfiguration::GetJoyType(int nPlayer)
{
	// Returns 0, 1 or 2 (0 = dpad, 1 = analog, 2 = xarcade) based on what user set

	return m_ConfigMap[nPlayer];

}

DWORD CConfiguration::GetFireMapping(int nPlayer, int nFireNum)
{
	// Returns Xbox button value based on player and fire button

	return m_PlayerMappings[nPlayer].dwFire[nFireNum];
}

int CConfiguration::GetFireType(int nPlayer, int nFireNum)
{
	// Not required for anything except for UI stuff

	return m_ButtonMap[GetFireMapping(nPlayer, nFireNum)];

}	

void CConfiguration::SetFireMapping(int nPlayer, int nFireNum, DWORD nButton)
{
	// Set a Xbox button value based on player and fire button

	m_PlayerMappings[nPlayer].dwFire[nFireNum] = nButton;
}

void CConfiguration::SetJoyType(int nPlayer, int nType)
{

	// Set a Joy Type based on player (0=dpad, 1 =analog, 2=xarcade)

	m_ConfigMap[nPlayer] = nType;

}

 
void CConfiguration::ShowPlayerMappings(int nPlayer)
{
	// Pretty Mapping Screen

	int i = 0;
 
	WCHAR      m_ItemName[50]; 
	WCHAR      m_ModeString[50];
		
	swprintf( m_ItemName, L"Player %d Button Mappings :\n", nPlayer + 1);

	m_Font.Begin();
	m_Font.DrawText(320, 200, 0xff000000, m_ItemName, XBFONT_CENTER_X);
	

	for (i = 0; i < MAXFIREBUTTONS; i++)
	{
		
		swprintf( m_ItemName, L"Fire %d:\n", i+1);

		switch (m_ButtonMap[m_PlayerMappings[nPlayer].dwFire[i]]){
		case 0 : swprintf( m_ModeString, L"X Button" );
					break;
		case 1 : swprintf( m_ModeString, L"A Button" );
					break;
		case 2 : swprintf( m_ModeString, L"B Button" );
					break;
		case 3 : swprintf( m_ModeString, L"Y Button" );
					break;
		case 4 : swprintf( m_ModeString, L"White Button" );
					break;
		case 5 : swprintf( m_ModeString, L"Black Button" );
					break;
		case 6 : swprintf( m_ModeString, L"Left Trigger" );
					break;
		case 7 : swprintf( m_ModeString, L"Right Trigger" );
					break;
		}

		if (m_nButtonPos == i)
			m_Font.DrawText( 200, 240 + (i*20) , 0xff4444FF, m_ItemName);
		else
			m_Font.DrawText( 200, 240 + (i*20), 0xff000000, m_ItemName);

		m_Font.DrawText( 280, 240 + (i*20), 0xffFF0000, m_ModeString);

	}
	 
	m_Font.DrawText( 320, 400, 0xff000000, L"'A' = OK, 'Y' = Cancel", XBFONT_CENTER_X);
	m_Font.End();
		
}