#ifndef _TEXTURE_H_
#define _TEXTURE_H_

#include "common.h"

#define MAX_NUM_RESOURCES 1024

#define D3DCOMMON_TYPE_MASK				0x00070000
#define D3DCOMMON_TYPE_SHIFT			16
#define D3DCOMMON_TYPE_VERTEXBUFFER		0x00000000
#define D3DCOMMON_TYPE_INDEXBUFFER		0x00010000
#define D3DCOMMON_TYPE_PUSHBUFFER		0x00020000
#define D3DCOMMON_TYPE_PALETTE			0x00030000
#define D3DCOMMON_TYPE_TEXTURE			0x00040000
#define D3DCOMMON_TYPE_SURFACE			0x00050000
#define D3DCOMMON_TYPE_FIXUP			0x00060000

#define D3DFORMAT_RESERVED1_MASK        0x00000003      // Must be zero
                                        
#define D3DFORMAT_DMACHANNEL_MASK       0x00000003
#define D3DFORMAT_DMACHANNEL_A          0x00000001      // DMA channel A - the default for all system memory
#define D3DFORMAT_DMACHANNEL_B          0x00000002      // DMA channel B - unused
#define D3DFORMAT_CUBEMAP               0x00000004      // Set if the texture if a cube map
#define D3DFORMAT_BORDERSOURCE_COLOR    0x00000008
#define D3DFORMAT_DIMENSION_MASK        0x000000F0      // # of dimensions
#define D3DFORMAT_DIMENSION_SHIFT       4
#define D3DFORMAT_FORMAT_MASK           0x0000FF00
#define D3DFORMAT_FORMAT_SHIFT          8
#define D3DFORMAT_MIPMAP_MASK           0x000F0000
#define D3DFORMAT_MIPMAP_SHIFT          16
#define D3DFORMAT_USIZE_MASK            0x00F00000      // Log 2 of the U size of the base texture
#define D3DFORMAT_USIZE_SHIFT           20
#define D3DFORMAT_VSIZE_MASK            0x0F000000      // Log 2 of the V size of the base texture
#define D3DFORMAT_VSIZE_SHIFT           24
#define D3DFORMAT_PSIZE_MASK            0xF0000000      // Log 2 of the P size of the base texture
#define D3DFORMAT_PSIZE_SHIFT           28

#define FMT_SWIZZLED					0x1
#define FMT_LINEAR						0x2
#define FMT_COMPRESSED					0x4

#define DDSD_CAPS						0x00000001
#define DDSD_HEIGHT						0x00000002
#define DDSD_WIDTH						0x00000004
#define DDSD_PITCH						0x00000008
#define DDSD_PIXELFORMAT				0x00001000
#define DDSD_MIPMAPCOUNT				0x00020000
#define DDSD_LINEARSIZE					0x00080000
#define DDSD_DEPTH						0x00800000

#define DDPF_ALPHAPIXELS				0x00000001
#define DDPF_FOURCC						0x00000004
#define DDPF_RGB						0x00000040

#define DDSCAPS_COMPLEX					0x00000008
#define DDSCAPS_TEXTURE					0x00001000
#define DDSCAPS_MIPMAP					0x00400000

#define DDSCAPS2_CUBEMAP				0x00000200
#define DDSCAPS2_CUBEMAP_POSITIVEX		0x00000400
#define DDSCAPS2_CUBEMAP_NEGATIVEX		0x00000800
#define DDSCAPS2_CUBEMAP_POSITIVEY		0x00001000
#define DDSCAPS2_CUBEMAP_NEGATIVEY		0x00002000
#define DDSCAPS2_CUBEMAP_POSITIVEZ		0x00004000
#define DDSCAPS2_CUBEMAP_NEGATIVEZ		0x00008000
#define DDSCAPS2_VOLUME					0x00200000

const struct TEXTUREFORMAT
{
    char* name;
    dword id;
    dword type;
} textureformats[] =
{
    { "D3DFMT_A8R8G8B8",        0x00000006 /* D3DFMT_A8R8G8B8 */,      FMT_SWIZZLED    },
    { "D3DFMT_LIN_A8R8G8B8",    0x00000012 /* D3DFMT_LIN_A8R8G8B8 */,  FMT_LINEAR      },
    { "D3DFMT_X8R8G8B8",        0x00000007 /* D3DFMT_X8R8G8B8 */,      FMT_SWIZZLED    },
    { "D3DFMT_LIN_X8R8G8B8",    0x0000001E /* D3DFMT_LIN_X8R8G8B8 */,  FMT_LINEAR      },
    { "D3DFMT_R5G6B5",          0x00000005 /* D3DFMT_R5G6B5 */,        FMT_SWIZZLED    },
    { "D3DFMT_LIN_R5G6B5",      0x00000011 /* D3DFMT_LIN_R5G6B5 */,    FMT_LINEAR      },
    { "D3DFMT_A1R5G5B5",        0x00000002 /* D3DFMT_A1R5G5B5 */,      FMT_SWIZZLED    },
    { "D3DFMT_LIN_A1R5G5B5",    0x00000010 /* D3DFMT_LIN_A1R5G5B5 */,  FMT_LINEAR      },
    { "D3DFMT_A4R4G4B4",        0x00000004 /* D3DFMT_A4R4G4B4 */,      FMT_SWIZZLED    },
    { "D3DFMT_LIN_A4R4G4B4",    0x0000001D /* D3DFMT_LIN_A4R4G4B4 */,  FMT_LINEAR      },
    { "D3DFMT_DXT1",            0x0000000C /* D3DFMT_DXT1 */,          FMT_COMPRESSED  },
    { "D3DFMT_DXT2",            0x0000000E /* D3DFMT_DXT2 */,          FMT_COMPRESSED  },
    { "D3DFMT_DXT4",            0x0000000F /* D3DFMT_DXT4 */,          FMT_COMPRESSED  },
    { "",                       0,                                     0               },
};

const dword exptbl[] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,0,0,0,0,0,0};

#endif