#ifndef _XPR_H_
#define _XPR_H_

#include <mmsystem.h>

#define TEAMNINJAMODEL		0x80000000
#define TEAMNINJATEXTURE	0x00040001
#define TEAMNINJAVBUFFER	0x00800001

typedef struct XPRCHUNK {
	DWORD magic;
} xprchunk;

typedef struct XPRHEADER {
	DWORD magic;				// 00. dword - XPR0 magic
	DWORD filesize;				// 01. dword - filesize
	DWORD headersize;			// 02. dword - headersize
} xprheader;

typedef struct MDLHEADER {
	DWORD size;					// 00. dword - size of this chunk
	DWORD magic;				// 01. dword - MDL_ magic
	DWORD numobj;				// 02. dword - number of models in xpr
	DWORD numtxt;				// 03. dword - number of textures in xpr
	DWORD pad0;					// 04. dword - 0x00000000 fill
	DWORD num1;					// 05. dword - number of vertexbuffers?
} xprmdlheader;

typedef struct TEXTUREHEADER {
	DWORD offset;
	DWORD pad1;
	DWORD type;
	DWORD pad2;
} xprtextureheader;

typedef struct VBUFFERHEADER {
	DWORD offset;
	DWORD pad1;
} xprvbufferheader;

typedef struct VERTEXINFO {
	DWORD numverts;
	DWORD vertex_offset;
	DWORD numfaces;
	DWORD index_offset;
	DWORD num0;
	DWORD num1;
	DWORD num2;
	DWORD num3;
} vertexinfo;

typedef struct OBJHEADER {			// size: 0xA0 (160)
	DWORD magic;					// 0000: "OBJ"
	DWORD vertex_type;						// 3
	DWORD num0;						// 0004: vertex format type
	DWORD numfaces;					// 0008: 2 ??? (0x00000004)
	vertexinfo vi[2];
	float x,y,z,w;					// tranform?
} xprobjheader;

typedef struct MATERIALBLOCK {		// size: variable
	DWORD header;					// 0.
	DWORD size;						// 1. variable
	DWORD pad02;					// 2.
	DWORD number;					// 3. ?
	float mat_color0[4];			// 4..7 diffuse color?
	float mat_color1[4];			// 8..11
	float mat_color2[4];			// 12..15
	float mat_color3[4];			// 16..19
	float mat_color5[4];			// 20..23
	float power;					// 24  specular power??
	float pad25;					// 25 0x00000001
	DWORD pad26;					// 26 0x00000001
	DWORD tex_no;					// 28 !! texture index !!
	DWORD pad29;					// 29
	DWORD pad30;					// 30
	DWORD pad31;					// 31 +1024
	DWORD pad32;					// 32 
	DWORD pad33;					// 33 
	DWORD pad34;					// 34 
	DWORD pad35;	     			// 35
	DWORD pad36;
	DWORD pad37;
	DWORD pad38;
} xprmaterialblock;

// stride:32 // vertex_type == 0x0000
typedef struct VERTEXFORMAT0 {
	float vx, vy, vz;			// position
	float nx, ny, nz;			// normal
	float u, v;					// texture UV
} xprvertexformat0;

// stride:36 // vertex_type == 0x0001
typedef struct VERTEXFORMAT1 {
	float vx, vy, vz;
	float nx, ny, nz;				// normal??
	float a;
	float u, v;
} xprvertexformat1;

// stride:40 // vertex_type == 0x0002
typedef struct VERTEXFORMAT2 {
	float vx, vy, vz;
	float nx, ny, nz;
	float a, b;
	float u, v;
} xprvertexformat2;

// stride:44 // vertex_type == 0x0003
typedef struct VERTEXFORMAT3 {
	float vx, vy, vz;
	float nx, ny, nz;
	float a, b, c;
	float u, v;
} xprvertexformat3;

const xprvertexsizes[4] = {
	sizeof(VERTEXFORMAT0)/4,
	sizeof(VERTEXFORMAT1)/4,
	sizeof(VERTEXFORMAT2)/4,
	sizeof(VERTEXFORMAT3)/4,
};

#endif