#ifndef _DDS_H_
#define _DDS_H_

#include "common.h"

typedef struct DDSHEADER {
	char  magic[4];				// header
	dword headersize;
	dword ddscaps;
	dword v;
	dword u;
	dword imagesize;
	dword depth;
	dword mipmapcount;
	dword reserved[11];

	dword ddpfsize;				// DDPIXELFORMAT structure
	dword ddpfflags;
	char  ddpffourcc[4];
	dword ddpfrgbbitcount;
	dword ddpfrgbrmask;
	dword ddpfrgbgmask;
	dword ddpfrgbbmask;
	dword ddpfrgbamask;

	dword caps1;				// DDCAPS2
	dword caps2;

	dword reserved1;			// reserved
	dword reserved2;
	dword reserved3;
} ddsheader;

typedef struct DDSFACEBUFFER {
	word numfaces;
	dword tex_no;
	word *faces;
} ddsfacebuffer;

typedef struct DDSOBJECT {
	word numbuckets;
	ddsfacebuffer*	bucket;
} ddsobject;

extern void DdsInit(ddsheader *dds);

#endif